//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.82;

//=============================================================================
/*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.82] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 *
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 *
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 *
 * Dual Wielding
 *
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 *
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 *
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 *
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 *
 * TPB/ATB Active Battle Actor Shifting
 *
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 *
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 *
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 *
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 *
 * VisuMZ_1_BattleCore
 *
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 *
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * === HP Gauge-Related Notetags ===
 *
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 *
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 *
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 *
 * ---
 *
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 *
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 *
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 *
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 *
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 *
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack
 *   - Adds the basic attack command.
 *
 * - Skills
 *   - Displays all the skill types available to the actor.
 *
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 *
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 *
 * - Guard
 *   - Adds the basic guard command.
 *
 * - Item
 *   - Adds the basic item command.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 *
 * - Escape
 *   - Adds the escape command.
 *
 * - Auto Battle
 *   - Adds the auto battle command.
 *
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 *
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 *
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 *
 * ---
 *
 * <Command Require Learn>
 *
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 *
 * ---
 *
 * <Command Require Access>
 *
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 *
 * ---
 *
 * <Command Show Switch: x>
 *
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 *
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 *
 * ---
 *
 * <Command Hide Switch: x>
 *
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 *
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 *
 * ---
 *
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 *
 * ---
 *
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 *
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 *
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 *
 * ---
 *
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 *
 * ---
 *
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 *
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 *
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 *
 * ---
 *
 * <Target: Ally or Enemy>
 *
 * - Used for: Skill, Item Notetags
 * - Allows the player to target allies or enemies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to allies first.
 * - Ignored when used by enemies and will be treated as an ally scope.
 * - Auto-battle actors will also treat this action as an ally scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 *
 * ---
 *
 * <Target: Enemy or Ally>
 *
 * - Used for: Skill, Item Notetags
 * - Allows the player to target enemies or allies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to enemies first.
 * - Ignored when used by enemies and will be treated as an enemy scope.
 * - Auto-battle actors will also treat this action as an enemy scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 *
 * ---
 *
 * <Single or Multiple Select>
 *
 * - Used for: Skill, Item Notetags
 * - Requires an original scope that can select individual targets.
 * - This will allow the skill/item to be able to select either single targets
 *   or multiple targets at once.
 *   - In order to select "all enemies", the player must press the "Page Up"
 *     keyboard button or the visual on screen "All Enemies" button.
 *   - In order to select "all allies", the player must press the "Page Down"
 *     keyboard button or the visual on screen "All Allies" button.
 *   - Those wondering why this isn't regulated to a command left or right of
 *     the enemies and actors is because mouse controls and touch controls
 *     would not be able to select all enemies or all allies that way.
 *   - This can NOT be used with single dead ally scopes.
 * - If there is an enemy with Taunt or Provoke, the option to select
 *   "All Enemies" does not become possible.
 * - The enemy AI and Auto-Battle actor AI will NOT make use of the ability to
 *   toggle between single and multiple target scopes. They will only use the
 *   single target versions of these skills.
 *
 * ---
 *
 * <Disperse Damage>
 *
 * - Used for: Skill, Item Notetags
 * - This will cause any damage dealt by this skill to be split equally amongst
 *   all targets of the skill including repeats.
 *   - For basic attacks, any damage reduction added attack trait totals will
 *     by reverted.
 * - This does NOT have to be used with <Single or Multiple Select> notetag and
 *   can be used by itself for an "All" scope, making the skill/item deal less
 *   damage if there's more enemies and more damage if there's less enemies.
 *
 * ---
 *
 * <Cannot Target User>
 *
 * - Used for: Skill, Item Notetags
 * - This will cause the action to be unable to select the user as the target.
 * - This is not a targeting scope. Instead, it is used in addition to any
 *   other targeting scopes out there.
 * - When used with "All" scopes, the user is removed from the target pool.
 * - This is also applied outside of battle.
 * - If the user somehow enters the target pool, the user is then replaced by
 *   a random ally found in the party.
 *
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 *
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * === Life Steal-Related Notetags ===
 *
 * ---
 *
 * <HP Life Steal: x%>
 * <MP Life Steal: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes this skill/item to have Life Steal properties, allowing the user to
 *   take x% of the HP/MP Damage as recovered HP/MP.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take MP from dealt MP damage.
 * - Replace 'x' with a number representing the percentage of the dealt damage
 *   used as HP/MP recovery.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 *
 * ---
 *
 * <HP Life Steal Certain Hit: +x%>
 * <HP Life Steal Physical Hit: +x%>
 * <HP Life Steal Magical Hit: +x%>
 *
 * <HP Life Steal Certain Hit: -x%>
 * <HP Life Steal Physical Hit: -x%>
 * <HP Life Steal Magical Hit: -x%>
 *
 * <MP Life Steal Certain Hit: +x%>
 * <MP Life Steal Physical Hit: +x%>
 * <MP Life Steal Magical Hit: +x%>
 *
 * <MP Life Steal Certain Hit: -x%>
 * <MP Life Steal Physical Hit: -x%>
 * <MP Life Steal Magical Hit: -x%>
 *
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - The related battler's various trait properties can have passive life steal
 *   properties that will trigger upon using skills/items with matching hit
 *   types regardless of whether or not the skill/item innately has Life Steal.
 *   - Notetag variants with "Certain Hit" will only trigger from "Certain Hit"
 *     skill and item types. Same with "Physical" and "Magical" variants.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the additive stacking percentage
 *   boost of the dealt damage used as HP/MP recovery. The effects will stack
 *   additively with other trait objects.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 *
 * ---
 *
 * <Cancel Life Steal>
 *
 * <Cancel HP Life Steal>
 * <Cancel MP Life Steal>
 *
 * - Used for: Skill, Item Notetags
 * - Prevents this skill from allowing Life Steal effects to occur including
 *   the passive life steal calculators from the skill/item user.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 *
 * ---
 *
 * <Guard Life Steal>
 *
 * <Guard HP Life Steal>
 * <Guard MP Life Steal>
 *
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will prevent
 *   the Life Steal effects from taking effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 *
 * ---
 *
 * <Disarm Life Steal>
 *
 * <Disarm HP Life Steal>
 * <Disarm MP Life Steal>
 *
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - Makes the related battler unable to HP/MP Life Steal regardless of the
 *   skill/item and its related properties like equipment.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 *
 * ---
 *
 * <Negative Life Steal>
 *
 * <Negative HP Life Steal>
 * <Negative MP Life Steal>
 *
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will invert
 *   the healing properties of Life Steal, causing the Life Steal user to
 *   instead take HP/MP damage.
 *   - This does NOT heal the target related battler.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 *
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 *
 * <Auto Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 *
 * ---
 *
 * <Bypass Auto Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - This notetag is used for the game devs that have the Action Sequence
 *   Plugin Parameter "Auto Notetag" on for applying <Custom Action Sequence>
 *   to everything.
 * - This will allow items and skills to be able to launch their common
 *   events from the menu scene regardless of the inherent restriction to
 *   prevent action sequence based skills/items with common events from
 *   launching.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 *
 * ---
 *
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 *
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 *
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 *
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 *
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 *
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 *
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 *
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 *
 * ---
 *
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 *
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 *
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 *
 * ---
 *
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 *
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 *
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 * - This does NOT change the image size. This only changes the HITBOX size.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 *
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 *
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 *
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 *
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 *
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 *
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * === Battle Layout-Related Notetags ===
 *
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 *
 * ---
 *
 * <Layout: type>
 * <Battle Layout: type>
 *
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - Those with VisuMZ_3_FrontviewBattleUI can use 'frontview'.
 * - Those with VisuMZ_3_SideviewBattleUI can use 'sideview'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 *
 * ---
 *
 * === Troop Size Tags ===
 *
 * ---
 *
 * <Extend: x>
 * <Extend: x, x, x>
 *
 * - Used for: Troop Name Tags and Troop Comment Tags
 * - Adds enemies from another troop to the current troop.
 * - Enemies from another troop will retain their database positions.
 * - Replace 'x' with the ID of the database troop entry you wish to add enemy
 *   members from.
 *   - Insert multiple x's to add from more troops.
 * - Extended troop members will be added in the order they're listed.
 * - Be cautious of how many enemies you add as too many will lag the battle
 *   system. We are not responsible for frame drops due to this.
 *
 * ---
 *
 * === Troop Comment Tags ===
 *
 * Place these tags inside of a comment found in a troop page's event list.
 *
 * ---
 *
 * <Once Parallel When Start Battle>
 *
 * - Used for: Troop Page Comment Tags
 * - Causes the troop page to immediately load the moment the battle scene
 *   begins to fade in (not after it fades in). This is faster than a turn 0
 *   condition troop page. Troop page conditions are ignored.
 * - This can be used for things like the Action Sequence Camera plugin, the
 *   Visual Battle Environment plugin, and/or initial battle poses and such in
 *   order to provide a near seamless battle transition experience.
 * - This does NOT trigger when coming out of the options menu or party menu.
 * - This WILL trigger when going from battle to battle nonstop via plugins
 *   like VisuStella MZ's Chain Battles.
 * - When actors are moving towards their home positions, it will take around
 *   30 frames by default. Use this information however you like.
 *
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * === Action Sequences - Angle ===
 *
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Balloon Animation
 * - Plays a balloon animation on target(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Balloon Type:
 *   - What kind of balloon should be played on target(s)?
 *
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 *
 * ---
 *
 * ANIM: Balloon Icon (Single)
 * - Plays a balloon animation using an icon on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 *
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 *
 * ---
 *
 * ANIM: Balloon Icon (Range)
 * - Plays a balloon animation an icon range on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Starting Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 *
 *   Ending Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 *
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 *
 * ---
 *
 * ANIM: Balloon Icon (Specific)
 * - Plays a balloon animation with specific icons on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Icons:
 *   - Insert the ID(s) of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 *
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 *
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 *
 * ---
 *
 * ANIM: Guard Animation
 * - Plays the animation associated with the user's guard action (if any).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Item Animation
 * - Plays the animation associated with a specific item.
 *
 *   Item ID:
 *   - Which item ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 *
 *   Animation ID:
 *   - Plays this animation.
 *
 *   Coordinates:
 *
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 *
 *   Mirror Animation?:
 *   - Mirror the animation?
 *
 *   Mute Animation?:
 *   - Mute the animation?
 *
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Show Animation JS
 * - Plays the a specific animation on unit(s).
 * - Uses JavaScript to determine animation ID.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   JS: Animation ID:
 *   - Select which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Skill Animation
 * - Plays the animation associated with a specific skill.
 *
 *   Skill ID:
 *   - Which skill ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 *
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 *
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Cutins ===
 *
 * Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * ---
 *
 * CUTIN: Add Visual Cutin Effect
 * - Adds the Visual Cutin Effect using these desired settings.
 * - Only one of each cutin-style type can be present at a time.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Basic Settings:
 *
 *     Cutin Style Type:
 *     - What Visual Cutin Effect style type do you wish to use?
 *     - Only one of each cutin-style type can be present.
 *     - Refer to VisuMZ wiki for visuals on styles.
 *
 *     Portrait Target:
 *     - Select unit(s) to grab the Visual Cutin Effect portrait data from.
 *     - First unit will be used to make portrait.
 *
 *     Parallax Filename:
 *     - Pick a parallax to use for the Visual Cutin Effect.
 *     - Pick (None) to not use a parallax.
 *
 *     Background Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 *   Extra Settings:
 *   - Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 *   - An explanation for these settings are found in the Visual Cutin Effect
 *     help file and documentation.
 *   - Extra parameters are added for Parallax Scroll Inversion when the target
 *     is an enemy.
 *
 *   Wait for Entrance:
 *   - Wait until cutin entrance is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (All)
 * - Ends all Visual Cutin Effects currently present.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (Type)
 * - Ends the Visual Cutin Effect with the matching type.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Cutin Style Type:
 *   - What Visual Cutin Effect style type do you wish to end?
 *
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: Wait for Cutin Entrance
 * - Wait until all cutin entrances are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 * ---
 *
 * CUTIN: Wait for Cutin Exit
 * - Wait until all cutin exits are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * === Action Sequences - Grid ===
 *
 * These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * ---
 *
 * GRID: Action Animation at Node
 * - Plays action animation at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 *
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * GRID: Add Passive State(s) to Node
 * - Adds Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to add as a Passive State.
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to add the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Passive State(s) to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Passive State(s) to.
 *
 * ---
 *
 * GRID: Add Trigger to Node
 * - Adds Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger!
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Skill ID:
 *   - Select which Skill ID(s) to add as the trigger.
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 *
 * ---
 *
 * GRID: Animation ID at Node
 * - Plays specific animation ID at target node.
 *
 *   Animation ID:
 *   - Play this animation at target node.
 *
 *     Mirror?:
 *     - Mirror this animation?
 *
 *     Mute?:
 *     - Mute this animation?
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 *
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * GRID: Animation JS at Node
 * - Uses JS to calculate which animation to play at target node.
 *
 *   JS: Animation ID:
 *   - Calculate which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 *
 *     Mirror?:
 *     - Mirror this animation?
 *
 *     Mute?:
 *     - Mute this animation?
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 *
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * GRID: Animation Type at Node
 * - Plays certain animation type at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Type:
 *   - What is the animation type you would like to play?
 *     - Attack
 *     - Guard
 *     - Item
 *     - Skill
 *
 *     Slot (Attack Type):
 *     - Which weapon slot to get this data from?
 *     - Main-hand weapon is weapon slot 1.
 *
 *     Item ID (Item Type):
 *     - Which item ID will the animation come from?
 *
 *     Skill ID (Skill Type):
 *     - Which skill ID will the animation come from?
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 *
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * GRID: Move Target(s) In Direction
 * - Moves target(s) in a specific direction to other Nodes.
 * - Requires VisuMZ_2_BattleGridSystem!
 * - This will bypass the "once per action" condition used for both the
 *   <rule Move User Node direction: x> & <rule Move Target Node direction: x>
 *   notetags as this is not a notetag effect.
 *
 *   Targets:
 *   - Select unit(s) to move.
 *
 *   Movement Type:
 *   - Select the Movement type rulings.
 *   - See VisuMZ_2_BattleGridSystem help file for details.
 *
 *     Direction:
 *     - Select the movement direction.
 *
 *     Distance:
 *     - The number of nodes to be moved.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Input the number representing the frames used to move.
 *
 *   Silent Change?:
 *   - Silent: Discreet changes shown. More apparent later.
 *   - Visual: Instant changes shown.
 *
 * ---
 *
 * GRID: Pull To Target Node
 * - Pulls battlers towards target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to pull on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       pull to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       pull to.
 *
 *   Strength:
 *   - Input the strength level of the pull.
 *
 *   Duration:
 *   - Input the number representing the frames used to move.
 *
 * ---
 *
 * GRID: Push From Target Node
 * - Pushes battlers away from target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to push from?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       push from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       push from.
 *
 *   Strength:
 *   - Input the strength level of the push.
 *
 *   Duration:
 *   - Input the number representing the frames used to move.
 *
 * ---
 *
 * GRID: Remove All Passive States from Node
 * - Removes all Passive State effects at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to clear the Node for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Passive States from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Passive States from.
 *
 * ---
 *
 * GRID: Remove Passive State(s) from Node
 * - Remove Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to remove as a Passive State.
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to remove the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to remove
 *       a Passive State(s) from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to remove
 *       a Passive State(s) from.
 *
 * ---
 *
 * GRID: Remove Trigger from Node
 * - Removes Trigger at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to clear Triggers for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Triggers from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Triggers from.
 *
 * ---
 *
 * === Action Sequences - Horror Effects ===
 *
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * === Action Sequences - Impact ===
 *
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 *
 * IMPACT: Bizarro Inversion
 * - Swaps blue/red colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Bizarro?:
 *   - Enable Bizarro Inversion effect?
 *
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Desaturation
 * - Desaturates all colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Desaturate?:
 *   - Enable Desaturation effect?
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Negative Inversion
 * - Inverts all the colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Negative?:
 *   - Enable Negative Inversion effect?
 *
 * ---
 *
 * IMPACT: Oversaturation
 * - Oversaturates colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Oversaturate?:
 *   - Enable Oversaturation effect?
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 *
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 *
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Time Scale
 * - Adjust time to go faster or slower!
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Scale:
 *   - Adjusts how fast/slow time goes.
 *   - 1.00 is normal. Lower is slower. Higher is faster.
 *
 * ---
 *
 * IMPACT: Time Stop
 * - Stops time for a set amount of milliseconds.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Milliseconds:
 *   - How many milliseconds should time stop for?
 *   - 1000 milliseconds = 1 second.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 *
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Inject ===
 *
 * These Action Sequences are related to injecting sprite animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 *
 * INJECT: Animation Begin
 * - Injects and plays a whole spritesheet animation.
 * - The spritesheet animation will play over the battler until it is finished.
 * - The battler's original sprite will be invisible until finished.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to inject the animation on.
 *
 *   Filename:
 *   - Select the animation spritesheet file.
 *   - Located in the /img/sv_actors/ folder.
 *
 *     Horizontal Cells:
 *     - How many horizontal cells (or columns) are there?
 *
 *     Vertical Cells:
 *     - How many vertical cells (or rows) are there?
 *
 *     Frame Delay:
 *     - How many frames are played inbetween cells?
 *
 *     Smooth Bitmap?:
 *     - Smooth the spritesheet graphic?
 *
 *   Offset:
 *
 *     Offset X:
 *     - Offsets the X position of the injected animation.
 *     - Negative: left. Positive: right.
 *
 *     Offset Y:
 *     - Offsets the Y position of the injected animation.
 *     - Negative: up. Positive: down.
 *
 * ---
 *
 * INJECT: Animation End
 * - Stops and ends any injected animations on target(s).
 * - Any inject animation will be prematurely terminated.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to stop injected animation(s).
 *
 * ---
 *
 * INJECT: Animation Pause/Resume
 * - Pauses/resumes any injected animations on target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to pause/resume injected animation(s).
 *
 *   Pause?:
 *   - Pause the injected animation?
 *
 * ---
 *
 * INJECT: Wait For Injected Animation
 * - Waits for injected animations to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Active Chain Input Disable
 * - Disables input for Active Chain Skills at this time.
 * - Requires VisuMZ_3_ActiveChainSkills!
 *
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s).
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 *
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 *
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 *
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 *
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 *
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 *
 *   Charging:
 *
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 *
 *   Casting:
 *
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 *
 * ---
 *
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 *
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 *
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 *
 * ---
 *
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 *
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 *
 * ---
 *
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 *
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 *
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 *
 * ---
 *
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 *
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 *
 * ---
 *
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 *
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 *
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 *
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 *
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 *
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 *
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 *
 * ---
 *
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 *
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 *
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 *
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 *
 * ---
 *
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 *
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 *
 * MECH: Emulate Attack Effect
 * - Emulate an "Action Effect" but using a the user's attack skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 *
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Emulate Guard Effect
 * - Emulate an "Action Effect" but using a the user's guard skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 *
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Emulate Item Effect
 * - Emulate an "Action Effect" but using a specific item instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 *
 *   Item ID:
 *   - Which item ID will be emulated?
 *
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Emulate Skill Cost
 * - Pick a skill for target(s) to emulate paying the cost of.
 * - Lets you cause characters to perform paying the costs of a specific skill
 *   without needing to actually use them.
 * - This will include Skill Cooldowns and Limited Skill Uses.
 *
 *   Skill ID:
 *   - Which skill ID will have its cost paid for?
 *   - Use 0 for current action's skill.
 *
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 *
 * ---
 *
 * MECH: Emulate Skill Effect
 * - Emulate an "Action Effect" but using a specific skill instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 *
 *   Skill ID:
 *   - Which skill ID will be emulated?
 *
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 *
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 *
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 *
 * ---
 *
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 *
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 *
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 *
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 *
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 *
 * ---
 *
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 *
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 *
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 *
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 *
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 *
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 *
 * ---
 *
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 *
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 *
 * ---
 *
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 *
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 *
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 *
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s).
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 *
 * MECH: State Turns Change By
 * - Changes target(s) state turns by an amount.
 * - Requires VisuMZ_1_SkillsStatesCore!
 *
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 *
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 *
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 *
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 *
 * ---
 *
 * MECH: State Turns Change To
 * - Changes target(s) state turns to a specific value.
 * - Requires VisuMZ_1_SkillsStatesCore!
 *
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 *
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 *
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 *
 *   Auto-Add State?:
 *   - Automatically adds state if target(s) does not have it applied?
 *
 * ---
 *
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 *
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 *
 *     Targets:
 *     - Select unit(s) to become exploited.
 *
 *     Force Exploitation:
 *     - Force the exploited status?
 *
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 *
 *     Force Exploitation:
 *     - Force the exploiter status?
 *
 * ---
 *
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 *
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 *
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 *
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 *
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 *
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 *
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 *
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 *
 * ---
 *
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 *
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 *
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 *
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To JS Coordinates
 * - Change home position(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s)'s new home
 *     position.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face JS Coordinates
 * - Causes the unit(s) to face specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to face
 *     towards.
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To JS Coordinates
 * - Moves unit(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to move to.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Projectiles ===
 *
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 *
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 *
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Wait For Animation?:
 *     - Wait for animation to finish before going to the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 *     Effect Emulation:
 *
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 *
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 *
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 *
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 *
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 *
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 *     Effect Emulation:
 *
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 *
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 *
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 *
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 *
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 *
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 *
 *     Effect Emulation:
 *
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 *
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 *
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 *
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * === Action Sequences - Skew ===
 *
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * === Action Sequences - Voice ==
 *
 * ---
 *
 * VOICE: Common Line
 * - Plays a common voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line:
 *   - What voice line do you wish to play?
 *
 * ---
 *
 * VOICE: Play Special Line
 * - Plays a special voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line Type:
 *   - What voice line type do you wish to play?
 *     - Action Name
 *     - Chant Line
 *     - Item Name
 *     - Skill Name
 *     - Spell Name
 *     - Unique Lines
 *
 *   Name / Letter:
 *   - What voice letter/name do you want to play?
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 *
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 *
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 *
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 *
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 *
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 *
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 *
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 *
 *   Startup Name:
 *   - Command name of the option.
 *
 *   Style Name:
 *   - Command name of the option.
 *
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 *
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 *
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 *
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 *
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 *
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 *
 *     Items & Equips Core:
 *
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 *
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 *
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 *
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 *
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 *
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 *
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Formulas
 *
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 *
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 *
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 *
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 *
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 *
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 *
 *   Turn End Buffs Expire?:
 *   - Normally, buffs expire after all actions end.
 *   - But here, you can have buffs expire on turn end.
 *
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 *
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 *
 * Common Events (on Map)
 *
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 *
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 *
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 *
 * ---
 *
 * Switches
 *
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 *
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 *
 * ---
 *
 * Variables
 *
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 *
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 *
 * ---
 *
 * JS: Battle-Related
 *
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 *
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 *
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 *
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 *
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 *
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 *
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 *
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 *
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 *
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 *
 *   Default:
 *   - Shows actor faces in Battle Status.
 *
 *   List:
 *   - Lists actors in Battle Status.
 *
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 *
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 *
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 *
 *   Show Faces:
 *   - Shows faces in List Style?
 *
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 *
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 *
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 *
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 *
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 *
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 *
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 *
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 *
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 *
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 *
 * Status Window Elements
 *
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 *
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 *
 *   Window Skin:
 *
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 *
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 *
 *   Selectable Background:
 *
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 *
 *   Attachments:
 *
 *     Back Attachment:
 *
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 *
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 *
 *     Front Attachment:
 *
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 *
 * ---
 *
 * UI Elements
 *
 *   Anti-Tint UI?
 *   - Prevent UI Elements from being tinted?
 *   - This prevents UI Elements such as HP Gauges, Enemy Names, Battle Cursor,
 *     and Weakness Display from being affected by screen tint.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 *
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 *
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 *
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 *
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 *
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 *
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 *
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 *
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 *
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 *
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 *
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 *
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 *
 *   Show Counter?:
 *   - Display counter text?
 *
 *   Show Reflect?:
 *   - Display magic reflection text?
 *
 *   Show Substitute?:
 *   - Display substitute text?
 *
 * ---
 *
 * Action Results
 *
 *   Show No Effect?:
 *   - Display no effect text?
 *
 *   Show Critical?:
 *   - Display critical text?
 *
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 *
 *   Show HP Damage?:
 *   - Display HP Damage text?
 *
 *   Show MP Damage?:
 *   - Display MP Damage text?
 *
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 *
 *   Show Added States?:
 *   - Display added states text?
 *
 *   Show Removed States?:
 *   - Display removed states text?
 *
 *   Show Current States?:
 *   - Display the currently affected state text?
 *
 *   Show Added Buffs?:
 *   - Display added buffs text?
 *
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 *
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 *
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 *
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't
 *
 * ---
 *
 * Command Window
 *
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 *
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 *
 *   Fight Icon:
 *   - The icon used for the Fight command.
 *
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 *
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 *
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 *
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 *
 *     Options Icon:
 *     - The icon used for the Options command.
 *
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 *
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 *
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 *
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 *
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 *
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 *   Options:
 *   - Text displayed when selecting the Options command.
 *
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 *
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 *
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 *
 *   Item Icon:
 *   - The icon used for the Item command.
 *
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 *
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack
 *       - Adds the basic attack command.
 *
 *     - Skills
 *       - Displays all the skill types available to the actor.
 *
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 *
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 *
 *     - Guard
 *       - Adds the basic guard command.
 *
 *     - Item
 *       - Adds the basic item command.
 *
 *     - Escape
 *       - Adds the escape command.
 *
 *     - Auto Battle
 *       - Adds the auto battle command.
 *
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 *
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 *
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 *
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 *
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 *
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 *
 *   Items:
 *   - Text displayed when selecting the item command.
 *
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Multi-Target Windows Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters adjust how the Multi-Target Windows appear
 * in battle. These windows are visible when selecting an enemy or actor while
 * using a skill/item that has the <Single or Multiple Select> notetag.
 *
 * Those wondering why this isn't regulated to a command left or right of the
 * enemies and actors is because mouse controls and touch controls would not be
 * able to select all enemies or all allies that way.
 *
 * ---
 *
 * Properties
 *
 *   Window Width:
 *   - What is the width used for the Multi-Target Window?
 *
 *   Background Type:
 *   - Select background type for these windows.
 *
 *   Show Button:
 *   - Shows the keyboard/controller button to press?
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * Vocab
 *
 *   All Actors:
 *   - What is the text used for the "All Actors" button?
 *
 *   All Enemies:
 *   - What is the text used for the "All Enemies" button?
 *
 * ---
 *
 * Offsets > Actor Offsets
 * Offsets > Enemy Offsets
 *
 *   Offset X:
 *   - Offsets the button's x position.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - Offsets the button's y position.
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 *
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 *
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 *
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 *
 *   Shake Flinch:
 *   - Perform a shake flinch when taking damage?
 *
 *     Max Duration:
 *     - Maximum duration a shake flinch can have.
 *     - This is reduced relative to the amount of damage taken.
 *
 *     Max Power:
 *     - The power rating of a shake flinch at full damage.
 *     - This is reduced relative to the amount of damage taken.
 *
 * ---
 *
 * Sideview Battlers
 *
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 *
 *   Offset X:
 *   - Offsets X position where actor is positioned.
 *   - Negative values go left. Positive values go right.
 *
 *   Offset Y:
 *   - Offsets Y position where actor is positioned.
 *   - Negative values go up. Positive values go down.
 *
 *   Motion Speed:
 *   - The number of frames in between each motion.
 *
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 *
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 *
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 *
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 *
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 *
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 *
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 *
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 *
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 *
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 *
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 *
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 *
 * ---
 *
 * Name:
 *
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 *
 *   Font Size:
 *   - Font size used for enemy names.
 *
 *   Name Position:
 *
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 *
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 *
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 *
 *   Name Visibility:
 *
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 *
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 *
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 *
 * ---
 *
 * Sideview Battlers
 *
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 *
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 *
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 *
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 *
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 *
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 *
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 *
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 *
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 *
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 *
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 *
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 *
 *   Animation Duration:
 *   - How many frames should gauges animate themselves?
 *   - Default: 20 frames.
 *
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 *
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 *
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 *
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 *
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 *
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 *
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 *
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 *
 * Quality of Life
 *
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 *
 * ---
 *
 * Cast Animations
 *
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 *
 *   Physical:
 *   - Cast animation for Physical skills.
 *
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 *
 *   Counter Back:
 *   - Play back the attack animation used?
 *
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 *
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 *
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 *
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 *
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 *
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 *
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 *
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 *
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 *
 * If you are using this plugin, credit the following people in your game:
 *
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 *
 * Version 1.82: March 14, 2024
 * * Bug Fixes!
 * ** Home movement changes did not acknowledge actor and enemy offset X/Y
 *    positions. This should now be reflected properly. Fix made by Irina.
 * ** Fixed a bug where in active TPB/ATB, revived actors may not resume normal
 *    motions after collapsing. Fix made by Olivia.
 *
 * Version 1.81: February 15, 2024
 * * Bug Fixes!
 * ** Fixed a bug that would cause active TPB inputting actors to not show
 *    their damage or evasion motions. Fix made by Olivia.
 * ** Fixed a bug that would cause a crash upon motion changes. Fix by Olivia.
 * ** Fixed an incorrect spelling of "Anger" for "ANIM: Balloon Animation" that
 *    prevented it from working properly.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Show Animation JS
 * **** Plays the a specific animation on unit(s). Uses JavaScript to determine
 *      animation ID.
 * ** New Action Sequences added for future plugin: VisuMZ_2_BattleGridSystem
 * *** GRID: Action Animation at Node
 * *** GRID: Add Passive State(s) to Node
 * *** GRID: Add Trigger to Node
 * *** GRID: Animation ID at Node
 * *** GRID: Animation JS at Node
 * *** GRID: Animation Type at Node
 * *** GRID: Move Target(s) In Direction
 * *** GRID: Pull To Target Node
 * *** GRID: Push From Target Node
 * *** GRID: Remove All Passive States from Node
 * *** GRID: Remove Passive State(s) from Node
 * *** GRID: Remove Trigger from Node
 * *** GRID: Teleport To Node
 * *** GRID: Traverse To Node
 * **** Requires the future plugin VisuMZ_2_BattleGridSystem!
 * **** Read the help section for more information on these.
 *
 * Version 1.80: January 18, 2024
 * * Bug Fixes!
 * ** Fixed a crash that would occur with <Disperse Damage> when used outside
 *    of battle. Fix made by Irina.
 * ** Fixed a crash that would occur with certain enemy graphics when images
 *    used for them would disappear. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Guard Animation
 * *** ANIM: Item Animation
 * *** ANIM: Skill Animation
 * **** Plays the animation associated with the user's guard action (if any),
 *      or a specific item/skill.
 * *** MECH: Emulate Attack Effect
 * *** MECH: Emulate Guard Effect
 * *** MECH: Emulate Item Effect
 * *** MECH: Emulate Skill Effect
 * **** Emulate an "Action Effect" but using a the user's attack skill, guard
 *      skill, specific item, or specific skill instead of the current action.
 * **** Essentially lets you perform the mechanics of another action without
 *      having to use another action or needing to pay that action's costs.
 * *** MECH: Emulate Skill Cost
 * **** Pick a skill for target(s) to emulate paying the cost of.
 * **** Includes cooldowns and limited uses.
 * *** MECH: State Turns Change By
 * *** MECH: State Turns Change To
 * **** Changes target(s) state turns by an amount/to a certain value.
 * **** Requires VisuMZ_1_SkillsStatesCore!
 * *** Projectile action sequences have new Extra Features!
 * **** See v1.08 changes for VisuMZ_3_ActSeqProjectiles.
 *
 * Version 1.79: December 14, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Arisu:
 * *** ANIM: Balloon Animation
 * **** Plays a balloon animation on target(s).
 * *** ANIM: Balloon Icon (Single)
 * *** ANIM: Balloon Icon (Range)
 * *** ANIM: Balloon Icon (Specific)
 * **** Plays a balloon animation using an icon on target(s).
 * **** Requires VisuMZ_4_IconBalloons!
 *
 * Version 1.78: October 12, 2023
 * * Bug Fixes!
 * ** Fixed a bug that is caused by using the actor escape command not escaping
 *    properly in battle and causing a freeze. Fix made by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Parameters > Mechanics > Turn End Buffs Expire?
 * **** Normally, buffs expire after all actions end.
 * **** But here, you can have buffs expire on turn end.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 *
 * Version 1.77: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug where for TPB, actions aimed at dead targets would not
 *    redirect to suitable targets. Fix made by Olivia.
 * ** Fixed a bug where dual wielding would not use a weapon if it was equipped
 *    in the second weapon slot if the first weapon slot was empty. Fix made
 *    by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Added compatibility for VisuStella MZ Battle Voices Action Sequences.
 * * Documentation Update!
 * ** Help file updated for new features.
 *
 * Version 1.76: July 13, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia and sponsored by NSG:
 * *** MOVE: Change Home To JS Coordinates
 * **** Change home position(s) to specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Face JS Coordinates
 * **** Causes the unit(s) to face specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Move To JS Coordinates
 * **** Moves unit(s) to specified JS Coordinates. Sideview-only! Uses JS!
 *
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by Anon:
 * *** <HP Life Steal: x%>
 * *** <MP Life Steal: x%>
 * *** <HP Life Steal hitType: +/-x%>
 * *** <MP Life Steal hitType: +/-x%>
 * *** <Cancel Life Steal>
 * *** <Guard Life Steal>
 * *** <Disarm Life Steal>
 * *** <Negative Life Steal>
 * **** Life Steal properties involving HP/MP are now added. They will restore
 *      a portion of the dealt HP/MP damage to the target.
 * **** This is a different mechanic from Drain HP/Drain MP and cannot be used
 *      together to prevent clashing.
 * **** Read the help file for more information.
 *
 * Version 1.74: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash if your basic attack skill somehow
 *    manages to target neither an enemy nor an actor. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Auto-action sequence for jumping forward and attacking is now reinstated
 *    so that it's only disabled when the target and user are on the same side.
 *    If there is no target, a jump still occurs for visual player feedback.
 *    Update made by Olivia.
 * * New Features!
 * ** New notetag effect added by Olivia and sponsored by AndyL:
 * *** <Cannot Target User>
 * **** This will cause the action to be unable to select the user as target.
 * **** This is not a targeting scope. Instead, it is used in addition to any
 *      other targeting scopes out there.
 *
 * Version 1.73: January 20, 2023
 * * Bug Fixes!
 * ** Active TPB custom action sequences will no longer play differently due to
 *    queued inputting actors causing motion refreshes. Fix made by Arisu.
 * ** Corrected and updated Anti-Tint UI animation offsets for MV animations.
 *    Fix made by Irina.
 * ** Fixed a problem with Sideview Battlers not working properly. Fix made
 *    by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for to add the following text to the <Target: x>
 *    notetag entries in order to avoid confusion.
 * *** This will overwrite the existing database scope and ignore the
 *     database's existing scope in favor of this.
 * * Feature Update!
 * ** <Extend: x> Troop Name Tag is now also usable as a Troop Comment Tag.
 * ** Action Sequence targeting has been updated with two new types "special"
 *    and "special x", to be used for future plugins.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by AndyL:
 * *** <Target: Ally or Enemy>
 * *** <Target: Enemy or Ally>
 * **** Allows the player to target allies or enemies with the skill/item.
 * **** See help file for more information.
 * *** <Single or Multiple Select>
 * **** This will allow the skill/item to be able to select either single
 *      targets or multiple targets at once.
 * **** See help file for more information.
 * *** <Disperse Damage>
 * **** This will cause any damage dealt by this skill to be split equally
 *      amongst all targets of the skill including repeats.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Multi-Target Windows
 * **** Settings that alter the Multi-Target Windows in battle.
 *
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a transformation of a sideview enemy to a static enemy and back not
 *    working properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > HP Gauges > Settings > Animation Duration
 * **** How many frames should gauges animate themselves? Default: 20 frames.
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Power
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Duration
 * **** These new plugin parameters will cause targets that take HP damage to
 *      shake (in addition to a regular flinch) to provide better visual
 *      feedback to the player.
 * **** Shake Flinch will be kept disabled by default and only turned on when
 *      you want it to be.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 *
 * Version 1.71: November 10, 2022
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 *
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** Fixed a problem with the "Border" style where if a battle portrait
 *    changed midway through the battle, the portrait shown didn't actually
 *    update properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** MECH: Active Chain Input Disable
 * **** Disables input for Active Chain Skills at this time.
 * **** Requires VisuMZ_3_ActiveChainSkills!
 * ** New Plugin Parameter added by Olivia and sponsored by Anon:
 * *** Plugin Parameters > Damage Settings > Popups > End Battle Show?
 * **** Show or hide popups upon victory or escape?
 * **** Used to hide battle-state removal popups.
 *
 * Version 1.69: September 7, 2022
 * * Compatibility Update!
 * ** Better compatibility with VisuMZ Active Chain Skills.
 * ** Compatibility will be seen with VisuMZ_3_ActiveChainSkills version 1.02.
 * * Documentation Update!
 * ** Added notes to the following Action Sequences:
 * *** MOTION: Clear Freeze Frame and MOTION: Freeze Motion Frame
 * **** Only applies to sprite sheets.
 * **** Does NOT work with Dragonbones.
 * **** Use "DB: Dragonbones Time Scale" instead.
 * * Feature Update!
 * ** Reduced MV Animation misalignment when Screen Resolution does not match
 *    the UI Area Resolution. Update by Arisu.
 * ** Command Remember will now remember the locations of single skills. Update
 *    made by Olivia.
 *
 * Version 1.68: August 4, 2022
 * * Feature Update!
 * ** Damage popups are now automatically cleared upon starting battles. This
 *    is to ensure that, if for some reason, residual damage popup requests
 *    will not be retained. Update made by Olivia.
 *
 * Version 1.67: July 28, 2022
 * * Feature Updates!
 * ** Rounding window coordinates have been added for for 'XP' and 'Portrait'
 *    styles when window sizes happen to land on non-divisible numbers. Update
 *    made by Irina.
 * ** Enemy name position rounding is now enforced. Update made by Irina.
 *
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused the various Battleback Scaling JS custom plugin
 *    parameters to not work properly. Fix made by Irina.
 *
 * Version 1.65: July 7, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Automatic action motions for HP and MP Recovery (Certain Hit type) will
 *    now use the "skill" cast SV animation instead of attack animation to
 *    better match the default RPG Maker MZ cast animation. Update by Olivia.
 * * New Features!
 * ** New troop name tag added by Olivia:
 * *** <Extend: x> and <Extend: x, x, x>
 * **** Adds enemies from another troop to the current troop.
 * **** Enemies from another troop will retain their database positions.
 * **** Extended troop members will be added in the order they're listed.
 * **** Be cautious of how many enemies you add as too many will lag the battle
 *      system. We are not responsible for frame drops due to this.
 *
 * Version 1.64: June 16, 2022
 * * Bug Fixes!
 * ** "All Skills" battle command should now work with the updated version of
 *    VisuMZ Skills & States Core. Fix madde by Olivia.
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 *
 * Version 1.63: May 26, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** HP Gauge sprite now properly synchs with battler location.
 * * New Features!
 * ** New Action Sequence Effects added by Irina and sponsored by MirageV:
 * *** INJECT action sequence series
 * **** See the Action Sequence Impact changelog for details.
 *
 * Version 1.62: April 22, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 *
 * Version 1.61: April 14, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Impact Effects added by Irina and collaborating with Manu Gaming!
 * *** Impact: Bizarro Inversion
 * *** Impact: Desaturation
 * *** Impact: Negative Inversion
 * *** Impact: Oversaturation
 * *** Impact: Time Scale
 * *** Impact: Time Stop
 *
 * Version 1.60: April 7, 2022
 * * Bug Fixes!
 * ** <Bypass Soft Damage Cap> notetag should no longer cause crashes. Fix made
 *    by Olivia.
 * * Feature Update!
 * ** Removed one of the forced log window clear events that have made log
 *    window messages impossible to utilize for certain settings. Update made
 *    by Olivia.
 *
 * Version 1.59: March 31, 2022
 * * Bug Fixes!
 * ** Escape failure will no longer trigger Post-Battle Common Events. Fix
 *    made by Arisu.
 *
 * Version 1.58: March 24, 2022
 * * Documentation Update:
 * ** Added extra clarity to <Sideview Size: width, height> notetag:
 * *** This does NOT change the image size. This only changes the HITBOX size.
 * * Feature Update!
 * ** Added failsafes to prevent battlers from moving to non-finite coordinates
 *    if calculations are made for non-existent targets. Updated by Olivia.
 * ** Regeneration timing for TPB-based battle systems will now occur based on
 *    individual turn counts instead of global turn counts for initial turn 0
 *    checks. Updated by Olivia.
 *
 * Version 1.57: February 17, 2022
 * * Feature Update!
 * ** Adjusted the offset properties for the anti-tint UI container to properly
 *    match the UI offsets if the anti-tint were to be off. Update by Irina.
 *
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Once Parallels for battle now operate outside of the battle process.
 *    Update made by Olivia.
 * * New Features!
 * ** New Troop Page comment tag added by Olivia and sponsored by Puddor:
 * *** <Once Parallel When Start Battle>
 * **** Causes the troop page to immediately run the moment the battle scene
 *      begins to fade in (not after it fades in). This is faster than a turn 0
 *      condition troop page. Troop page conditions are ignored.
 * **** This can be used for things like the Action Sequence Camera plugin, the
 *      Visual Battle Environment plugin, and/or initial battle poses and such
 *      in order to provide a near seamless battle transition experience.
 * **** This does NOT trigger when coming out of the options menu or party
 *      menu screens.
 * **** This WILL trigger when going from battle to battle nonstop via plugins
 *      like VisuStella MZ's Chain Battles.
 * **** When actors are moving towards their home positions, it will take
 *      around 30 frames by default. Use this information however you like.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 *
 * Version 1.55: January 27 2022
 * * Compatibility Update!
 * ** RPG Maker MV animations with front view should now play in the correct
 *    area against actor faces. Update made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Animations now play on top of all actor faces/portraits regardless of the
 *    battle layout style. Update made by Olivia.
 * * New Features!
 * ** New notetag added by Arisu.
 * *** <Bypass Auto Action Sequence>
 * **** This notetag is used for the game devs that have the Action Sequence
 *      Plugin Parameter "Auto Notetag" on for applying the notetag
 *      <Custom Action Sequence> to every skill and item with common events.
 * **** This will allow items and skills to be able to launch their common
 *      events from the menu scene regardless of the inherent restriction to
 *      prevent action sequence based skills/items with common events from
 *      launching.
 * **** Ignore this if you have "Auto Notetag" disabled or set to false. By
 *      default, this setting is set to false. Please be aware of the changes
 *      you've made to your game before using it.
 *
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 *
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for updated features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Battle Layout > UI Elements > Anti-Tint UI?
 * **** Prevent UI Elements from being tinted?
 * **** This prevents UI Elements such as HP Gauges, Enemy Names, Battle
 *      Cursor, and Weakness Display from being affected by screen tint.
 * * Updated Feature!
 * ** Updated Plugin Command "PROJECTILE: Animation" by Arisu!
 * *** New Parameter: Wait For Animation?
 * **** Wait for animation to finish before going to the next command?
 *
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 *
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 *
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 *
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 *
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 *
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 *
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 *
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 *
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 *
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 *
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 *
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 *
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 *
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 *
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 *
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 *
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 *
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 *
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 *
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 *
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 *
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 *
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 *
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 *
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 *
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 *
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 *
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 *
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 *
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 *
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 *
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 *
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 *
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 *
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 *
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 *
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 *
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 *
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 *
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 *
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 *
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 *
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 *
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 *
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 *
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 *
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 *
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing
 *     sprites on top of each other. Added by Yanfly.
 *
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 *
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 *
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 *
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 *
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 *
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 *
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 *
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 *
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 *
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 *
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 *
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 *
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonAnimation
 * @text ANIM: Balloon Animation
 * @desc Plays a balloon animation on target(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg Balloon:str
 * @text Balloon Type
 * @type select
 * @option Exclamation
 * @option Question
 * @option Music Note
 * @option Heart
 * @option Anger
 * @option Sweat
 * @option Frustration
 * @option Silence
 * @option Light Bulb
 * @option Zzz
 * @option User-defined 1
 * @option User-defined 2
 * @option User-defined 3
 * @option User-defined 4
 * @option User-defined 5
 * @desc What kind of balloon should be played on target(s)?
 * @default Exclamation
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIcon
 * @text ANIM: Balloon Icon (Single)
 * @desc Plays a balloon animation using an icon on target(s).
 * Requires VisuMZ_4_IconBalloons!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg IconIndex:num
 * @text Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconRange
 * @text ANIM: Balloon Icon (Range)
 * @desc Plays a balloon animation an icon range on target(s).
 * Requires VisuMZ_4_IconBalloons!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg startIcon:num
 * @text Starting Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg endIcon:num
 * @text Ending Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconSpecific
 * @text ANIM: Balloon Icon (Specific)
 * @desc Plays a balloon animation with specific icons on target(s).
 * Requires VisuMZ_4_IconBalloons!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg icons:arraynum
 * @text Icons
 * @type string[]
 * @desc Insert the ID(s) of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default []
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 *
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_GuardAnimation
 * @text ANIM: Guard Animation
 * @desc Plays the animation associated with the user's guard action (if any).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ItemAnimation
 * @text ANIM: Item Animation
 * @desc Plays the animation associated with a specific item.
 *
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 *
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimationJS
 * @text ANIM: Show Animation JS
 * @desc Plays the a specific animation on unit(s).
 * Uses JavaScript to determine animation ID.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Select which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_SkillAnimation
 * @text ANIM: Skill Animation
 * @desc Plays the animation associated with a specific skill.
 *
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 *
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 *
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 *
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 *
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 *
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCutin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCutin
 * @text Action Sequences - Cutins
 * @desc Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_AddVisualCutinEffect
 * @text CUTIN: Add Visual Cutin Effect
 * @desc Adds the Visual Cutin Effect using these desired settings.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @arg Basic
 * @text Basic Settings
 *
 * @arg type:str
 * @text Cutin Style Type
 * @parent Basic
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to use?
 * Only one of each cutin-style type can be present.
 * @default CenterHorzSpan
 *
 * @arg Targets:arraystr
 * @text Portrait Target
 * @parent Basic
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to grab the Visual Cutin Effect portrait
 * data from. First unit will be used to make portrait.
 * @default ["user"]
 *
 * @arg parallaxFilename:str
 * @text Parallax Filename
 * @parent Basic
 * @type file
 * @dir img/parallaxes/
 * @require 1
 * @desc Pick a parallax to use for the Visual Cutin Effect.
 * Pick (None) to not use a parallax.
 * @default >>>ATTENTION<<<
 *
 * @arg bgColor:str
 * @text Background Color
 * @parent Basic
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #888888
 *
 * @arg ExtraSettings:struct
 * @text Extra Settings
 * @type struct<VisualCutinEffect>
 * @desc Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 * @default {}
 *
 * @arg WaitForEntrance:eval
 * @text Wait For Entrance
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin entrance is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectAll
 * @text CUTIN: End Visual Cutin Effect (All)
 * @desc Ends all Visual Cutin Effects currently present.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectType
 * @text CUTIN: End Visual Cutin Effect (Type)
 * @desc Ends the Visual Cutin Effect with the matching type.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @arg type:str
 * @text Cutin Style Type
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to end?
 * @default CenterHorzSpan
 *
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForEntrance
 * @text CUTIN: Wait for Cutin Entrance
 * @desc Wait until all cutin entrances are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForExit
 * @text CUTIN: Wait for Cutin Exit
 * @desc Wait until all cutin exits are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceGrid
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakGrid
 * @text Action Sequences - Grid
 * @desc These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ActionAnimationAtNode
 * @text GRID: Action Animation at Node
 * @desc Plays action animation at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddPassiveStatesToNode
 * @text GRID: Add Passive State(s) to Node
 * @desc Adds Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to add as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNode
 * @text GRID: Add Trigger to Node
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc Select which Skill ID(s) to add as the trigger.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationIDAtNode
 * @text GRID: Animation ID at Node
 * @desc Plays specific animation ID at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Play this animation at target node.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:num
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:num
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationJsAtNode
 * @text GRID: Animation JS at Node
 * @desc Uses JS to calculate which animation to play at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Calculate which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationTypeAtNode
 * @text GRID: Animation Type at Node
 * @desc Plays certain animation type at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg Type:str
 * @text Animation Type
 * @type select
 * @option Attack
 * @option Guard
 * @option Item
 * @option Skill
 * @desc What is the animation type you would like to play?
 * @default Attack
 *
 * @arg Slot:eval
 * @text Slot (Attack Type)
 * @parent Type:str
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 1
 *
 * @arg ItemID:num
 * @text Item ID (Item Type)
 * @parent Type:str
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 *
 * @arg SkillID:num
 * @text Skill ID (Skill Type)
 * @parent Type:str
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_MoveTargetsInDirection
 * @text GRID: Move Target(s) In Direction
 * @desc Moves target(s) in a specific direction to other Nodes.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to move.
 * @default ["all targets"]
 *
 * @arg MoveType:str
 * @text Movement Type
 * @type select
 * @option -
 * @option Exact
 * @option -
 * @option Mid
 * @option -
 * @option Switch
 * @option Switch Mid
 * @option -
 * @option Crash
 * @option Crash Mid
 * @option -
 * @desc Select the Movement type rulings.
 * See VisuMZ_2_BattleGridSystem help file for details.
 * @default Mid
 *
 * @arg Direction:str
 * @text Direction
 * @parent MoveType:str
 * @type select
 * @option -
 * @option Upward
 * @option Downward
 * @option -
 * @option Up-Forward
 * @option Forward
 * @option Down-Forward
 * @option -
 * @option Up-Backward
 * @option Backward
 * @option Down-Backward
 * @option -
 * @option Up-Leftward
 * @option Leftward
 * @option Down-Leftward
 * @option -
 * @option Up-Rightward
 * @option Rightward
 * @option Down-Rightward
 * @option -
 * @desc Select the movement direction.
 * @default Backward
 *
 * @arg Distance:eval
 * @text Distance
 * @parent MoveType:str
 * @desc The number of nodes to be moved.
 * You may use JavaScript code.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @arg SilentMove:eval
 * @text Silent Change?
 * @type boolean
 * @on Silent
 * @off Visual
 * @desc Silent: Discreet changes shown. More apparent later.
 * Visual: Instant changes shown.
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PullToTargetNode
 * @text GRID: Pull To Target Node
 * @desc Pulls battlers towards target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to pull on?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the pull.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PushFromTargetNode
 * @text GRID: Push From Target Node
 * @desc Pushes battlers away from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to push from?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the push.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ClearPassiveStatesFromNode
 * @text GRID: Remove All Passive States from Node
 * @desc Removes all all Passive State effects at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear the Node for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Passive States from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Passive States from.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemovePassiveStatesFromNode
 * @text GRID: Remove Passive State(s) from Node
 * @desc Remove Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to remove as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to remove the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemoveTriggerFromNode
 * @text GRID: Remove Trigger from Node
 * @desc Removes Trigger from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear Triggers for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Triggers from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Triggers from.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TeleportToNode
 * @text GRID: Teleport To Node
 * @desc Teleports user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to teleport to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to teleport to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to teleport.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TraverseToNode
 * @text GRID: Traverse To Node
 * @desc Traverses user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to traverse to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to traverse to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to traverse.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_BlueRedInvert
 * @text IMPACT: Bizarro Inversion
 * @desc Swaps blue/red colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Bizarro?
 * @type boolean
 * @on Enable / Bizarro
 * @off Disable / Normal
 * @desc Enable Bizarro Inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 *
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Desaturate
 * @text IMPACT: Desaturation
 * @desc Desaturates all colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Desaturate?
 * @type boolean
 * @on Enable / Desaturate
 * @off Disable / Normal
 * @desc Enable Desaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type number
 * @min 0
 * @max 360
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Negative
 * @text IMPACT: Negative Inversion
 * @desc Inverts all the colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Negative?
 * @type boolean
 * @on Enable / Negative
 * @off Disable / Normal
 * @desc Enable negative inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Oversaturate
 * @text IMPACT: Oversaturation
 * @desc Oversaturates colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Oversaturate?
 * @type boolean
 * @on Enable / Oversaturate
 * @off Disable / Normal
 * @desc Enable Oversaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Coordinates
 *
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 *
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 *
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 *
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 *
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 *
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 *
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 *
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 *
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 *
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 *
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 *
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeScale
 * @text IMPACT: Time Scale
 * @desc Adjust time to go faster or slower!
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Scale:eval
 * @text Scale
 * @desc Adjusts how fast/slow time goes.
 * 1.00 is normal. Lower is slower. Higher is faster.
 * @default 1.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeStop
 * @text IMPACT: Time Stop
 * @desc Stops time for a set amount of milliseconds.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg ms:eval
 * @text Milliseconds
 * @desc How many milliseconds should time stop for?
 * 1000 milliseconds = 1 second.
 * @default 1000
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Coordinates
 *
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 *
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 *
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 *
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceInject
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakInject
 * @text Action Sequences - Inject
 * @desc These Action Sequences are related to injected animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationStart
 * @text INJECT: Animation Begin
 * @desc Injects and plays a whole spritesheet animation.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to inject the animation on.
 * @default ["user"]
 *
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/sv_actors/
 * @desc Select the animation spritesheet file.
 * Located in the /img/sv_actors/ folder.
 * @default Untitled
 *
 * @arg horzCells:num
 * @text Horizontal Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many horizontal cells (or columns) are there?
 * @default 1
 *
 * @arg vertCells:num
 * @text Vertical Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many vertical cells (or rows) are there?
 * @default 1
 *
 * @arg frameDelay:num
 * @text Frame Delay
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many frames are played inbetween cells?
 * @default 1
 *
 * @arg smooth:eval
 * @text Smooth Bitmap?
 * @parent Filename:str
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth the spritesheet graphic?
 * @default false
 *
 * @arg Offset
 *
 * @arg offsetX:eval
 * @text Offset X
 * @parent Offset
 * @desc Offsets the X position of the injected animation.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg offsetY:eval
 * @text Offset Y
 * @parent Offset
 * @desc Offsets the Y position of the injected animation.
 * Negative: up. Positive: down.
 * @default +0
 *
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationEnd
 * @text INJECT: Animation End
 * @desc Stops and ends any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to stop injected animation(s).
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationPauseResume
 * @text INJECT: Animation Pause/Resume
 * @desc Pauses/resumes any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to pause injected animation(s).
 * @default ["user"]
 *
 * @arg pause:eval
 * @text Pause?
 * @parent Filename:str
 * @type boolean
 * @on Pause
 * @off Resume
 * @desc Pause the injected animation?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_WaitForInjectAni
 * @text INJECT: Wait For Injected Animation
 * @desc Waits for injected animations to complete before performing
 * next command. Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActiveChainInputDisable
 * @text MECH: Active Chain Input Disable
 * @desc Disables input for Active Chain Skills at this time.
 * Requires VisuMZ_3_ActiveChainSkills!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s).
 * Determine which parameters are affected and their durations.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 *
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 *
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 *
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 *
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 *
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 *
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 *
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 *
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 *
 * @arg Casting
 *
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 *
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 *
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 *
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 *
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 *
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 *
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 *
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 *
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 *
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateAttackEffect
 * @text MECH: Emulate Attack Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * attack skill instead of the current action.
 *
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateGuardEffect
 * @text MECH: Emulate Guard Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * guard skill instead of the current action.
 *
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateItemEffect
 * @text MECH: Emulate Item Effect
 * @desc Emulate an "Action Effect" but using a specific item
 * instead of the current action.
 *
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will be emulated?
 * @default 7
 *
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillCost
 * @text MECH: Emulate Skill Cost
 * @desc Pick a skill for target(s) to emulate paying the cost of.
 * Includes cooldowns and limited uses.
 *
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will have its cost paid for?
 * Use 0 for current action's skill.
 * @default 0
 *
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillEffect
 * @text MECH: Emulate Skill Effect
 * @desc Emulate an "Action Effect" but using a specific skill
 * instead of the current action.
 *
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will be emulated?
 * @default 99
 *
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 *
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 *
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 *
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 *
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg MP
 *
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 *
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 *
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 *
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 *
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 *
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 *
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 *
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 *
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 *
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 *
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 *
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 *
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s).
 * Determine which parameters are removed.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 *
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 *
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeBy
 * @text MECH: State Turns Change By
 * @desc Changes target(s) state turns by an amount.
 * Requires VisuMZ_1_SkillsStatesCore!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeTo
 * @text MECH: State Turns Change To
 * @desc Changes target(s) state turns to a specific value.
 * Requires VisuMZ_1_SkillsStatesCore!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if target(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 *
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 *
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 *
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 *
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 *
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 *
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 *
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 *
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 *
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 *
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 *
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 *
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 *
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 *
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 *
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 *
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToJsPoint
 * @text MOVE: Change Home To JS Coordinates
 * @desc Change home position(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s)'s new home position.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 *
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 *
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 *
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 *
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 *
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 *
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceJsPoint
 * @text MOVE: Face JS Coordinates
 * @desc Causes the unit(s) to face specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg PointJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to face towards.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 *
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 *
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 *
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 *
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 *
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 *
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 *
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToJsPoint
 * @text MOVE: Move To JS Coordinates
 * @desc Moves unit(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to move to.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 *
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 *
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 *
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 *
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 *
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 *
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 *
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 *
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 *
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 *
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 *
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 *
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 *
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 *
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 *
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 *
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 *
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to finish before going to the next command?
 * @default false
 *
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 *
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 *
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 *
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 *
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 *
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 *
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 *
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 *
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 *
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 *
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 *
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 *
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 *
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceVoice
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakVoice
 * @text Action Sequences - Voice
 * @desc Allows you to play battle voices.
 * Requires VisuMZ_3_BattleVoices!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlayCommonLine
 * @text VOICE: Play Common Line
 * @desc Plays a common voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 *
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLine:str
 * @text Voice Line
 * @type select
 * @option -
 * @value -
 * @option ---Battle Phase---
 * @value -
 * @option On Battle Start
 * @value BattleStart
 * @option On Battle Input
 * @value BattleInput
 * @option On Battle Victory
 * @value BattleVictory
 * @option Victory => Level Up
 * @value BattleVictoryLevelUp
 * @option Escape => Success
 * @value BattleEscapeSuccess
 * @option Escape => Failure
 * @value BattleEscapeFailure
 * @option -
 * @value -
 * @option ---On Action Start---
 * @value -
 * @option Basic Action => Regular Attack
 * @value ActionStartBasicAttack
 * @option Basic Action => Regular Guard
 * @value ActionStartBasicGuard
 * @option Skill Usage For Allies => Certain Hit
 * @value ActionStartSkillAllyCertainHit
 * @option Skill Usage For Allies => Physical
 * @value ActionStartSkillAllyPhysical
 * @option Skill Usage For Allies => Magical
 * @value ActionStartSkillAllyMagical
 * @option Skill Usage For Enemies => Certain Hit
 * @value ActionStartSkillEnemyCertainHit
 * @option Skill Usage For Enemies => Physical
 * @value ActionStartSkillEnemyPhysical
 * @option Skill Usage For Enemies => Magical
 * @value ActionStartSkillEnemyMagical
 * @option Item Usage For Allies
 * @value ActionStartItemAlly
 * @option Item Usage For Enemies
 * @value ActionStartItemEnemy
 * @option -
 * @value -
 * @option ---Perform Action---
 * @value -
 * @option Basic Action => Attack Motion
 * @value PerformActionBasicAttack
 * @option Basic Action => Critical Action
 * @value PerformActionCritical
 * @option Basic Action => Defeat Opponent
 * @value PerformActionDefeatFoe
 * @option Basic Action => Missed Action
 * @value PerformActionMiss
 * @option Skill Usage => Certain Hit
 * @value PerformActionSkillCertainHit
 * @option Skill Usage => Physical
 * @value PerformActionSkillPhysical
 * @option Skill Usage => Magical
 * @value PerformActionSkillMagical
 * @option -
 * @value -
 * @option ---On HP Change---
 * @value -
 * @option Life State => On Death
 * @value HpChangeDeath
 * @option Life State => On Revive
 * @value HpChangeRevive
 * @option On Damage => Damage <= 0%
 * @value HpChangeDamageNone
 * @option On Damage => Damage < 25%
 * @value HpChangeDamageLight
 * @option On Damage => Damage < 50%
 * @value HpChangeDamageMedium
 * @option On Damage => Damage >= 50%
 * @value HpChangeDamageHeavy
 * @option On Damage => Guarding Damage
 * @value HpChangeDamageGuard
 * @option On Recovery => Recovery < 25%
 * @value HpChangeRecoverLight
 * @option On Recovery => Recovery < 50%
 * @value HpChangeRecoverMedium
 * @option On Recovery => Recovery >= 50%
 * @value HpChangeRecoverHeavy
 * @option -
 * @value -
 * @option ---On Action Result---
 * @value -
 * @option On Miss/Evasion
 * @value ActionResultEvasion
 * @option On Magic Evasion
 * @value ActionResultMagicEvasion
 * @option On Counter
 * @value ActionResultCounter
 * @option On Reflection
 * @value ActionResultReflection
 * @option On Substitute
 * @value ActionResultSubstitute
 * @option -
 * @value -
 * @option ---Buff/Debuff Related---
 * @value -
 * @option On Buff Apply
 * @value BuffAdd
 * @option On Buff Remove
 * @value BuffRemove
 * @option On Debuff Apply
 * @value DebuffAdd
 * @option On Debuff Remove
 * @value DebuffRemove
 * @option -
 * @value -
 * @option ---State Related---
 * @value -
 * @option Positive States => On State Apply
 * @value StatePositiveAdd
 * @option Positive States => text On State Remove
 * @value StatePositiveRemove
 * @option Negative States => On State Apply
 * @value StateNegativeAdd
 * @option Negative States => On State Remove
 * @value StateNegativeRemove
 * @option Neutral States => On State Apply
 * @value StateNeutralAdd
 * @option Neutral States => On State Remove
 * @value StateNeutralRemove
 * @option -
 * @value -
 * @option ---Miscellaneous---
 * @value -
 * @option Voice Preview
 * @value CharaCreatePreview
 * @option -
 * @value -
 * @desc What voice line do you wish to play?
 * @default ActionStartBasicAttack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlaySpecialLine
 * @text VOICE: Play Special Line
 * @desc Plays a special voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 *
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLineType:str
 * @text Voice Line Type
 * @type select
 * @option Action Name
 * @value ActionName
 * @option Chant Line
 * @value ChantLine
 * @option Item Name
 * @value ItemName
 * @option Skill Name
 * @value SkillName
 * @option Spell Name
 * @value SpellName
 * @option Unique Lines
 * @value UniqueLine
 * @desc What voice line type do you wish to play?
 * @default ActionName
 *
 * @arg Letter:str
 * @text Name / Letter
 * @type select
 * @option A
 * @option B
 * @option C
 * @option D
 * @option E
 * @option F
 * @option G
 * @option H
 * @option I
 * @option J
 * @option K
 * @option L
 * @option M
 * @option N
 * @option O
 * @option P
 * @option Q
 * @option R
 * @option S
 * @option T
 * @option U
 * @option V
 * @option W
 * @option X
 * @option Y
 * @option Z
 * @desc What voice letter/name do you want to play?
 * @default A
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 *
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 *
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 *
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 *
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param BattlebackScale:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat."}
 *
 * @param MultiTarget:struct
 * @text Multi-Target Windows
 * @type struct<MultiTarget>
 * @desc Settings that alter the Multi-Target Windows in battle.
 * @default {"Properties":"","WindowWidth:num":"280","BgType:num":"2","ShowButton:eval":"true","Vocab":"","AllActorsText:str":"All Allies","AllEnemiesText:str":"All Enemies","Offsets":"","ActorOffsets":"","ActorOffsetX:num":"+0","ActorOffsetY:num":"+0","EnemyOffsets":"","EnemyOffsetX:num":"+0","EnemyOffsetY:num":"+0"}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param SyncBuffExpire:eval
 * @text Turn End Buffs Expire
 * @parent ActionSpeed
 * @type boolean
 * @on Expire
 * @off Don't Expire
 * @desc Normally, buffs expire after all actions end.
 * But here, you can have buffs expire on turn end.
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 *
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 *
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 *
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 *
 * @param Offsets
 *
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvBattlers
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvBattlers
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 *
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 *
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 *
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 *
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 *
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 *
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 *
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 *
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 *
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 *
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 *
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 *
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 *
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 *
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 *
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 *
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 * @param Emulate
 * @text Effect Emulation
 *
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 *
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 *
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 *
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 *
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 *
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 *
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 *
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 *
 * @param Emulate
 * @text Effect Emulation
 *
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 *
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 *
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 *
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 *
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 *
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 *
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 *
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 *
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 *
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 *
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 *
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 *
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 *
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 *
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 *
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 *
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 *
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

var label = "BattleCore";
var tier = tier || 0;
var dependencies = [];
var pluginData = $plugins.filter(function (plugin) {
  return plugin.status && plugin.description.includes("[" + label + "]");
})[0];
VisuMZ[label].Settings = VisuMZ[label].Settings || {};

const isBattleScene = (scene) => {
  return scene instanceof Scene_Battle;
};

VisuMZ.ConvertParams = function (params, args) {
  for (const key in args) {
    if (key.match(/(.*):(.*)/i)) {
      const argKey = String(RegExp["$1"]);
      const argValue = String(RegExp["$2"])["toUpperCase"]().trim();
      let paramValue, arr, obj;
      switch (argValue) {
        case "NUM":
          paramValue = args[key] !== "" ? Number(args[key]) : 0;
          break;
        case "ARRAYNUM":
          arr = args[key] !== "" ? JSON.parse(args[key]) : [];
          paramValue = arr.map((e) => Number(e));
          break;
        case "EVAL":
          paramValue = args[key] !== "" ? eval(args[key]) : null;
          break;
        case "ARRAYEVAL":
          arr = args[key] !== "" ? JSON.parse(args[key]) : [];
          paramValue = arr.map((e) => eval(e));
          break;
        case "JSON":
          paramValue = args[key] !== "" ? JSON.parse(args[key]) : "";
          break;
        case "ARRAYJSON":
          arr = args[key] !== "" ? JSON.parse(args[key]) : [];
          paramValue = arr.map((e) => JSON.parse(e));
          break;
        case "FUNC":
          paramValue =
            args[key] !== ""
              ? new Function(JSON.parse(args[key]))
              : new Function("return 0");
          break;
        case "ARRAYFUNC":
          arr = args[key] !== "" ? JSON.parse(args[key]) : [];
          paramValue = arr.map((e) => new Function(JSON.parse(e)));
          break;
        case "STR":
          paramValue = args[key] !== "" ? String(args[key]) : "";
          break;
        case "ARRAYSTR":
          arr = args[key] !== "" ? JSON.parse(args[key]) : [];
          paramValue = arr.map((e) => String(e));
          break;
        case "STRUCT":
          obj = args[key] !== "" ? JSON.parse(args[key]) : {};
          params[argKey] = {};
          VisuMZ.ConvertParams(params[argKey], obj);
          continue;
        case "ARRAYSTRUCT":
          arr = args[key] !== "" ? JSON.parse(args[key]) : [];
          paramValue = arr.map((e) => VisuMZ.ConvertParams({}, JSON.parse(e)));
          break;
        default:
          continue;
      }
      params[argKey] = paramValue;
    }
  }
  return params;
};

((_pluginData) => {
  const pluginName = _pluginData.name;
  for (const dependency of dependencies) {
    if (!Imported[dependency]) {
      alert(
        "%1 is missing a required plugin.\nPlease install %2 into the Plugin Manager."[
          "format"
        ](pluginName, dependency)
      ),
        SceneManager.exit();
      break;
    }
  }
  const pluginDescription = _pluginData.description;
  if (pluginDescription.match(/\[Version[ ](.*?)\]/i)) {
    const version = Number(RegExp["$1"]);
    if (version !== VisuMZ[label]["version"]) {
      alert(
        "%1's version does not match plugin's. Please update it in the Plugin Manager."[
          "format"
        ](pluginName, version)
      );
      SceneManager.exit();
    }
  }
  if (pluginDescription.match(/\[Tier[ ](\d+)\]/i)) {
    const pluginTier = Number(RegExp["$1"]);
    if (pluginTier < tier) {
      alert(
        "%1 is incorrectly placed on the plugin list.\nIt is a Tier %2 plugin placed over other Tier %3 plugins.\nPlease reorder the plugin list from smallest to largest tier numbers."[
          "format"
        ](pluginName, pluginTier, tier)
      );
      SceneManager.exit();
    } else {
      tier = Math.max(pluginTier, tier);
    }
  }
  VisuMZ.ConvertParams(VisuMZ[label]["Settings"], _pluginData.parameters);
})(pluginData);

VisuMZ.CreateActionSequenceTargets = function (targets) {
  let actionSequenceTargets = [];
  for (const target of targets) {
    actionSequenceTargets = actionSequenceTargets.concat(
      VisuMZ.ConvertActionSequenceTarget(target)
    );
  }
  return actionSequenceTargets.filter(
    (actionSequenceTarget) => actionSequenceTarget
  );
};

VisuMZ.ConvertActionSequenceTarget = function (actionSequencetarget) {
  const allBattleMembers = BattleManager.allBattleMembers().filter(
    (battleMember) => battleMember && battleMember.isAppeared()
  );
  const subject = BattleManager._subject;
  const target = BattleManager._target;
  const allTargets = BattleManager._allTargets
    ? BattleManager._allTargets.slice(0)
    : allBattleMembers;
  actionSequencetarget = actionSequencetarget.toLowerCase().trim();
  if (actionSequencetarget === "user") {
    return [subject];
  } else if (actionSequencetarget === "current target") {
    return [target];
  } else if (actionSequencetarget === "prev target") {
    if (target) {
      const targetIndex = allTargets.indexOf(target);
      return targetIndex >= 0
        ? [allTargets[targetIndex - 1] || target]
        : [target];
    }
  } else if (actionSequencetarget === "text target") {
    if (target) {
      const targetIndex = allTargets.indexOf(target);
      return targetIndex >= 0
        ? [allTargets[targetIndex + 1] || target]
        : [target];
    }
  } else if (actionSequencetarget === "all targets") {
    return allTargets;
  } else if (actionSequencetarget === "focus") {
    return [subject].concat(allTargets);
  } else if (actionSequencetarget === "not focus") {
    return allBattleMembers.filter(
      (battleMember) =>
        battleMember !== subject &&
        !allTargets.includes(battleMember) &&
        battleMember.notFocusValid()
    );
  } else if (actionSequencetarget === "special") {
    return [VisuMZ.GetActionSequenceSpecialTarget()];
  } else if (actionSequencetarget.match(/SPECIAL (.*)>/i)) {
    const special = String(RegExp["$1"])
      .split(",")
      .map((str) => str.trim());
    return [VisuMZ.GetActionSequenceSpecialTargetWithFlags(special)];
  }
  if (subject) {
    if (actionSequencetarget === "alive friends") {
      return subject.friendsUnit().aliveMembers();
    } else if (actionSequencetarget === "alive friends not user") {
      return subject
        .friendsUnit()
        .aliveMembers()
        .filter((member) => member !== subject);
    } else if (actionSequencetarget === "alive friends not target") {
      return subject
        .friendsUnit()
        .aliveMembers()
        .filter((member) => member !== target);
    } else if (actionSequencetarget === "dead friends") {
      return subject.friendsUnit().deadMembers();
    } else if (actionSequencetarget.match(/FRIEND INDEX (\d+)/i)) {
      const friendIndex = Number(RegExp["$1"]);
      return [subject.friendsUnit().members()[friendIndex]];
    }
    if (actionSequencetarget === "alive opponents") {
      return subject.opponentsUnit().aliveMembers();
    } else if (actionSequencetarget === "alive opponents not target") {
      return subject
        .opponentsUnit()
        .aliveMembers()
        .filter((member) => member !== target);
    } else if (actionSequencetarget === "dead opponents") {
      return subject.opponentsUnit().deadMembers();
    } else if (actionSequencetarget.match(/OPPONENT INDEX (\d+)/i)) {
      const opponentIndex = Number(RegExp["$1"]);
      return [subject.opponentsUnit().members()[opponentIndex]];
    }
  }
  if (actionSequencetarget === "alive actors") {
    return $gameParty.aliveMembers();
  } else if (actionSequencetarget === "alive actors not user") {
    return $gameParty.aliveMembers().filter((member) => member !== subject);
  } else if (actionSequencetarget === "alive actors not target") {
    return $gameParty.aliveMembers().filter((member) => member !== target);
  } else if (actionSequencetarget === "dead actors") {
    return $gameParty.deadMembers();
  } else if (actionSequencetarget.match(/ACTOR INDEX (\d+)/i)) {
    const actorIndex = Number(RegExp["$1"]);
    return [$gameParty.members()[actorIndex]];
  } else if (actionSequencetarget.match(/ACTOR ID (\d+)/i)) {
    const actorId = Number(RegExp["$1"]);
    return [$gameActors.actor(actorId)];
  }
  if (actionSequencetarget === "alive enemies") {
    return $gameTroop.aliveMembers();
  } else if (actionSequencetarget === "alive enemies not user") {
    return $gameTroop.aliveMembers().filter((member) => member !== subject);
  } else if (actionSequencetarget === "alive enemies not target") {
    return $gameTroop.aliveMembers().filter((member) => member !== target);
  } else if (actionSequencetarget === "dead enemies") {
    return $gameTroop.deadMembers();
  } else if (actionSequencetarget.match(/ENEMY INDEX (\d+)/i)) {
    const enemyIndex = Number(RegExp["$1"]);
    return [$gameTroop.members()[enemyIndex]];
  } else if (actionSequencetarget.match(/ENEMY ID (\d+)/i)) {
    const enemyId = Number(RegExp["$1"]);
    return $gameTroop
      .aliveMembers()
      .filter((member) => member.enemyId() === enemyId);
  }
  if (actionSequencetarget === "alive battlers") {
    return allBattleMembers.filter((member) => member.isAlive());
  } else if (actionSequencetarget === "alive battlers not user") {
    return allBattleMembers.filter(
      (member) => member.isAlive() && member !== subject
    );
  } else if (actionSequencetarget === "alive battlers not target") {
    return allBattleMembers.filter(
      (member) => member.isAlive() && member !== target
    );
  } else if (actionSequencetarget === "dead battlers") {
    return allBattleMembers.filter((member) => member.isDead());
  }
  return [];
};

VisuMZ.GetActionSequenceSpecialTarget = function () {
  return BattleManager._target;
};

VisuMZ.GetActionSequenceSpecialTargetWithFlags = function (_) {
  return BattleManager._target;
};

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Set_SetupAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const allTargets = BattleManager._allTargets
      ? BattleManager._allTargets.slice(0)
      : [];
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    if (args.DisplayAction) logWindow.displayAction(subject, action.item());
    args.ApplyImmortal &&
      logWindow.push("applyImmortal", subject, allTargets, true);
    if (args.ActionStart) logWindow.push("performActionStart", subject, action);
    if (args.WaitForMovement) logWindow.push("waitForMovement");
    if (args.CastAnimation)
      logWindow.push("performCastAnimation", subject, action);
    if (args.WaitForAnimation) logWindow.push("waitForAnimation");
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Set_WholeActionSet",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const allTargets = BattleManager._allTargets
      ? BattleManager._allTargets.slice(0)
      : [];
    const logWindow = BattleManager._logWindow;
    const dualWield = args.DualWield ?? false;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    let dualWieldTimes = dualWield ? logWindow.getDualWieldTimes(subject) : 1;
    for (
      let dualWieldCount = 0;
      dualWieldCount < dualWieldTimes;
      dualWieldCount++
    ) {
      if (dualWield && subject.isActor()) {
        logWindow.push("setActiveWeaponSet", subject, dualWieldCount);
      }
      if (args.PerformAction) logWindow.push("performAction", subject, action);
      if (args.WaitCount > 0) logWindow.push("waitCount", args.WaitCount);
      if (args.ActionAnimation) {
        logWindow.push(
          "showAnimation",
          subject,
          allTargets,
          action.item().animationId
        );
      }
      if (args.WaitForAnimation) logWindow.push("waitForAnimation");
      for (const target of allTargets) {
        if (!target) continue;
        if (args.ActionEffect) logWindow.push("actionEffect", subject, target);
      }
    }
    if (dualWield && subject.isActor()) {
      logWindow.push("clearActiveWeaponSet", subject);
    }
    if (args.ApplyImmortal) {
      logWindow.push("applyImmortal", subject, allTargets, false);
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Set_TargetActionSet",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const allTargets = BattleManager._allTargets
      ? BattleManager._allTargets.slice(0)
      : [];
    const logWindow = BattleManager._logWindow;
    const dualWield = args.DualWield ?? false;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    let dualWieldTimes = dualWield ? logWindow.getDualWieldTimes(subject) : 1;
    for (
      let dualWieldCount = 0;
      dualWieldCount < dualWieldTimes;
      dualWieldCount++
    ) {
      for (const target of allTargets) {
        if (!target) continue;
        if (dualWield && subject.isActor()) {
          logWindow.push("setActiveWeaponSet", subject, dualWieldCount);
        }
        if (args.PerformAction) {
          logWindow.push("performAction", subject, action);
        }
        if (args.WaitCount1 > 0) logWindow.push("waitCount", args.WaitCount1);
        if (args.ActionAnimation) {
          logWindow.push(
            "showAnimation",
            subject,
            [target],
            action.item().animationId
          );
        }
        if (args.WaitCount2 > 0) logWindow.push("waitCount", args.WaitCount2);
        if (args.ActionEffect) {
          logWindow.push("actionEffect", subject, target);
        }
      }
    }
    if (dualWield && subject.isActor()) {
      logWindow.push("clearActiveWeaponSet", subject);
    }
    if (args.ApplyImmortal) {
      logWindow.push("applyImmortal", subject, allTargets, false);
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Set_FinishAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const allTargets = BattleManager._allTargets
      ? BattleManager._allTargets.slice(0)
      : [];
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    if (args.ApplyImmortal) {
      logWindow.push("applyImmortal", subject, allTargets, false);
    }
    if (args.WaitForNewLine) logWindow.push("waitForNewLine");
    if (args.WaitForEffect) logWindow.push("waitForEffect");
    if (args.ClearBattleLog) logWindow.push("clear");
    if (args.ActionEnd) logWindow.push("performActionEnd", subject);
    if (args.WaitForMovement) logWindow.push("waitForMovement");
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(pluginData.name, "ActSeq_ChangeAngle", (args) => {
  if (!SceneManager.isSceneBattle()) return;
  if (!Imported.VisuMZ_3_ActSeqCamera) return;
  VisuMZ.ConvertParams(args, args);
  const interpreter = $gameTemp.getLastPluginCommandInterpreter();
  const waitForAngle = args.WaitForAngle;
  if (!interpreter) return;
  $gameScreen.setBattleAngle(args.Angle, args.Duration, args.EasingType);
  if (waitForAngle) interpreter.setWaitMode("battleAngle");
});

PluginManager.registerCommand(pluginData.name, "ActSeq_Angle_Reset", (args) => {
  if (!SceneManager.isSceneBattle()) return;
  if (!Imported.VisuMZ_3_ActSeqCamera) return;
  VisuMZ.ConvertParams(args, args);
  const interpreter = $gameTemp.getLastPluginCommandInterpreter();
  const waitForAngle = args.WaitForAngle;
  if (!interpreter) return;
  $gameScreen.setBattleAngle(0, args.Duration, args.EasingType);
  if (waitForAngle) interpreter.setWaitMode("battleAngle");
});

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Angle_WaitForAngle",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleAngle");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_ActionAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const mirror = args.Mirror;
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    let animationId = action.item().animationId;
    if (animationId < 0) animationId = subject.attackAnimationId1();
    $gameTemp.requestAnimation(actionSequenceTargets, animationId, mirror);
    if (args.WaitForAnimation) {
      interpreter.setWaitMode("battleAnimation");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_AttackAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const subject = BattleManager._subject;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const mirror = args.Mirror;
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !subject) return;
    const attackAnimationId1 = subject.attackAnimationId1();
    $gameTemp.requestAnimation(
      actionSequenceTargets,
      attackAnimationId1,
      mirror
    );
    args.WaitForAnimation && interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_AttackAnimation2",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const attackAnimationIdSlot = subject.attackAnimationIdSlot(args.Slot);
    if (attackAnimationIdSlot <= 0) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const subject = BattleManager._subject;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const mirror = args.Mirror;
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !subject) return;
    $gameTemp.requestAnimation(
      actionSequenceTargets,
      attackAnimationIdSlot,
      mirror
    );
    args.WaitForAnimation && interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_BalloonAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const balloon = args.Balloon;
    let balloonId = 0;
    switch (balloon.toUpperCase().trim()) {
      case "!":
      case "EXCLAMATION":
        balloonId = 1;
        break;
      case "?":
      case "QUESTION":
        balloonId = 2;
        break;
      case "MUSIC":
      case "NOTE":
      case "MUSIC NOTE":
      case "MUSIC-NOTE":
      case "MUSICNOTE":
        balloonId = 3;
        break;
      case "HEART":
      case "LOVE":
        balloonId = 4;
        break;
      case "ANGLE":
      case "ANGER":
        balloonId = 5;
        break;
      case "SWEAT":
        balloonId = 6;
        break;
      case "COBWEB":
      case "ANNOYED":
      case "FRUSTRATION":
        balloonId = 7;
        break;
      case "SILENCE":
      case "...":
        balloonId = 8;
        break;
      case "LIGHT":
      case "BULB":
      case "LIGHT BULB":
      case "LIGHT-BULB":
      case "LIGHTBULB":
        balloonId = 9;
        break;
      case "Z":
      case "ZZ":
      case "ZZZ":
      case "SLEEP":
        balloonId = 10;
        break;
      case "USER-DEFINED 1":
        balloonId = 11;
        break;
      case "USER-DEFINED 2":
        balloonId = 12;
        break;
      case "USER-DEFINED 3":
        balloonId = 13;
        break;
      case "USER-DEFINED 4":
        balloonId = 14;
        break;
      case "USER-DEFINED 5":
        balloonId = 15;
        break;
    }
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      $gameTemp.requestBattleBalloon(actionSequenceTarget, balloonId);
    }
    if (args.WaitComplete && interpreter) {
      interpreter.wait(1);
      interpreter.setWaitMode("battleBalloon");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_BalloonIcon",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_4_IconBalloons) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const iconIndex = args.IconIndex;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      $gameTemp.requestBattleBalloon(actionSequenceTarget, [iconIndex]);
    }
    if (args.WaitComplete && interpreter) {
      interpreter.wait(1), interpreter.setWaitMode("battleBalloon");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_BalloonIconRange",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_4_IconBalloons) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const minIcon = Math.min(
      Number(args.startIcon || 0),
      Number(args.endIcon || 0)
    );
    const maxIcon = Math.max(
      Number(args.startIcon || 0),
      Number(args.endIcon || 0)
    );
    const iconRange = [];
    for (let iconIndex = minIcon; iconIndex <= maxIcon; iconIndex++) {
      iconRange.push(iconIndex);
    }
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      $gameTemp.requestBattleBalloon(actionSequenceTarget, iconRange);
    }
    if (args.WaitComplete && interpreter) {
      interpreter.wait(1);
      interpreter.setWaitMode("battleBalloon");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_BalloonIconSpecific",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_4_IconBalloons) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const icons = args.icons;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      $gameTemp.requestBattleBalloon(actionSequenceTarget, icons);
    }
    if (args.WaitComplete && interpreter) {
      interpreter.wait(1);
      interpreter.setWaitMode("battleBalloon");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_CastAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const mirror = args.Mirror;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    if (!interpreter || !action) return;
    if (!action.item()) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.performCastAnimation(action, mirror);
    }
    if (args.WaitForAnimation) interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_ChangeBattlePortrait",
  (args) => {
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const fileName = args.Filename;
    if (!fileName) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isActor()) continue;
      actionSequenceTarget.setBattlePortrait(fileName);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_GuardAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const subject = BattleManager._subject;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const mirror = args.Mirror;
    if (!interpreter || !subject) return;
    const guardSkill = $dataSkilles[subject.guardSkillId()];
    const animationId = guardSkill.animationId;
    $gameTemp.requestAnimation(actionSequenceTargets, animationId, mirror);
    if (args.WaitForAnimation) {
      interpreter.setWaitMode("battleAnimation");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_ItemAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const itemId = Number(args.ItemID || 1);
    const item = $dataItems[itemId];
    const mirror = args.Mirror;
    if (!interpreter) return;
    if (!item) return;
    let animationId = item.animationId;
    $gameTemp.requestAnimation(actionSequenceTargets, animationId, mirror);
    if (args.WaitForAnimation) {
      interpreter.setWaitMode("battleAnimation");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_PlayAtCoordinate",
  (args) => {
    if (!SceneManager._scene) return;
    if (!SceneManager._scene._spriteset) return;
    if (!Imported.VisuMZ_0_CoreEngine) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const pointX = Math.round(args.pointX);
    const pointY = Math.round(args.pointY);
    $gameTemp.requestPointAnimation(
      pointX,
      pointY,
      args.AnimationID,
      args.Mirror,
      args.Mute
    );
    if (args.WaitComplete && interpreter) {
      SceneManager._scene._spriteset.updatePointAnimations();
      interpreter.setWaitMode("battleAnimation");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_ShowAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const animationId = args.AnimationID;
    const mirror = args.Mirror;
    if (!interpreter) return;
    $gameTemp.requestAnimation(actionSequenceTargets, animationId, mirror);
    if (args.WaitForAnimation) interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_ShowAnimationJS",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const animationId = Number(args.AnimationID) || 1;
    const mirror = args.Mirror;
    if (!interpreter) return;
    $gameTemp.requestAnimation(actionSequenceTargets, animationId, mirror);
    if (args.WaitForAnimation) interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_SkillAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const skillId = Number(args.SkillID || 1);
    const skill = $dataSkills[skillId];
    const mirror = args.Mirror;
    if (!interpreter) return;
    if (!skill) return;
    let animationId = skill.animationId;
    $gameTemp.requestAnimation(actionSequenceTargets, animationId, mirror);
    args.WaitForAnimation && interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Animation_WaitForAnimation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleAnimation");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_AddText",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const logWindow = BattleManager._logWindow;
    const combatLog = args.CopyCombatLog && Imported.VisuMZ_4_CombatLog;
    logWindow.addText(args.Text);
    if (combatLog && Imported.VisuMZ_4_CombatLog) {
      $gameSystem.addTextToCombatLog(args.Text || "", args.CombatLogIcon || 0);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_Clear",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const logWindow = BattleManager._logWindow;
    logWindow.clear();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_DisplayAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    logWindow.displayAction(subject, action.item()),
      interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_PopBaseLine",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const logWindow = BattleManager._logWindow;
    logWindow.popBaseLine();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_PushBaseLine",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const logWindow = BattleManager._logWindow;
    logWindow.pushBaseLine();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_Refresh",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const logWindow = BattleManager._logWindow;
    logWindow.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_UI",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args),
      SceneManager._scene.setVisibleUI(args.ShowHide);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_WaitForBattleLog",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleLog_WaitForNewLine",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const logWindow = BattleManager._logWindow;
    logWindow.waitForNewLine(), interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Camera_Clamp",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    VisuMZ.ConvertParams(args, args);
    const battleCameraData = $gameScreen.battleCameraData();
    battleCameraData.cameraClamp = args.Setting;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Camera_FocusPoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const waitForCamera = args.WaitForCamera;
    $gameScreen.setBattleCameraPoint(
      args.FocusX,
      args.FocusY,
      args.Duration,
      args.EasingType
    );
    if (waitForCamera) interpreter.setWaitMode("battleCamera");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Camera_FocusTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const waitForCamera = args.WaitForCamera;
    $gameScreen.setBattleCameraTargets(
      actionSequenceTargets,
      args.Duration,
      args.EasingType
    );
    if (waitForCamera) interpreter.setWaitMode("battleCamera");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Camera_Offset",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const waitForCamera = args.WaitForCamera;
    $gameScreen.setBattleCameraOffset(
      args.OffsetX,
      args.OffsetY,
      args.Duration,
      args.EasingType
    );
    if (waitForCamera) interpreter.setWaitMode("battleCamera");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Camera_Reset",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const resetForcus = args.ResetFocus;
    const resetOffset = args.ResetOffset;
    const waitForCamera = args.WaitForCamera;
    if (resetForcus) {
      const x = Math.round(Graphics.width / 2);
      const y = Math.round(Graphics.height / 2);
      $gameScreen.setBattleCameraPoint(x, y, args.Duration, args.EasingType);
    }
    resetOffset &&
      $gameScreen.setBattleCameraOffset(0, 0, args.Duration, args.EasingType);
    if (waitForCamera) interpreter.setWaitMode("battleCamera");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Camera_WaitForCamera",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleCamera");
  }
);

VisuMZ.BattleCore.CreateCutinSettings = function (args) {
  args.portraitFilename = "";
  const cutinSettings = VisuMZ.VisualCutinEffect.CreateCutinSettings(args);
  const actionSequenceTargets =
    VisuMZ.CreateActionSequenceTargets(args.Targets)[0] || null;
  if (actionSequenceTargets) {
    cutinSettings.portraitFilename =
      actionSequenceTargets.visualCutinPortraitFilename();
    cutinSettings.portraitIndex =
      actionSequenceTargets.visualCutinPortraitIndex();
    cutinSettings.portraitHue = actionSequenceTargets.visualCutinPortraitHue();
    cutinSettings.portraitType =
      actionSequenceTargets.visualCutinPortraitType();
    if (actionSequenceTargets.isEnemy()) {
      if (actionSequenceTargets.flipVisualCutinHorz()) {
        cutinSettings.portraitFlipHorz = !cutinSettings.portraitFlipHorz;
      }
      if (actionSequenceTargets.flipVisualCutinVert()) {
        cutinSettings.portraitFlipVert = !cutinSettings.portraitFlipVert;
      }
      if (cutinSettings.portraitType === "svActor") {
        cutinSettings.portraitFlipHorz = !cutinSettings.portraitFlipHorz;
      }
      if (args.ExtraSettings.parallaxScrollXinvertEnemy) {
        cutinSettings.parallaxScrollX *= -1;
      }
      if (args.ExtraSettings.parallaxScrollYinvertEnemy) {
        cutinSettings.parallaxScrollY *= -1;
      }
      cutinSettings.parallaxHue +=
        args.ExtraSettings.parallaxHueEnemyModifier ?? 0;
    }
  }
  return cutinSettings;
};

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Cutin_AddVisualCutinEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_VisualCutinEffect) return;
    VisuMZ.ConvertParams(args, args);
    const cutinSettings = VisuMZ.BattleCore.CreateCutinSettings(args);
    SceneManager._scene.startVisualCutin(cutinSettings);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (interpreter && args.WaitForEntrance) {
      interpreter.setWaitMode("cutinEnter");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Cutin_EndVisualCutinEffectAll",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_VisualCutinEffect) return;
    VisuMZ.ConvertParams(args, args),
      SceneManager._scene.clearAllVisualCutins();
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    interpreter && args.WaitForExit && interpreter.setWaitMode("cutinExit");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Cutin_EndVisualCutinEffectType",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_VisualCutinEffect) return;
    VisuMZ.ConvertParams(args, args);
    const type = args.type.toLowerCase().trim();
    SceneManager._scene.endVisualCutin(type);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (interpreter && args.WaitForExit) {
      interpreter.setWaitMode("cutinExit");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Cutin_WaitForEntrance",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_VisualCutinEffect) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    interpreter.setWaitMode("cutinEnter");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Cutin_WaitForExit",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_VisualCutinEffect) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    interpreter.setWaitMode("cutinExit");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_DB_DragonbonesMotionAni",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_DragonbonesUnion) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const motionAnimation = args.MotionAni.toLowerCase().trim();
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.requestDragonbonesAnimation(motionAnimation);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_DB_DragonbonesTimeScale",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_DragonbonesUnion) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const timeScale = args.TimeScale;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.dragonbonesData()["timeScale"] = timeScale;
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Element_AddElements",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_1_ElementStatusCore) return;
    VisuMZ.ConvertParams(args, args);
    const action = BattleManager._action;
    const elements = args.Elements;
    if (!action) return;
    action._battleCoreAddedElements = elements;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Element_Clear",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_1_ElementStatusCore) return;
    const action = BattleManager._action;
    if (!action) return;
    action.clearElementChanges();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Element_ForceElements",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_1_ElementStatusCore) return;
    VisuMZ.ConvertParams(args, args);
    const action = BattleManager._action;
    const elements = args.Elements;
    if (!action) return;
    action._battleCoreForcedElements = elements;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Element_NullElements",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_1_ElementStatusCore) return;
    const action = BattleManager._action;
    if (!action) return;
    action._battleCoreNoElement = true;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_ActionAnimationAtNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_ActionAnimationAtNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_AddPassiveStatesToNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_AddPassiveStatesToNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_AddTriggerToNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_AddTriggerToNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_AnimationIDAtNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_AnimationIDAtNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_AnimationJsAtNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_AnimationJsAtNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_AnimationTypeAtNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_AnimationTypeAtNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_ClearPassiveStatesFromNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_ClearPassiveStatesFromNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_MoveTargetsInDirection",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_MoveTargetsInDirection(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_PullToTargetNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_PullToTargetNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_PushFromTargetNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_PushFromTargetNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_RemovePassiveStatesFromNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_RemovePassiveStatesFromNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_RemoveTriggerFromNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_RemoveTriggerFromNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_TeleportToNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_TeleportToNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Grid_TraverseToNode",
  (args) => {
    VisuMZ.BattleGridSystem.ActSeq_Grid_TraverseToNode(args);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_Clear",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.removeHorrorEffect("noise"),
        actionSequenceTarget.removeHorrorEffect("glitch"),
        actionSequenceTarget.removeHorrorEffect("tv"),
        actionSequenceTarget.clearHorrorEffects();
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_GlitchCreate",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const horrorEffect = "glitch";
    args.sliceMin = Math.ceil(args.slices / 2);
    args.sliceMax = args.slices;
    args.refreshRequest = true;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setHorrorEffectSettings(horrorEffect, args);
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_GlitchRemove",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.removeHorrorEffect("glitch");
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_NoiseCreate",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const horrorEffect = "noise";
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setHorrorEffectSettings(horrorEffect, args);
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_NoiseRemove",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.removeHorrorEffect("noise");
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_TVCreate",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const horrorEffect = "tv";
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setHorrorEffectSettings(horrorEffect, args);
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Horror_TVRemove",
  (args) => {
    if (!Imported.VisuMZ_2_HorrorEffects) return;
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.removeHorrorEffect("tv");
    }
    $gamePlayer.refresh();
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_BlueRedInvert",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.04) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const enable = args.Enable;
    spriteset.setupBlueRedInvertImpactFilter(enable);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_ColorBreak",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const _0x1c087c = args.Intensity || 1;
    const _0x5e92a3 = args.Duration || 1;
    const _0x910485 = args.EasingType || "Linear";
    spriteset.setupRgbSplitImpactFilter(_0x1c087c, _0x5e92a3, _0x910485);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_Desaturate",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.04) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const enable = args.Enable;
    spriteset.setupDesaturateImpactFilter(enable);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_MotionBlurScreen",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const angle = Number(args.Angle) || 0;
    const rate = Number(args.Rate);
    const duration = args.Duration || 1;
    const easingType = args.EasingType || "Linear";
    spriteset.setupMotionBlurImpactFilter(angle, rate, duration, easingType);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_MotionBlurTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const _0xcc8b4 = Number(args.Angle) || 0;
    const _0x2104ed = Number(args.Rate);
    const _0x3e426d = args.Duration || 1;
    const _0x40022f = args.EasingType || "Linear";
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.battler()) continue;
      actionSequenceTarget
        .battler()
        ["setupMotionBlurImpactFilter"](
          _0xcc8b4,
          _0x2104ed,
          _0x3e426d,
          _0x40022f
        );
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_MotionTrailCreate",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    VisuMZ.ConvertParams(args, args);
    const _0x283e0f = {
      delay: args.delay,
      duration: args.duration,
      hue: args.hue,
      opacityStart: args.opacityStart,
      tone: args.tone,
      visible: true,
    };
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setBattlerMotionTrailData(_0x283e0f);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_MotionTrailRemove",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.clearBattlerMotionTrailData();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_Negative",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.04) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const enable = args.Enable;
    spriteset.setupNegativeImpactFilter(enable);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_Oversaturate",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.04) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const enable = args.Enable;
    spriteset.setupOversaturateImpactFilter(enable);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_ShockwavePoint",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const _0x3d1ebf = args.X || 0;
    const _0x14b858 = args.Y || 0;
    const _0x53bff5 = args.Amp || 0;
    const _0x30c869 = args.Wave || 0;
    const _0x186c96 = args.Duration || 1;
    spriteset.setupShockwaveImpactFilter(
      _0x3d1ebf,
      _0x14b858,
      _0x53bff5,
      _0x30c869,
      _0x186c96
    );
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_ShockwaveEachTargets",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x57a48c = args.TargetLocation;
    const _0x23d546 = args.OffsetX || 0;
    const _0x6691e9 = args.OffsetY || 0;
    const _0xf9f36e = args.Amp || 0;
    const _0x5f1952 = args.Wave || 0;
    const _0x225990 = args.Duration || 1;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.battler()) continue;
      const _0x3d7b4e = actionSequenceTarget.battler();
      let _0x4fc953 = _0x3d7b4e._baseX;
      let _0x55b313 = _0x3d7b4e._baseY;
      (_0x4fc953 += (Graphics.width - Graphics.boxWidth) / 2),
        (_0x55b313 += (Graphics.height - Graphics.boxHeight) / 2);
      if (_0x57a48c.match(/front/i)) {
        _0x4fc953 +=
          ((actionSequenceTarget.isEnemy() ? 1 : -1) *
            _0x3d7b4e.mainSpriteWidth()) /
          2;
      } else if (_0x57a48c.match(/back/i)) {
        _0x4fc953 +=
          ((actionSequenceTarget.isEnemy() ? -1 : 1) *
            _0x3d7b4e.mainSpriteWidth()) /
          2;
      }
      if (_0x57a48c.match(/head/i)) {
        _0x55b313 -= _0x3d7b4e.mainSpriteHeight();
      } else if (_0x57a48c.match(/center/i)) {
        _0x55b313 -= _0x3d7b4e.mainSpriteHeight() / 2;
      }
      _0x4fc953 += _0x23d546;
      _0x55b313 += _0x6691e9;
      spriteset.setupShockwaveImpactFilter(
        _0x4fc953,
        _0x55b313,
        _0xf9f36e,
        _0x5f1952,
        _0x225990
      );
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_ShockwaveCenterTargets",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x5523a7 = args.TargetLocation;
    const _0xcac682 = args.OffsetX || 0;
    const _0x4135bf = args.OffsetY || 0;
    const _0x1250fb = args.Amp || 0;
    const _0x5144b3 = args.Wave || 0;
    const _0x102ad5 = args.Duration || 1;
    const _0x3872bc = Math.min(
      ...actionSequenceTargets.map(
        (_0xaf69e3) =>
          _0xaf69e3.battler()._baseX - _0xaf69e3.battler().mainSpriteWidth() / 2
      )
    );
    const _0x37a603 = Math.max(
      ...actionSequenceTargets.map(
        (_0x446401) =>
          _0x446401.battler()._baseX + _0x446401.battler().mainSpriteWidth() / 2
      )
    );
    const _0x2c25a6 = Math.min(
      ...actionSequenceTargets.map(
        (_0x2ee894) =>
          _0x2ee894.battler()._baseY - _0x2ee894.battler().mainSpriteHeight()
      )
    );
    const _0x32b2cb = Math.max(
      ...actionSequenceTargets.map((_0xdddb2d) => _0xdddb2d.battler()._baseY)
    );
    const _0x554f3f = actionSequenceTargets.filter((_0x2c4254) =>
      _0x2c4254.isActor()
    )["length"];
    const _0x51ddb1 = actionSequenceTargets.filter((_0x1ee8fc) =>
      _0x1ee8fc.isEnemy()
    )["length"];
    let _0x1929cd = 0;
    let _0x38a7d7 = 0;
    if (_0x5523a7.match(/front/i))
      _0x1929cd = _0x554f3f >= _0x51ddb1 ? _0x3872bc : _0x37a603;
    else {
      if (_0x5523a7.match(/middle/i)) {
        _0x1929cd = (_0x3872bc + _0x37a603) / 2;
        melee = -1;
      } else if (_0x5523a7.match(/back/i)) {
        _0x1929cd = _0x554f3f >= _0x51ddb1 ? _0x37a603 : _0x3872bc;
      }
    }
    if (_0x5523a7.match(/head/i)) _0x38a7d7 = _0x2c25a6;
    else {
      if (_0x5523a7.match(/center/i)) {
        _0x38a7d7 = (_0x2c25a6 + _0x32b2cb) / 2;
      } else {
        if (_0x5523a7.match(/base/i)) {
          _0x38a7d7 = _0x32b2cb;
        }
      }
    }
    _0x1929cd += (Graphics.width - Graphics.boxWidth) / 2;
    _0x38a7d7 += (Graphics.height - Graphics.boxHeight) / 2;
    _0x1929cd += _0xcac682;
    _0x38a7d7 += _0x4135bf;
    spriteset.setupShockwaveImpactFilter(
      _0x1929cd,
      _0x38a7d7,
      _0x1250fb,
      _0x5144b3,
      _0x102ad5
    );
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_TimeScale",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.04) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x1f0424 = Math.max(0.01, args.Scale);
    $gameTemp.setBattleImpactTimeScale(_0x1f0424, interpreter);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_TimeStop",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.04) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x4b5280 = args.ms || 1;
    VisuMZ.ActSeqImpact.freezeTime(_0x4b5280, interpreter);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_ZoomBlurPoint",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const _0x375d0e = args.X || 0;
    const _0x22d3a3 = args.Y || 0;
    const _0x3c111d = args.Strength || 0;
    const _0x4fd20b = args.Radius || 0;
    const _0x43b6a4 = args.Duration || 1;
    const _0x24dd49 = args.EasingType || "Linear";
    spriteset.setupZoomBlurImpactFilter(
      _0x3c111d,
      _0x375d0e,
      _0x22d3a3,
      _0x4fd20b,
      _0x43b6a4,
      _0x24dd49
    );
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Impact_ZoomBlurTargetCenter",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x244f5d = args.TargetLocation;
    const _0x570f1d = args.OffsetX || 0;
    const _0x2130b8 = args.OffsetY || 0;
    const _0x1eb30f = args.Strength || 0;
    const _0x4dc773 = args.Radius || 0;
    const _0x23b6c5 = args.Duration || 1;
    const _0x4659c5 = args.EasingType || "Linear";
    const _0x5624ec = Math.min(
      ...actionSequenceTargets.map(
        (_0x2e2a00) =>
          _0x2e2a00.battler()._baseX - _0x2e2a00.battler().mainSpriteWidth() / 2
      )
    );
    const _0x397119 = Math.max(
      ...actionSequenceTargets.map(
        (_0x1bb736) =>
          _0x1bb736.battler()._baseX + _0x1bb736.battler().mainSpriteWidth() / 2
      )
    );
    const _0x28dfb7 = Math.min(
      ...actionSequenceTargets.map(
        (_0x6afc52) =>
          _0x6afc52.battler()._baseY - _0x6afc52.battler().mainSpriteHeight()
      )
    );
    const _0x4f05bd = Math.max(
      ...actionSequenceTargets.map((_0x5b0d44) => _0x5b0d44.battler()._baseY)
    );
    const _0x546776 = actionSequenceTargets.filter((_0x262dac) =>
      _0x262dac.isActor()
    )["length"];
    const _0x36af18 = actionSequenceTargets.filter((_0x564d26) =>
      _0x564d26.isEnemy()
    )["length"];
    let _0x206013 = 0;
    let _0x406437 = 0;
    if (_0x244f5d.match(/front/i)) {
      _0x206013 = _0x546776 >= _0x36af18 ? _0x5624ec : _0x397119;
    } else {
      if (_0x244f5d.match(/middle/i)) {
        _0x206013 = (_0x5624ec + _0x397119) / 2;
        melee = -1;
      } else if (_0x244f5d.match(/back/i)) {
        _0x206013 = _0x546776 >= _0x36af18 ? _0x397119 : _0x5624ec;
      }
    }
    if (_0x244f5d.match(/head/i)) {
      _0x406437 = _0x28dfb7;
    } else {
      if (_0x244f5d.match(/center/i)) {
        _0x244f5d.match(/base/i) && (_0x406437 = _0x4f05bd);
      }
    }
    _0x206013 += (Graphics.width - Graphics.boxWidth) / 2;
    _0x406437 += (Graphics.height - Graphics.boxHeight) / 2;
    _0x206013 += _0x570f1d;
    _0x406437 += _0x2130b8;
    spriteset.setupZoomBlurImpactFilter(
      _0x1eb30f,
      _0x206013,
      _0x406437,
      _0x4dc773,
      _0x23b6c5,
      _0x4659c5
    );
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Inject_AnimationStart",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.05) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x4e74ba = {
      filename: args.Filename,
      horzCells: args.horzCells || 1,
      vertCells: args.vertCells || 1,
      frameDelay: args.frameDelay || 1,
      smooth: args.smooth || false,
      anchorX: args.anchorX || 0,
      anchorY: args.anchorY || 0,
      offsetX: args.offsetX || 0,
      offsetY: args.offsetY || 0,
    };
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.battler()) continue;
      actionSequenceTarget.battler()["startInjectAnimation"](_0x4e74ba);
    }
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (interpreter) {
      interpreter.setWaitMode("battleInjectPrep");
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Inject_AnimationEnd",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.05) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.battler()) continue;
      actionSequenceTarget.battler()["stopInjectAnimation"]();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Inject_AnimationPauseResume",
  (args) => {
    if (!Imported.VisuMZ_3_ActSeqImpact) return;
    const spriteset = SceneManager._scene._spriteset;
    if (!spriteset) return;
    if (VisuMZ.ActSeqImpact.version <= 1.05) {
      alert("Action Sequence Impact needs an update!"), SceneManager.exit();
      return;
    }
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x2a7d9f = args.pause;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.battler()) continue;
      actionSequenceTarget.battler()["pauseInjectAnimation"](_0x2a7d9f);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Inject_WaitForInjectAni",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleInjectAni");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_ActionEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    const logWindow = BattleManager._logWindow;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      logWindow.push("actionEffect", subject, actionSequenceTarget);
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_ActiveChainInputDisable",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActiveChainSkills) return;
    $gameTemp._performActionEnd = true;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_AddBuffDebuff",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x39a262 = [
        "MAXHP",
        "MAXMP",
        "ATK",
        "DEF",
        "MAT",
        "MDF",
        "AGI",
        "LUK",
      ],
      _0x2f1e50 = args.Buffs,
      _0x33ef03 = args.Debuffs,
      _0x130350 = args.Turns,
      _0x4135f7 = VisuMZ.CreateActionSequenceTargets(args.Targets);
    for (const _0x837944 of _0x4135f7) {
      if (!_0x837944) continue;
      for (const _0x3ffa62 of _0x2f1e50) {
        const _0x43ae48 = _0x39a262.indexOf(_0x3ffa62.toUpperCase().trim());
        _0x43ae48 >= 0 &&
          _0x43ae48 <= 7 &&
          _0x837944.addBuff(_0x43ae48, _0x130350);
      }
      for (const _0x1bcdd9 of _0x33ef03) {
        const _0x940488 = _0x39a262.indexOf(_0x1bcdd9.toUpperCase().trim());
        _0x940488 >= 0 &&
          _0x940488 <= 7 &&
          _0x837944.addDebuff(_0x940488, _0x130350);
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_AddState",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x1a41a6 = args.States;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      for (const _0x1d1dc9 of _0x1a41a6) {
        actionSequenceTarget.addState(_0x1d1dc9);
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_ArmorPenetration",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const action = BattleManager._action;
    const _0x410779 = {
      arPenRate: args.ArPenRate,
      arPenFlat: args.ArPenFlat,
      arRedRate: args.ArRedRate,
      arRedFlat: args.ArRedFlat,
    };
    action._armorPenetration = _0x410779;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_AnalyzeWeakness",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_WeaknessDisplay) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x5e7935 = args.Reveal || 1;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isEnemy()) continue;
      actionSequenceTarget.revealNewWeaknesses(_0x5e7935);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_AtbGauge",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemATB) return;
    if (!BattleManager.isATB()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x5e396f = args.ChargeRate;
    const _0x401f9f = args.ChargeRate;
    const _0xf5529d = args.Interrupt;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (actionSequenceTarget.isAtbChargingState()) {
        actionSequenceTarget.changeAtbChargeTime(_0x5e396f);
      } else {
        if (actionSequenceTarget.isAtbCastingState()) {
          actionSequenceTarget.changeAtbCastTime(_0x401f9f);
          if (_0xf5529d) actionSequenceTarget.atbInterrupt();
        }
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_BoostPointsChange",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_BoostAction) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x20f273 = args.BoostPoints;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.gainStoredBoostPoints(_0x20f273);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_BoostPointsStoreData",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_BoostAction) return;
    if (!BattleManager._subject) return;
    VisuMZ.ConvertParams(args, args);
    const _0x3fc957 = args.VariableID;
    $gameVariables.setValue(
      _0x3fc957,
      BattleManager._subject.toUseBoostPoints()
    );
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_BreakShieldChange",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_4_BreakShields) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x3b3810 = args.BreakShields;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (actionSequenceTarget.isBreakStunned()) continue;
      if (!actionSequenceTarget.isAffectedByBreakShield()) continue;
      actionSequenceTarget.alterBreakShield(_0x3b3810);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_BreakShieldReset",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_4_BreakShields) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (actionSequenceTarget.isBreakStunned()) continue;
      if (!actionSequenceTarget.isAffectedByBreakShield()) continue;
      actionSequenceTarget.resetBreakShield();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_BtbGain",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemBTB) return;
    if (!BattleManager.isBTB()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x296938 = args.BravePoints;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.gainBravePoints(_0x296938);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_Collapse",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    const subject = BattleManager._subject;
    if (!interpreter || !action || !subject) return;
    if (!action.item()) return;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      args.ForceDeath &&
        (actionSequenceTarget.removeImmortal(),
        actionSequenceTarget.addState(actionSequenceTarget.deathStateId())),
        actionSequenceTarget.isDeathStateAffected() &&
          actionSequenceTarget.performCollapse();
    }
    interpreter.setWaitMode("battleEffect");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_CtbOrder",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemCTB) return;
    if (!BattleManager.isCTB()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x3ec1a1 = args.ChangeOrderBy;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.changeTurnOrderByCTB(_0x3ec1a1);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_CtbSpeed",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemCTB) return;
    if (!BattleManager.isCTB()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x599e7f = args.ChargeRate;
    const _0x307aa0 = args.ChargeRate;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (actionSequenceTarget._tpbState === "charging") {
        actionSequenceTarget.changeCtbChargeTime(_0x599e7f);
      } else if (actionSequenceTarget._tpbState === "casting") {
        actionSequenceTarget.changeCtbCastTime(_0x307aa0);
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_CustomDmgFormula",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const action = BattleManager._action;
    if (!action) return;
    let _0x3bc932 = args.Formula;
    action.setCustomDamageFormula(_0x3bc932);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_DamagePopup",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (actionSequenceTarget.shouldPopupDamage())
        actionSequenceTarget.startDamagePopup();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_DeathBreak",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const subject = BattleManager._subject;
    const _0x1a88e0 = args.JumpToLabel;
    if (!interpreter) return;
    if (!subject) return;
    subject &&
      subject.isDead() &&
      _0x1a88e0.toUpperCase().trim() !== "UNTITLED" &&
      interpreter.command119([_0x1a88e0]);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EmulateAttackEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const logWindow = BattleManager._logWindow;
    if (!interpreter) return;
    const actionSequenceUsers = VisuMZ.CreateActionSequenceTargets(args.Users);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const _0x404817 of actionSequenceUsers) {
      for (const actionSequenceTarget of actionSequenceTargets) {
        if (!actionSequenceTarget) continue;
        const _0x160078 = $dataSkills[_0x404817.attackSkillId()];
        logWindow.push(
          "emulateActionEffect",
          _0x404817,
          actionSequenceTarget,
          _0x160078
        );
      }
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EmulateGuardEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const logWindow = BattleManager._logWindow;
    if (!interpreter) return;
    const actionSequenceUsers = VisuMZ.CreateActionSequenceTargets(args.Users);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const _0x216b2c of actionSequenceUsers) {
      for (const actionSequenceTarget of actionSequenceTargets) {
        if (!actionSequenceTarget) continue;
        const _0x48b868 = $dataSkills[_0x216b2c.guardSkillId()];
        logWindow.push(
          "emulateActionEffect",
          _0x216b2c,
          actionSequenceTarget,
          _0x48b868
        );
      }
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EmulateItemEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const logWindow = BattleManager._logWindow;
    const _0x2feb61 = Number(args.ItemID || 1);
    const _0x40cf7e = $dataItems[_0x2feb61];
    if (!interpreter) return;
    if (!_0x40cf7e) return;
    const actionSequenceUsers = VisuMZ.CreateActionSequenceTargets(args.Users);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const _0x343f8d of actionSequenceUsers) {
      for (const actionSequenceTarget of actionSequenceTargets) {
        if (!actionSequenceTarget) continue;
        logWindow.push(
          "emulateActionEffect",
          _0x343f8d,
          actionSequenceTarget,
          _0x40cf7e
        );
      }
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EmulateSkillCost",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    let _0xafe3fe = Number(args.SkillID || 0);
    if (_0xafe3fe <= 0) {
      const action = BattleManager._action;
      if (action && action.isSkill()) {
        _0xafe3fe = action.item().id;
      } else {
        return;
      }
    }
    const _0x4780d7 = $dataSkills[_0xafe3fe];
    if (!_0x4780d7) return;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Users
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      actionSequenceTarget.paySkillCost(_0x4780d7);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EmulateSkillEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const logWindow = BattleManager._logWindow;
    const _0x2254fc = Number(args.SkillID || 1);
    const _0x384667 = $dataSkills[_0x2254fc];
    if (!interpreter) return;
    if (!_0x384667) return;
    const actionSequenceUsers = VisuMZ.CreateActionSequenceTargets(args.Users);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const _0x1be6bb of actionSequenceUsers) {
      for (const actionSequenceTarget of actionSequenceTargets) {
        if (!actionSequenceTarget) continue;
        logWindow.push(
          "emulateActionEffect",
          _0x1be6bb,
          actionSequenceTarget,
          _0x384667
        );
      }
    }
    interpreter.setWaitMode("battlelog");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EnemyEscape",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isEnemy()) continue;
      actionSequenceTarget.escape();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_EtbAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemETB) return;
    if (!BattleManager.isETB()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x49d565 = args.ActionCount;
    if (BattleManager._subject) {
      BattleManager._subject.friendsUnit()["gainCurrentActionsETB"](_0x49d565);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_FtbAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemFTB) return;
    if (!BattleManager.isFTB()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x66a933 = args.ActionCount;
    BattleManager._subject &&
      BattleManager._subject.friendsUnit()["gainCurrentActionsFTB"](_0x66a933);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_HpMpTp",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x7071b2 = args.HP_Rate;
    const _0x5ad7d3 = args.HP_Flat;
    const _0x525089 = args.MP_Rate;
    const _0x30298a = args.MP_Flat;
    const _0x92c49 = args.TP_Rate;
    const _0x3b035d = args.TP_Flat;
    const _0x4dbfb7 = args.ShowPopup;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      const _0x23bf13 = actionSequenceTarget.isAlive();
      const _0x130173 = Math.round(
        _0x7071b2 * actionSequenceTarget.mhp + _0x5ad7d3
      );
      const _0x40f80a = Math.round(
        _0x525089 * actionSequenceTarget.mmp + _0x30298a
      );
      const _0x18ecb3 = Math.round(
        _0x92c49 * actionSequenceTarget.maxTp() + _0x3b035d
      );
      if (_0x130173 !== 0) actionSequenceTarget.gainHp(_0x130173);
      if (_0x40f80a !== 0) actionSequenceTarget.gainMp(_0x40f80a);
      if (_0x18ecb3 !== 0) actionSequenceTarget.gainTp(_0x18ecb3);
      if (_0x4dbfb7) actionSequenceTarget.startDamagePopup();
      _0x23bf13 &&
        actionSequenceTarget.isDead() &&
        actionSequenceTarget.performCollapse();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_Immortal",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setImmortal(args.Immortal);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_Multipliers",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const action = BattleManager._action;
    const _0x721fd4 = {
      criticalHitRate: args.CriticalHitRate,
      criticalHitFlat: args.CriticalHitFlat,
      criticalDmgRate: args.CriticalDmgRate,
      criticalDmgFlat: args.CriticalDmgFlat,
      damageRate: args.DamageRate,
      damageFlat: args.DamageFlat,
      hitRate: args.HitRate,
      hitFlat: args.HitFlat,
    };
    action._multipliers = _0x721fd4;
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_OnceParallel",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x507118 = args.CommonEventID;
    SceneManager._scene.playOnceParallelInterpreter(_0x507118);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_OtbOrder",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemOTB) return;
    if (!BattleManager.isOTB()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      let _0x48e838 = args.CurrentTurn;
      let _0x42f0f3 = args.NextTurn;
      let _0xf84d95 = args.FollowTurn;
      BattleManager._actionBattlers.includes(actionSequenceTarget)
        ? (_0x48e838 += _0xf84d95)
        : (_0x42f0f3 += _0xf84d95),
        BattleManager.turnOrderChangeOTB(
          actionSequenceTarget,
          -_0x48e838,
          false
        ),
        BattleManager.turnOrderChangeOTB(
          actionSequenceTarget,
          -_0x42f0f3,
          true
        );
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_PtbAlterCost",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemPTB) return;
    if (!BattleManager.isPTB()) return;
    VisuMZ.ConvertParams(args, args);
    const subject = BattleManager._subject.friendsUnit();
    const _0x56c33d = args.Override;
    const _0x4fd71c = args.alterChange || "unchanged";
    const _0x9be92f = args.alterType || "unchanged";
    const _0x51d37c = args.alterCost || 0;
    const _0xb00610 = args.alterPriority || 0;
    if (subject.canAlterActionCostPTB() || _0x56c33d) {
      _0x56c33d &&
        ((subject._ptbActionCost = subject._ptbActionCost || {}),
        (subject._ptbActionCost.priority = 0)),
        subject.alterActionCostPTB(_0x4fd71c, _0x9be92f, _0x51d37c, _0xb00610);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_PtbConvert",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemPTB) return;
    if (!BattleManager.isPTB()) return;
    VisuMZ.ConvertParams(args, args);
    const subject = BattleManager._subject.friendsUnit();
    let _0x1f770b = Math.max(args.ConvertCount, 0);
    let _0x2faeb2 = subject.getFullActionsPTB();
    let _0x270a81 = subject.getHalfActionsPTB();
    while (_0x1f770b--) {
      if (_0x2faeb2 <= 0 && _0x270a81 <= 0) {
        break;
      } else _0x2faeb2 > 0 ? (_0x2faeb2--, _0x270a81++) : _0x270a81--;
    }
    subject.setFullActionsPTB(_0x2faeb2), subject.setHalfActionsPTB(_0x270a81);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_PtbFullHalfAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemPTB) return;
    if (!BattleManager.isPTB()) return;
    VisuMZ.ConvertParams(args, args);
    const subject = BattleManager._subject.friendsUnit();
    let _0x27e953 = args.FullActions;
    let _0x276c41 = args.HalfActions;
    subject.gainFullActionsPTB(_0x27e953),
      subject.gainHalfActionsPTB(_0x276c41);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_RemoveBuffDebuff",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x5cfe9b = [
        "MAXHP",
        "MAXMP",
        "ATK",
        "DEF",
        "MAT",
        "MDF",
        "AGI",
        "LUK",
      ],
      _0x4f62a5 = args.Buffs,
      _0x3061fd = args.Debuffs,
      _0x31e67c = VisuMZ.CreateActionSequenceTargets(args.Targets);
    for (const _0x280ad1 of _0x31e67c) {
      if (!_0x280ad1) continue;
      for (const _0x4e0a69 of _0x4f62a5) {
        const _0x421300 = _0x5cfe9b.indexOf(_0x4e0a69.toUpperCase().trim());
        _0x421300 >= 0 &&
          _0x421300 <= 7 &&
          _0x280ad1.isBuffAffected(_0x421300) &&
          _0x280ad1.removeBuff(_0x421300);
      }
      for (const _0x3b8322 of _0x3061fd) {
        const _0x54179f = _0x5cfe9b.indexOf(_0x3b8322.toUpperCase().trim());
        _0x54179f >= 0 &&
          _0x54179f <= 7 &&
          _0x280ad1.isDebuffAffected(_0x54179f) &&
          _0x280ad1.removeBuff(_0x54179f);
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_RemoveState",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x38c9f1 = args.States;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      for (const _0x5e9cf7 of _0x38c9f1) {
        actionSequenceTarget.removeState(_0x5e9cf7);
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_StateTurnsChangeBy",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_1_SkillsStatesCore) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x2eaaa6 = Number(args.StateID);
    const _0x518258 = Number(args.Turns);
    const _0xb03e50 = args.AutoAddState;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (_0xb03e50 && !actionSequenceTarget.isStateAffected(_0x2eaaa6)) {
        actionSequenceTarget.addState(_0x2eaaa6);
        actionSequenceTarget.setStateTurns(_0x2eaaa6, _0x518258);
      } else {
        actionSequenceTarget.addStateTurns(_0x2eaaa6, _0x518258);
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_StateTurnsChangeTo",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_1_SkillsStatesCore) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x4ae3a9 = Number(args.StateID);
    const _0xb31a1e = Math.max(Number(args.Turns), 0);
    const _0x2226e7 = args.AutoAddState;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      _0x2226e7 &&
        !actionSequenceTarget.isStateAffected(_0x4ae3a9) &&
        actionSequenceTarget.addState(_0x4ae3a9);
      actionSequenceTarget.setStateTurns(_0x4ae3a9, _0xb31a1e);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_StbExploit",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemSTB) return;
    if (!BattleManager.isSTB()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x39f7db = args.Exploited;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x380887 = args.ForceExploited;
    const _0xbb0e9d = args.Exploiter;
    const _0x1fd3c1 = args.ForceExploiter;
    const action = BattleManager._action;
    if (_0x39f7db)
      for (const actionSequenceTarget of actionSequenceTargets) {
        if (!actionSequenceTarget) continue;
        if (actionSequenceTarget === user) continue;
        if (_0x380887) actionSequenceTarget.setSTBExploited(false);
        actionSequenceTarget.becomeSTBExploited(BattleManager._subject, action);
      }
    if (_0xbb0e9d && BattleManager._subject) {
      if (_0x1fd3c1) BattleManager._subject.setSTBExploited(false);
      const _0x1c9859 = actionSequenceTargets[0];
      BattleManager.performSTBExploiter(_0x1c9859, action);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_StbExtraAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemSTB) return;
    if (!BattleManager.isSTB()) return;
    VisuMZ.ConvertParams(args, args);
    const _0x4f30aa = args.Actions;
    BattleManager._subject && BattleManager._subject.stbGainInstant(_0x4f30aa);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_StbRemoveExcessActions",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_BattleSystemSTB) return;
    if (!BattleManager.isSTB()) return;
    VisuMZ.ConvertParams(args, args);
    let _0x46e437 = args.Actions;
    if (BattleManager._subject) {
      BattleManager._subject._actions = BattleManager._subject._actions || [];
      while (_0x46e437--) {
        if (BattleManager._subject._actions.length <= 0) break;
        BattleManager._subject._actions.shift();
      }
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_SwapWeapon",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_2_WeaponSwapSystem) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x22e554 = args.WeaponTypeID;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isActor()) continue;
      actionSequenceTarget.switchToWeaponType(_0x22e554);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_TextPopup",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x2dbec7 = args.Text;
    const _0x43287b = {
      textColor: ColorManager.getColor(args.TextColor),
      flashColor: args.FlashColor,
      flashDuration: args.FlashDuration,
    };
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setupTextPopup(_0x2dbec7, _0x43287b);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_VariablePopup",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    let _0x8e82ec = $gameVariables.value(args.Variable);
    Imported.VisuMZ_0_CoreEngine &&
      args.DigitGrouping &&
      (_0x8e82ec = VisuMZ.GroupDigits(_0x8e82ec));
    const _0x5c0bf6 = String(_0x8e82ec);
    const _0x595fc7 = {
      textColor: ColorManager.getColor(args.TextColor),
      flashColor: args.FlashColor,
      flashDuration: args.FlashDuration,
    };
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setupTextPopup(_0x5c0bf6, _0x595fc7);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Mechanics_WaitForEffect",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleEffect");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Motion_ClearFreezeFrame",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.clearFreezeMotion();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Motion_FreezeMotionFrame",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x6c60ce = args.MotionType.toLowerCase().trim();
    let _0x37467b = args.ShowWeapon;
    const _0x65bf04 = args.Frame;
    !["attack", "thrust", "swing", "missile"]["includes"](_0x6c60ce) &&
      (_0x37467b = false);
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.freezeMotion(_0x6c60ce, _0x37467b, _0x65bf04);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Motion_MotionType",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x5c3829 = args.MotionType.toLowerCase().trim();
    const _0x15d0d0 = args.ShowWeapon;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget._showWeapon = _0x15d0d0;
      if (_0x5c3829.match(/ATTACK[ ](\d+)/i)) {
        actionSequenceTarget.performAttackSlot(Number(RegExp["$1"]));
      } else {
        _0x5c3829 === "attack"
          ? actionSequenceTarget.performAttack()
          : actionSequenceTarget.requestMotion(_0x5c3829);
      }
      if (!_0x15d0d0) actionSequenceTarget.startWeaponAnimation(0);
      else {
        if (_0x15d0d0 && ["thrust", "swing", "missle"]["includes"](_0x5c3829)) {
        }
      }
      actionSequenceTarget._showWeapon = undefined;
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Motion_PerformAction",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const action = BattleManager._action;
    if (!action) return;
    if (!action.item()) return;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.performAction(action);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Motion_RefreshMotion",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.battler()) continue;
      actionSequenceTarget.battler()["refreshMotion"]();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Motion_WaitMotionFrame",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x3651df = args.MotionFrameWait * Sprite_Battler._motionSpeed;
    interpreter.wait(_0x3651df);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_BattleStep",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const action = BattleManager._action;
    if (!interpreter || !action) return;
    if (!action.item()) return;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.performActionStart(action);
    }
    if (args.WaitForMovement) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_HomeMoveBy",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x1d8f59 = args.DistanceAdjust;
    const _0x2f6cff = args.DistanceX;
    const _0x4de542 = args.DistanceY;
    const _0x1a509f = args.Duration;
    const _0x2c4f5d = args.FaceDirection;
    const _0x1d902e = args.EasingType;
    const _0x403ccd = args.MotionType;
    const _0x788aad = args.WaitForMovement;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      let _0xc39ca1 = _0x2f6cff;
      let _0x3c04dd = _0x4de542;
      if (_0x1d8f59.match(/horz/i)) {
        _0xc39ca1 *= actionSequenceTarget.isActor() ? -1 : 1;
      }
      if (_0x1d8f59.match(/vert/i)) {
        _0x3c04dd *= actionSequenceTarget.isActor() ? -1 : 1;
      }
      actionSequenceTarget.moveBattlerHomeDistance(
        _0xc39ca1,
        _0x3c04dd,
        _0x1a509f,
        _0x2c4f5d,
        _0x1d902e
      );
      actionSequenceTarget.requestMotion(_0x403ccd);
    }
    if (_0x788aad) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_HomeMoveToJsPoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x5e8a39 = args.OffsetAdjust;
    const _0x5a3f83 = args.OffsetX;
    const _0x35c7f6 = args.OffsetY;
    const _0x11e307 = args.Duration;
    const _0x64f51d = args.FaceDirection;
    const _0x160163 = args.EasingType;
    const _0x113d9d = args.MotionType;
    const _0x42598d = args.WaitForMovement;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      const _0x1ec358 = args.DestinationJS(actionSequenceTarget) || {
        x: 0,
        y: 0,
      };
      let _0x5fa36e = _0x1ec358.x;
      let _0x5264b1 = _0x1ec358.y;
      if (_0x5e8a39.match(/none/i))
        (_0x5fa36e += _0x5a3f83), (_0x5264b1 += _0x35c7f6);
      else {
        if (_0x5e8a39.match(/horz/i) && _0x5e8a39.match(/vert/i)) {
          (_0x5fa36e += actionSequenceTarget.isActor()
            ? -_0x5a3f83
            : _0x5a3f83),
            (_0x5264b1 += actionSequenceTarget.isActor()
              ? -_0x35c7f6
              : _0x35c7f6);
        } else {
          if (_0x5e8a39.match(/horz/i))
            (_0x5fa36e += actionSequenceTarget.isActor()
              ? -_0x5a3f83
              : _0x5a3f83),
              (_0x5264b1 += _0x35c7f6);
          else
            _0x5e8a39.match(/vert/i) &&
              ((_0x5fa36e += _0x5a3f83),
              (_0x5264b1 += actionSequenceTarget.isActor()
                ? -_0x35c7f6
                : _0x35c7f6));
        }
      }
      actionSequenceTarget.moveBattlerHomeToPoint(
        _0x5fa36e,
        _0x5264b1,
        _0x11e307,
        _0x64f51d,
        _0x160163,
        -1
      ),
        actionSequenceTarget.requestMotion(_0x113d9d);
    }
    if (_0x42598d) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_HomeMoveToPoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x23fe9c = args.Destination;
    const _0x4fdb71 = args.OffsetAdjust;
    const _0x5aa672 = args.OffsetX;
    const _0x2fbab2 = args.OffsetY;
    const _0x15e113 = args.Duration;
    const _0x2a44ca = args.FaceDirection;
    const _0x27d7c8 = args.EasingType;
    const _0x200054 = args.MotionType;
    const _0x3d408f = args.WaitForMovement;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      let _0x56b565 = actionSequenceTarget.battler()._baseX;
      let _0x2a1437 = actionSequenceTarget.battler()._baseY;
      if (_0x23fe9c.match(/home/i)) {
        _0x56b565 = actionSequenceTarget.battler()["_homeX"];
        _0x2a1437 = actionSequenceTarget.battler()["_homeY"];
      } else {
        if (_0x23fe9c.match(/center/i)) {
          _0x56b565 = Graphics.boxWidth / 2;
          _0x2a1437 = Graphics.boxHeight / 2;
        } else {
          if (_0x23fe9c.match(/point (\d+), (\d+)/i)) {
            _0x56b565 = Number(RegExp["$1"]);
            _0x2a1437 = Number(RegExp["$2"]);
          }
        }
      }
      if (_0x4fdb71.match(/none/i)) {
        (_0x56b565 += _0x5aa672), (_0x2a1437 += _0x2fbab2);
      } else {
        if (_0x4fdb71.match(/horz/i) && _0x4fdb71.match(/vert/i)) {
          (_0x56b565 += actionSequenceTarget.isActor()
            ? -_0x5aa672
            : _0x5aa672),
            (_0x2a1437 += actionSequenceTarget.isActor()
              ? -_0x2fbab2
              : _0x2fbab2);
        } else {
          if (_0x4fdb71.match(/horz/i)) {
            (_0x56b565 += actionSequenceTarget.isActor()
              ? -_0x5aa672
              : _0x5aa672),
              (_0x2a1437 += _0x2fbab2);
          } else {
            if (_0x4fdb71.match(/vert/i)) {
              _0x56b565 += _0x5aa672;
              _0x2a1437 += actionSequenceTarget.isActor()
                ? -_0x2fbab2
                : _0x2fbab2;
            }
          }
        }
      }
      actionSequenceTarget.moveBattlerHomeToPoint(
        _0x56b565,
        _0x2a1437,
        _0x15e113,
        _0x2a44ca,
        _0x27d7c8,
        -1
      ),
        actionSequenceTarget.requestMotion(_0x200054);
    }
    if (_0x3d408f) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_HomeMoveToTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets1 = VisuMZ.CreateActionSequenceTargets(
      args.Targets1
    );
    const actionSequenceTargets2 = VisuMZ.CreateActionSequenceTargets(
      args.Targets2
    );
    const targetLocation = args.TargetLocation;
    let distance = args.MeleeDistance;
    const _0x3b44b0 = args.OffsetAdjust;
    const _0x162c7c = args.OffsetX;
    const _0x1c062e = args.OffsetY;
    const _0x57f8d9 = args.Duration;
    const _0x2cb78f = args.FaceDirection;
    const _0x362337 = args.EasingType;
    const _0x38332c = args.MotionType;
    const _0x98fb8d = args.WaitForMovement;
    const _0x4c50b1 = Math.min(
      ...actionSequenceTargets2.map(
        (_0x3022a0) =>
          _0x3022a0.battler()["_baseX"] -
          _0x3022a0.battler()["mainSpriteWidth"]() / 2
      )
    );
    const _0x1dceb7 = Math.max(
      ...actionSequenceTargets2.map(
        (_0x4e0b1e) =>
          _0x4e0b1e.battler()["_baseX"] +
          _0x4e0b1e.battler()["mainSpriteWidth"]() / 2
      )
    );
    const _0x53c21d = Math.min(
      ...actionSequenceTargets2.map(
        (_0x3a2a97) =>
          _0x3a2a97.battler()["_baseY"] -
          _0x3a2a97.battler()["mainSpriteHeight"]()
      )
    );
    const _0x2bfb78 = Math.max(
      ...actionSequenceTargets2.map(
        (_0xbc0149) => _0xbc0149.battler()["_baseY"]
      )
    );
    const _0x5b28af = actionSequenceTargets2.filter((_0x2e5f32) =>
      _0x2e5f32.isActor()
    )["length"];
    const _0x23bdb2 = actionSequenceTargets2.filter((_0x49ef1f) =>
      _0x49ef1f.isEnemy()
    )["length"];
    let _0x49a16d = 0;
    let _0x308736 = 0;
    if (targetLocation.match(/front/i))
      _0x49a16d = _0x5b28af >= _0x23bdb2 ? _0x4c50b1 : _0x1dceb7;
    else {
      if (targetLocation.match(/middle/i)) {
        if (!this._mainSprite) return;
        if (!this._shadowSprite) return;
        this.updateShadowVisibility(), this.updateShadowPosition();
      } else
        targetLocation.match(/back/i) &&
          (_0x49a16d = _0x5b28af >= _0x23bdb2 ? _0x1dceb7 : _0x4c50b1);
    }
    if (targetLocation.match(/head/i)) _0x308736 = _0x53c21d;
    else {
      if (targetLocation.match(/center/i))
        _0x308736 = (_0x53c21d + _0x2bfb78) / 2;
      else targetLocation.match(/base/i) && (_0x308736 = _0x2bfb78);
    }
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets1) {
      if (!actionSequenceTarget) continue;
      let _0x263015 = _0x49a16d;
      let _0x573cb3 = _0x308736;
      if (_0x3b44b0.match(/none/i))
        (_0x263015 += _0x162c7c), (_0x573cb3 += _0x1c062e);
      else {
        if (_0x3b44b0.match(/horz/i) && _0x3b44b0.match(/vert/i))
          (_0x263015 += actionSequenceTarget.isActor()
            ? -_0x162c7c
            : _0x162c7c),
            (_0x573cb3 += actionSequenceTarget.isActor()
              ? -_0x1c062e
              : _0x1c062e);
        else {
          if (_0x3b44b0.match(/horz/i))
            (_0x263015 += actionSequenceTarget.isActor()
              ? -_0x162c7c
              : _0x162c7c),
              (_0x573cb3 += _0x1c062e);
          else
            _0x3b44b0.match(/vert/i) &&
              ((_0x263015 += _0x162c7c),
              (_0x573cb3 += actionSequenceTarget.isActor()
                ? -_0x1c062e
                : _0x1c062e));
        }
      }
      actionSequenceTarget.moveBattlerHomeToPoint(
        _0x263015,
        _0x573cb3,
        _0x57f8d9,
        _0x2cb78f,
        _0x362337,
        distance
      ),
        actionSequenceTarget.requestMotion(_0x38332c);
    }
    if (_0x98fb8d) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_FaceDirection",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    let _0x1f945b = args.Direction.match(/back/i);
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (args.Direction.match(/rand/i)) _0x1f945b = Math.randomInt(2);
      actionSequenceTarget.setBattlerFlip(!!_0x1f945b);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_FaceJsPoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x4587e5 = args.FaceAway;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      const _0xc6bc89 = args.PointJS(actionSequenceTarget) || {
        x: 0,
        y: 0,
      };
      let _0x25d62a = _0xc6bc89.x;
      let _0x2569ce = _0xc6bc89.y;
      actionSequenceTarget.setBattlerFacePoint(
        Math.round(_0x25d62a),
        Math.round(_0x2569ce),
        !!_0x4587e5
      );
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_FacePoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    let _0x52320e = args.Point;
    const _0x235242 = args.FaceAway;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      let _0x11d291 = actionSequenceTarget.battler()._baseX;
      let _0xa28df3 = actionSequenceTarget.battler()._baseY;
      if (_0x52320e.match(/home/i)) {
        _0x11d291 = actionSequenceTarget.battler()["_homeX"];
        _0xa28df3 = actionSequenceTarget.battler()["_homeY"];
      } else {
        if (_0x52320e.match(/center/i))
          (_0x11d291 = Graphics.boxWidth / 2),
            (_0xa28df3 = Graphics.boxHeight / 2);
        else
          _0x52320e.match(/point (\d+), (\d+)/i) &&
            ((_0x11d291 = Number(RegExp["$1"])),
            (_0xa28df3 = Number(RegExp["$2"])));
      }
      actionSequenceTarget.setBattlerFacePoint(
        Math.round(_0x11d291),
        Math.round(_0xa28df3),
        !!_0x235242
      );
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_FaceTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets1 = VisuMZ.CreateActionSequenceTargets(
      args.Targets1
    );
    const actionSequenceTargets2 = VisuMZ.CreateActionSequenceTargets(
      args.Targets2
    );
    const _0x5c786e =
      actionSequenceTargets2.map((_0x8b107c) =>
        _0x8b107c && _0x8b107c.battler() ? _0x8b107c.battler()["_baseX"] : 0
      ) / (actionSequenceTargets2.length || 1);
    const _0x42f073 =
      actionSequenceTargets2.map((_0x20ba55) =>
        _0x20ba55 && _0x20ba55.battler() ? _0x20ba55.battler()["_baseY"] : 0
      ) / (actionSequenceTargets2.length || 1);
    const _0x5d5c5c = args.FaceAway;
    for (const actionSequenceTarget of actionSequenceTargets1) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.setBattlerFacePoint(
        Math.round(_0x5c786e),
        Math.round(_0x42f073),
        !!_0x5d5c5c
      );
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_Float",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x18777a = args.Height;
    const _0xbdf40b = args.Duration;
    const _0x3f9733 = args.EasingType;
    const _0x29dfbe = args.WaitForFloat;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.floatBattler(_0x18777a, _0xbdf40b, _0x3f9733);
    }
    if (_0x29dfbe) interpreter.setWaitMode("battleFloat");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_HomeReset",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.performActionEndMembers();
    }
    BattleManager._subject && BattleManager._subject.performActionEnd();
    if (args.WaitForMovement) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_Jump",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x560d43 = args.Height;
    const _0x2242e2 = args.Duration;
    const _0x190fb1 = args.WaitForJump;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.jumpBattler(_0x560d43, _0x2242e2);
    }
    if (_0x190fb1) interpreter.setWaitMode("battleJump");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_MoveBy",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x352f98 = args.DistanceAdjust;
    const _0x41ed86 = args.DistanceX;
    const _0x1a4d36 = args.DistanceY;
    const _0x48370f = args.Duration;
    const _0xfadd0d = args.FaceDirection;
    const _0x359ebc = args.EasingType;
    const _0x3fa7ac = args.MotionType;
    const _0x1ab31c = args.WaitForMovement;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      let _0x496708 = _0x41ed86;
      let _0xde8dfa = _0x1a4d36;
      if (_0x352f98.match(/horz/i))
        _0x496708 *= actionSequenceTarget.isActor() ? -1 : 1;
      if (_0x352f98.match(/vert/i))
        _0xde8dfa *= actionSequenceTarget.isActor() ? -1 : 1;
      actionSequenceTarget.moveBattlerDistance(
        _0x496708,
        _0xde8dfa,
        _0x48370f,
        _0xfadd0d,
        _0x359ebc
      ),
        actionSequenceTarget.requestMotion(_0x3fa7ac);
    }
    if (_0x1ab31c) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_MoveToJsPoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0xebc31a = args.OffsetAdjust;
    const _0x2ac84e = args.OffsetX;
    const _0x28811f = args.OffsetY;
    const _0x7117fb = args.Duration;
    const _0x49e205 = args.FaceDirection;
    const _0x27771c = args.EasingType;
    const _0x18b50f = args.MotionType;
    const _0x41c47a = args.WaitForMovement;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      const _0x18b44d = args.DestinationJS(actionSequenceTarget) || {
        x: 0,
        y: 0,
      };
      let _0x2277c8 = _0x18b44d.x;
      let _0x3bdc3f = _0x18b44d.y;
      if (_0xebc31a.match(/none/i))
        (_0x2277c8 += _0x2ac84e), (_0x3bdc3f += _0x28811f);
      else {
        if (_0xebc31a.match(/horz/i) && _0xebc31a.match(/vert/i))
          (_0x2277c8 += actionSequenceTarget.isActor()
            ? -_0x2ac84e
            : _0x2ac84e),
            (_0x3bdc3f += actionSequenceTarget.isActor()
              ? -_0x28811f
              : _0x28811f);
        else {
          if (_0xebc31a.match(/horz/i))
            (_0x2277c8 += actionSequenceTarget.isActor()
              ? -_0x2ac84e
              : _0x2ac84e),
              (_0x3bdc3f += _0x28811f);
          else
            _0xebc31a.match(/vert/i) &&
              ((_0x2277c8 += _0x2ac84e),
              (_0x3bdc3f += actionSequenceTarget.isActor()
                ? -_0x28811f
                : _0x28811f));
        }
      }
      actionSequenceTarget.moveBattlerToPoint(
        _0x2277c8,
        _0x3bdc3f,
        _0x7117fb,
        _0x49e205,
        _0x27771c,
        -1
      ),
        actionSequenceTarget.requestMotion(_0x18b50f);
    }
    if (_0x41c47a) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_MoveToPoint",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x40cd35 = args.Destination;
    const _0x5357f6 = args.OffsetAdjust;
    const _0x4a0c02 = args.OffsetX;
    const _0xe355a3 = args.OffsetY;
    const _0x4394b0 = args.Duration;
    const _0xf2611b = args.FaceDirection;
    const _0x4d43de = args.EasingType;
    const _0x2caea9 = args.MotionType;
    const _0x14f779 = args.WaitForMovement;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      let _0x381894 = actionSequenceTarget.battler()._baseX;
      let _0x2d409d = actionSequenceTarget.battler()._baseY;
      if (_0x40cd35.match(/home/i))
        (_0x381894 = actionSequenceTarget.battler()["_homeX"]),
          (_0x2d409d = actionSequenceTarget.battler()["_homeY"]);
      else {
        if (_0x40cd35.match(/center/i))
          (_0x381894 = Graphics.boxWidth / 2),
            (_0x2d409d = Graphics.boxHeight / 2);
        else
          _0x40cd35.match(/point (\d+), (\d+)/i) &&
            ((_0x381894 = Number(RegExp["$1"])),
            (_0x2d409d = Number(RegExp["$2"])));
      }
      if (_0x5357f6.match(/none/i))
        (_0x381894 += _0x4a0c02), (_0x2d409d += _0xe355a3);
      else {
        if (_0x5357f6.match(/horz/i) && _0x5357f6.match(/vert/i))
          (_0x381894 += actionSequenceTarget.isActor()
            ? -_0x4a0c02
            : _0x4a0c02),
            (_0x2d409d += actionSequenceTarget.isActor()
              ? -_0xe355a3
              : _0xe355a3);
        else {
          if (_0x5357f6.match(/horz/i))
            (_0x381894 += actionSequenceTarget.isActor()
              ? -_0x4a0c02
              : _0x4a0c02),
              (_0x2d409d += _0xe355a3);
          else {
            if (_0x5357f6.match(/vert/i)) {
              (_0x381894 += _0x4a0c02),
                (_0x2d409d += actionSequenceTarget.isActor()
                  ? -_0xe355a3
                  : _0xe355a3);
            }
          }
        }
      }
      actionSequenceTarget.moveBattlerToPoint(
        _0x381894,
        _0x2d409d,
        _0x4394b0,
        _0xf2611b,
        _0x4d43de,
        -1
      ),
        actionSequenceTarget.requestMotion(_0x2caea9);
    }
    if (_0x14f779) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_MoveToTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!$gameSystem.isSideView()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets1 = VisuMZ.CreateActionSequenceTargets(
      args.Targets1
    );
    const actionSequenceTargets2 = VisuMZ.CreateActionSequenceTargets(
      args.Targets2
    );
    const targetLocation = args.TargetLocation;
    let distance = args.MeleeDistance;
    const offsetAdjust = args.OffsetAdjust;
    const offsetX = args.OffsetX;
    const offsetY = args.OffsetY;
    const duration = args.Duration;
    const faceDirection = args.FaceDirection;
    const easingType = args.EasingType;
    const motionType = args.MotionType;
    const waitForMovement = args.WaitForMovement;
    const _0x298039 = Math.min(
      ...actionSequenceTargets2.map(
        (actionSequenceTarget) =>
          actionSequenceTarget.battler()._baseX -
          actionSequenceTarget.battler().mainSpriteWidth() / 2
      )
    );
    const _0x4b076f = Math.max(
      ...actionSequenceTargets2.map(
        (actionSequenceTarget) =>
          actionSequenceTarget.battler()._baseX +
          actionSequenceTarget.battler().mainSpriteWidth() / 2
      )
    );
    const _0x871921 = Math.min(
      ...actionSequenceTargets2.map(
        (actionSequenceTarget) =>
          actionSequenceTarget.battler()._baseY -
          actionSequenceTarget.battler().mainSpriteHeight()
      )
    );
    const _0x1b3950 = Math.max(
      ...actionSequenceTargets2.map(
        (actionSequenceTarget) => actionSequenceTarget.battler()._baseY
      )
    );
    const _0x12f3f7 = actionSequenceTargets2.filter((actionSequenceTarget) =>
      actionSequenceTarget.isActor()
    )["length"];
    const _0x46fc9e = actionSequenceTargets2.filter((actionSequenceTarget) =>
      actionSequenceTarget.isEnemy()
    )["length"];
    let _0x4734f9 = 0;
    let _0x276255 = 0;
    if (targetLocation.match(/front/i))
      _0x4734f9 = _0x12f3f7 >= _0x46fc9e ? _0x298039 : _0x4b076f;
    else {
      if (targetLocation.match(/middle/i))
        (_0x4734f9 = (_0x298039 + _0x4b076f) / 2), (distance = -1);
      else
        targetLocation.match(/back/i) &&
          (_0x4734f9 = _0x12f3f7 >= _0x46fc9e ? _0x4b076f : _0x298039);
    }
    if (targetLocation.match(/head/i)) _0x276255 = _0x871921;
    else {
      if (targetLocation.match(/center/i))
        _0x276255 = (_0x871921 + _0x1b3950) / 2;
      else {
        if (targetLocation.match(/base/i)) {
          _0x276255 = _0x1b3950;
        }
      }
    }
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets1) {
      if (!actionSequenceTarget) continue;
      let _0xab3b3c = _0x4734f9;
      let _0x113a93 = _0x276255;
      if (offsetAdjust.match(/none/i)) {
        _0xab3b3c += offsetX;
        _0x113a93 += offsetY;
      } else {
        if (offsetAdjust.match(/horz/i) && offsetAdjust.match(/vert/i)) {
          _0xab3b3c += actionSequenceTarget.isActor() ? -offsetX : offsetX;
          _0x113a93 += actionSequenceTarget.isActor() ? -offsetY : offsetY;
        } else {
          if (offsetAdjust.match(/horz/i)) {
            _0xab3b3c += actionSequenceTarget.isActor() ? -offsetX : offsetX;
            _0x113a93 += offsetY;
          } else if (offsetAdjust.match(/vert/i)) {
            _0xab3b3c += offsetX;
            _0x113a93 += actionSequenceTarget.isActor() ? -offsetY : offsetY;
          }
        }
      }
      actionSequenceTarget.moveBattlerToPoint(
        _0xab3b3c,
        _0x113a93,
        duration,
        faceDirection,
        easingType,
        distance
      ),
        actionSequenceTarget.requestMotion(motionType);
    }
    if (waitForMovement) interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_Opacity",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x181b25 = args.Opacity;
    const _0x3d38c6 = args.Duration;
    const _0x367e08 = args.EasingType;
    const _0x3cdf93 = args.WaitForOpacity;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.changeBattlerOpacity(
        _0x181b25,
        _0x3d38c6,
        _0x367e08
      );
    }
    if (_0x3cdf93) interpreter.setWaitMode("battleOpacity");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_Scale",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x1888be = args.ScaleX;
    const _0x324e22 = args.ScaleY;
    const _0x198417 = args.Duration;
    const _0x355449 = args.EasingType;
    const _0x2fae7b = args.WaitForScale;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.growBattler(
        _0x1888be,
        _0x324e22,
        _0x198417,
        _0x355449
      );
    }
    if (_0x2fae7b) interpreter.setWaitMode("battleGrow");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_Skew",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x6d2a58 = args.SkewX;
    const _0xe22b74 = args.SkewY;
    const _0x544fbc = args.Duration;
    const _0x1f4ba8 = args.EasingType;
    const _0x544db9 = args.WaitForSkew;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.skewBattler(
        _0x6d2a58,
        _0xe22b74,
        _0x544fbc,
        _0x1f4ba8
      );
    }
    if (_0x544db9) interpreter.setWaitMode("battleSpriteSkew");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_Spin",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    const _0x586572 = args.Angle;
    const _0x3883fe = args.Duration;
    const _0x351a93 = args.EasingType;
    const _0x16b8f2 = args.RevertAngle;
    const _0x233ca9 = args.WaitForSpin;
    if (!interpreter) return;
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.spinBattler(
        _0x586572,
        _0x3883fe,
        _0x351a93,
        _0x16b8f2
      );
    }
    if (_0x233ca9) interpreter.setWaitMode("battleSpin");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForFloat",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleFloat");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForJump",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleJump");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForMovement",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleMove");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForOpacity",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleOpacity");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForScale",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleGrow");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForSkew",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleSpriteSkew");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Movement_WaitForSpin",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleSpin");
  }
);

VisuMZ.BattleCore.CheckActSeqProjectileVersion = function () {
  if (!Imported.VisuMZ_3_ActSeqProjectiles) return;
  if (VisuMZ.ActSeqProjectiles.version < 1.08) {
    let _0x4ec188 = "";
    (_0x4ec188 += "VisuMZ_3_ActSeqProjectiles needs to be updated "),
      (_0x4ec188 += "in order for VisuMZ_1_BattleCore to work."),
      alert(_0x4ec188),
      SceneManager.exit();
  }
};

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Projectile_Animation",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqProjectiles) return;
    VisuMZ.ConvertParams(args, args),
      VisuMZ.BattleCore.CheckActSeqProjectileVersion();
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x51e84c = args.WaitForProjectile;
    if (!interpreter) return;
    const _0x3f9b91 = BattleManager._spriteset;
    if (!_0x3f9b91) return;
    _0x3f9b91.createActionSequenceProjectile(args);
    if (_0x51e84c) interpreter.setWaitMode("battleProjectiles");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Projectile_Icon",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqProjectiles) return;
    VisuMZ.ConvertParams(args, args),
      VisuMZ.BattleCore.CheckActSeqProjectileVersion();
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x1f55df = args.WaitForProjectile;
    if (!interpreter) return;
    const _0x2c9096 = BattleManager._spriteset;
    if (!_0x2c9096) return;
    _0x2c9096.createActionSequenceProjectile(args);
    if (_0x1f55df) interpreter.setWaitMode("battleProjectiles");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Projectile_Picture",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqProjectiles) return;
    VisuMZ.ConvertParams(args, args),
      VisuMZ.BattleCore.CheckActSeqProjectileVersion();
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x2f94b2 = args.WaitForProjectile;
    if (!interpreter) return;
    const _0x584d6e = BattleManager._spriteset;
    if (!_0x584d6e) return;
    _0x584d6e.createActionSequenceProjectile(args);
    if (_0x2f94b2) interpreter.setWaitMode("battleProjectiles");
  }
);

PluginManager.registerCommand(pluginData.name, "ActSeq_ChangeSkew", (args) => {
  if (!SceneManager.isSceneBattle()) return;
  if (!Imported.VisuMZ_3_ActSeqCamera) return;
  VisuMZ.ConvertParams(args, args);
  const interpreter = $gameTemp.getLastPluginCommandInterpreter();
  const _0x39b7bb = args.WaitForSkew;
  if (!interpreter) return;
  $gameScreen.setBattleSkew(
    args.SkewX,
    args.SkewY,
    args.Duration,
    args.EasingType
  );
  if (_0x39b7bb) interpreter.setWaitMode("battleSkew");
});

PluginManager.registerCommand(pluginData.name, "ActSeq_Skew_Reset", (args) => {
  if (!SceneManager.isSceneBattle()) return;
  if (!Imported.VisuMZ_3_ActSeqCamera) return;
  VisuMZ.ConvertParams(args, args);
  const interpreter = $gameTemp.getLastPluginCommandInterpreter();
  const _0x5003c1 = args.WaitForSkew;
  if (!interpreter) return;
  $gameScreen.setBattleSkew(0, 0, args.Duration, args.EasingType);
  if (_0x5003c1) interpreter.setWaitMode("battleSkew");
});

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Skew_WaitForSkew",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleSkew");
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Target_CurrentIndex",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const _0x3252a5 = args.Index;
    const _0x3345de = args.JumpToLabel;
    if (!interpreter) return;
    (BattleManager._targetIndex = _0x3252a5),
      (BattleManager._target = BattleManager._allTargets
        ? BattleManager._allTargets[BattleManager._targetIndex] || null
        : null),
      BattleManager._target &&
        _0x3345de.toUpperCase().trim() !== "UNTITLED" &&
        interpreter.command119([_0x3345de]);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Target_NextTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const jumpToLabel = args.JumpToLabel;
    if (!interpreter) return;
    BattleManager._targetIndex++,
      (BattleManager._target =
        BattleManager._allTargets[BattleManager._targetIndex] || null),
      BattleManager._target &&
        jumpToLabel.toUpperCase().trim() !== "UNTITLED" &&
        interpreter.command119([jumpToLabel]);
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Target_PrevTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const jumpToLabel = args.JumpToLabel;
    if (!interpreter) return;
    BattleManager._targetIndex--,
      (BattleManager._target =
        BattleManager._allTargets[BattleManager._targetIndex] || null);
    if (
      BattleManager._target &&
      jumpToLabel.toUpperCase().trim() !== "UNTITLED"
    ) {
      interpreter.command119([jumpToLabel]);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Target_RandTarget",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    const forceRandom = args.ForceRandom;
    const jumpToLabel = args.JumpToLabel;
    if (!interpreter) return;
    const targetIndex = BattleManager._targetIndex;
    for (;;) {
      BattleManager._targetIndex = Math.randomInt(
        BattleManager._allTargets.length
      );
      if (!forceRandom) break;
      if (BattleManager._targetIndex !== targetIndex) break;
      if (BattleManager._allTargets.length <= 1) {
        BattleManager._targetIndex = 0;
        break;
      }
    }
    BattleManager._target =
      BattleManager._allTargets[BattleManager._targetIndex] || null;
    if (
      BattleManager._target &&
      jumpToLabel.toUpperCase().trim() !== "UNTITLED"
    ) {
      interpreter.command119([jumpToLabel]);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleVoice_PlayCommonLine",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_BattleVoices) return;
    if (!ConfigManager.battleVoices) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    let voiceLine = args.VoiceLine || "";
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.playBattleVoice(voiceLine);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_BattleVoice_PlaySpecialLine",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_BattleVoices) return;
    if (!ConfigManager.battleVoices) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    let battleVoice = (args.VoiceLineType || "") + (args.Letter || "");
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      actionSequenceTarget.playBattleVoice(battleVoice);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Weapon_ClearActiveWeapon",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isActor()) continue;
      actionSequenceTarget.clearActiveWeaponSlot();
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Weapon_NextActiveWeapon",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    let hasWeapon = false;
    const jumpToLabel = args.JumpToLabel;
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isActor()) continue;
      actionSequenceTarget.nextActiveWeaponSlot();
      if (actionSequenceTarget.weapons()["length"] > 0) {
        hasWeapon = true;
      } else {
        actionSequenceTarget.clearActiveWeaponSlot();
      }
    }
    if (hasWeapon && jumpToLabel.toUpperCase().trim() !== "UNTITLED") {
      interpreter.command119([jumpToLabel]);
    }
  }
);

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Weapon_SetActiveWeapon",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    VisuMZ.ConvertParams(args, args);
    let slotId = args.SlotID;
    slotId--;
    slotId = Math.max(slotId, 0);
    const actionSequenceTargets = VisuMZ.CreateActionSequenceTargets(
      args.Targets
    );
    for (const actionSequenceTarget of actionSequenceTargets) {
      if (!actionSequenceTarget) continue;
      if (!actionSequenceTarget.isActor()) continue;
      actionSequenceTarget.setActiveWeaponSlot(slotId);
    }
  }
);

PluginManager.registerCommand(pluginData.name, "ActSeq_Zoom_Scale", (args) => {
  if (!SceneManager.isSceneBattle()) return;
  if (!Imported.VisuMZ_3_ActSeqCamera) return;
  VisuMZ.ConvertParams(args, args);
  const interpreter = $gameTemp.getLastPluginCommandInterpreter();
  const waitForZoom = args.WaitForZoom;
  if (!interpreter) return;
  $gameScreen.setBattleZoom(args.Scale, args.Duration, args.EasingType);
  if (waitForZoom) interpreter.setWaitMode("battleZoom");
});

PluginManager.registerCommand(pluginData.name, "ActSeq_Zoom_Reset", (args) => {
  if (!SceneManager.isSceneBattle()) return;
  if (!Imported.VisuMZ_3_ActSeqCamera) return;
  VisuMZ.ConvertParams(args, args);
  const interpreter = $gameTemp.getLastPluginCommandInterpreter();
  const waitForZoom = args.WaitForZoom;
  if (!interpreter) return;
  $gameScreen.setBattleZoom(1, args.Duration, args.EasingType);
  if (waitForZoom) interpreter.setWaitMode("battleZoom");
});

PluginManager.registerCommand(
  pluginData.name,
  "ActSeq_Zoom_WaitForZoom",
  (args) => {
    if (!SceneManager.isSceneBattle()) return;
    if (!Imported.VisuMZ_3_ActSeqCamera) return;
    const interpreter = $gameTemp.getLastPluginCommandInterpreter();
    if (!interpreter) return;
    interpreter.setWaitMode("battleZoom");
  }
);

VisuMZ.BattleCore.Scene_Boot_onDatabaseLoaded =
  Scene_Boot.prototype.onDatabaseLoaded;

Scene_Boot.prototype.onDatabaseLoaded = function () {
  this.process_VisuMZ_BattleCore_Failsafes(),
    this.process_VisuMZ_BattleCore_PluginParams(),
    this.process_VisuMZ_BattleCore_DamageStyles(),
    this.process_VisuMZ_BattleCore_CreateRegExp(),
    VisuMZ.BattleCore.Scene_Boot_onDatabaseLoaded.call(this),
    this.process_VisuMZ_BattleCore_Notetags(),
    this.process_VisuMZ_BattleCore_BaseTroops(),
    this.process_VisuMZ_BattleCore_PreBattleCommonEvent(),
    this.process_VisuMZ_BattleCore_CommonEventKeys();
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_Notetags = function () {
  if (VisuMZ.ParseAllNotetags) return;
  this.process_VisuMZ_BattleCore_Action_Notetags(),
    this.process_VisuMZ_BattleCore_TraitObject_Notetags(),
    this.process_VisuMZ_BattleCore_jsFunctions();
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_Failsafes = function () {
  const _0xf3e1ce = $dataSystem.weaponTypes.length;
  for (let _0x37d28e = 0; _0x37d28e < _0xf3e1ce; _0x37d28e++) {
    const _0x3dc1d3 = $dataSystem.attackMotions[_0x37d28e];
    if (_0x3dc1d3) continue;
    $dataSystem.attackMotions[_0x37d28e] = {
      type: 1,
      weaponImageId: 1,
    };
  }
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_PluginParams = function () {
  const _0x3ca2b3 = VisuMZ.BattleCore.Settings;
  _0x3ca2b3.Damage.PopupPosition === undefined &&
    (_0x3ca2b3.Damage.PopupPosition = "base");
  if (_0x3ca2b3.Actor.SmoothImage === undefined) {
    _0x3ca2b3.Actor.SmoothImage = false;
  }
  _0x3ca2b3.Enemy.SmoothImage === undefined &&
    (_0x3ca2b3.Enemy.SmoothImage = true),
    _0x3ca2b3.Actor.PrioritySortActive === undefined &&
      (_0x3ca2b3.Actor.PrioritySortActive = false),
    _0x3ca2b3.Actor.PrioritySortActors === undefined &&
      (_0x3ca2b3.Actor.PrioritySortActors = true);
};

VisuMZ.DamageStyles = {};

Scene_Boot.prototype.process_VisuMZ_BattleCore_DamageStyles = function () {
  for (const _0x2a709d of VisuMZ.BattleCore.Settings.Damage[
    "DamageStyleList"
  ]) {
    if (!_0x2a709d) continue;
    const _0x29c675 = _0x2a709d.Name.toUpperCase().trim();
    VisuMZ.DamageStyles[_0x29c675] = _0x2a709d;
  }
};

VisuMZ.BattleCore.RegExp = {};

Scene_Boot.prototype.process_VisuMZ_BattleCore_CreateRegExp = function () {
  const _0x49f164 = VisuMZ.BattleCore.RegExp;
  const _0x265087 = "<%1>s*([sS]*)s*</%1>";
  const _0x5de3d6 = [
    ["Pre", "PRE-"],
    ["Post", "POST-"],
  ];
  const _0x55fe2f = [
    ["%1Apply%2JS", "JS %1APPLY %2"],
    ["%1Damage%2JS", "JS %1DAMAGE %2"],
  ];
  const _0xeb4822 = [
    ["", ""],
    ["AsUser", "AS USER"],
    ["AsTarget", "AS TARGET"],
  ];
  for (const _0xe33385 of _0x55fe2f) {
    for (const _0x153775 of _0xeb4822) {
      for (const _0x509ffb of _0x5de3d6) {
        const _0x1353d6 = _0xe33385[0].format(_0x509ffb[0], _0x153775[0]);
        const _0xbec8 = _0xe33385[1]
          .format(_0x509ffb[1], _0x153775[1])
          ["trim"]();
        const _0x283b0c = new RegExp(_0x265087.format(_0xbec8), "i");
        _0x49f164[_0x1353d6] = _0x283b0c;
      }
    }
  }
  const _0x451309 = [
    ["%1StartActionJS", "JS %1START ACTION"],
    ["%1EndActionJS", "JS %1END ACTION"],
  ];
  for (const _0x7a6822 of _0x451309) {
    for (const _0x28b388 of _0x5de3d6) {
      const _0x1d204d = _0x7a6822[0].format(_0x28b388[0]);
      const _0x3f185a = _0x7a6822[1].format(_0x28b388[1]);
      const _0x100777 = new RegExp(_0x265087.format(_0x3f185a), "i");
      _0x49f164[_0x1d204d] = _0x100777;
    }
  }
  const _0xe79ff3 = [
    ["%1StartBattleJS", "JS %1START BATTLE"],
    ["%1EndBattleJS", "JS %1END BATTLE"],
    ["BattleVictoryJS", "JS BATTLE VICTORY"],
    ["BattleDefeatJS", "JS BATTLE DEFEAT"],
    ["EscapeSuccessJS", "JS ESCAPE SUCCESS"],
    ["EscapeFailureJS", "JS ESCAPE FAILURE"],
    ["%1StartTurnJS", "JS %1START TURN"],
    ["%1EndTurnJS", "JS %1END TURN"],
    ["%1RegenerateJS", "JS %1REGENERATE"],
  ];
  for (const _0x10ac2d of _0xe79ff3) {
    for (const _0x210ae2 of _0x5de3d6) {
      const _0xc51e81 = _0x10ac2d[0].format(_0x210ae2[0]);
      const _0x49beec = _0x10ac2d[1].format(_0x210ae2[1]);
      const _0x3a53c5 = new RegExp(_0x265087.format(_0x49beec), "i");
      _0x49f164[_0xc51e81] = _0x3a53c5;
    }
  }
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_Action_Notetags = function () {
  const _0x5b6f99 = $dataSkills.concat($dataItems);
  for (const _0x4ee15c of _0x5b6f99) {
    if (!_0x4ee15c) continue;
    VisuMZ.BattleCore.Parse_Notetags_Action(_0x4ee15c);
  }
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_TraitObject_Notetags =
  function () {
    const _0x337d24 = $dataActors.concat(
      $dataClasses,
      $dataWeapons,
      $dataArmors,
      $dataEnemies,
      $dataStates
    );
    for (const _0x78f6ad of _0x337d24) {
      if (!_0x78f6ad) continue;
      VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x78f6ad);
    }
  };

Scene_Boot.prototype.process_VisuMZ_BattleCore_BaseTroops = function () {
  const _0x4a997d = VisuMZ.BattleCore.Settings.Mechanics["BaseTroopIDs"];
  const _0x3c4009 = [];
  for (const _0xc56dd2 of _0x4a997d) {
    const _0x1f3fef = $dataTroops[_0xc56dd2];
    if (_0x1f3fef) _0x3c4009.push(JsonEx.makeDeepCopy(_0x1f3fef));
  }
  for (const _0x5be263 of $dataTroops) {
    if (!_0x5be263) continue;
    for (const _0x2bda6a of _0x3c4009) {
      if (_0x2bda6a.id === _0x5be263.id) continue;
      _0x5be263.pages = _0x5be263.pages.concat(_0x2bda6a.pages);
    }
  }
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_PreBattleCommonEvent =
  function () {
    const _0x19bc48 = VisuMZ.BattleCore.Settings.Mechanics;
    if (
      _0x19bc48.BattleStartEvent > 0 &&
      $dataCommonEvents[_0x19bc48.BattleStartEvent]
    ) {
      const _0x426631 = $dataCommonEvents[_0x19bc48.BattleStartEvent];
      const _0x2ced96 = _0x426631.list.length - 2;
      const _0x662213 = _0x426631.list[_0x2ced96];
      if (_0x662213 && _0x662213.code !== 230) {
        const _0x1ee26f = { code: 230, indent: 0, parameters: [1] };
        const _0x28fd34 = _0x426631.list.pop();
        _0x426631.list.unshift(_0x1ee26f), _0x426631.list.unshift(_0x28fd34);
      }
    }
  };

Scene_Boot.prototype.process_VisuMZ_BattleCore_CommonEventKeys = function () {
  VisuMZ.BattleCore.CreateCommonEventKeys(),
    VisuMZ.BattleCore.BindCommonEventKeysForGroup($dataSkills),
    VisuMZ.BattleCore.BindCommonEventKeysForGroup($dataItems);
};

VisuMZ.BattleCore.CreateCommonEventKeys = function () {
  VisuMZ.BattleCore._commonEventKey = {};
  for (const _0x5e2cfa of $dataCommonEvents) {
    if (!_0x5e2cfa) continue;
    if (_0x5e2cfa.name.match(/\[(.*)\]/i)) {
      let _0x2247f5 = String(RegExp["$1"])
        ["replace"](/,/g, "")
        ["toUpperCase"]()
        .trim();
      VisuMZ.BattleCore._commonEventKey[_0x2247f5] = _0x5e2cfa.id;
    }
  }
};

VisuMZ.BattleCore.BindCommonEventKeysForGroup = function (_0x94777e) {
  for (const _0x1f2570 of _0x94777e) {
    if (!_0x1f2570) continue;
    VisuMZ.BattleCore.BindCommonEventKeysForObj(_0x1f2570);
  }
};

VisuMZ.BattleCore.BindCommonEventKeysForObj = function (_0x2ae2bb) {
  if (!_0x2ae2bb) return;
  if (!_0x2ae2bb.effects) return;
  VisuMZ.BattleCore._commonEventKey = VisuMZ.BattleCore._commonEventKey || {};
  const _0x514554 = /<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi;
  const _0x1ef32f =
    /<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;
  let _0x12e39e = [];
  const _0x5e4bfd = _0x2ae2bb.note.match(_0x514554);
  if (_0x5e4bfd) {
    for (const _0x500442 of _0x5e4bfd) {
      _0x500442.match(_0x514554);
      const _0x2ead59 = String(RegExp["$1"])
        ["split"](",")
        ["map"]((_0x16ea9b) => String(_0x16ea9b)["toUpperCase"]().trim());
      _0x12e39e = _0x12e39e.concat(_0x2ead59);
    }
    !_0x2ae2bb.note.match(/<CUSTOM ACTION SEQUENCE>/i) &&
      (_0x2ae2bb.note += "<CUSTOM ACTION SEQUENCE>");
  }
  if (_0x2ae2bb.note.match(_0x1ef32f)) {
    const _0x130ed5 = String(RegExp["$1"])
      ["split"](/[\r\n]+/)
      ["map"]((_0x5dd206) => String(_0x5dd206)["toUpperCase"]().trim());
    _0x12e39e = _0x12e39e.concat(_0x130ed5);
    !_0x2ae2bb.note.match(/<CUSTOM ACTION SEQUENCE>/i) &&
      (_0x2ae2bb.note += "<CUSTOM ACTION SEQUENCE>");
  }
  for (const _0x5cde05 of _0x12e39e) {
    if (VisuMZ.BattleCore._commonEventKey[_0x5cde05]) {
      const _0xfd354c = VisuMZ.BattleCore._commonEventKey[_0x5cde05];
      const _0x1c23c2 = {
        code: 44,
        dataId: _0xfd354c,
        value1: 1,
        value2: 0,
      };
      _0x2ae2bb.effects.push(_0x1c23c2);
    }
  }
};

Scene_Boot.prototype.process_VisuMZ_BattleCore_jsFunctions = function () {
  const _0x590706 = $dataSkills.concat($dataItems);
  for (const _0x2560fe of _0x590706) {
    if (!_0x2560fe) continue;
    VisuMZ.BattleCore.Parse_Notetags_Targets(_0x2560fe);
  }
};

VisuMZ.BattleCore.ParseActorNotetags = VisuMZ.ParseActorNotetags;

VisuMZ.ParseActorNotetags = function (_0x46638a) {
  if (VisuMZ.BattleCore.ParseActorNotetags) {
    if ("FYwKr" === "dXxIP") return false;
    else VisuMZ.BattleCore.ParseActorNotetags.call(this, _0x46638a);
  }
  VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x46638a);
};

VisuMZ.BattleCore.ParseClassNotetags = VisuMZ.ParseClassNotetags;

VisuMZ.ParseClassNotetags = function (_0x26521b) {
  if (VisuMZ.BattleCore.ParseClassNotetags) {
    if ("eTHXc" !== "tjkfv")
      VisuMZ.BattleCore.ParseClassNotetags.call(this, _0x26521b);
    else {
      if (this.constructor !== _0x59431a) return false;
      if (!_0x2a4782.isSceneBattle()) return false;
      return _0x8175f3.BattleCore.Settings.BattleLayout[
        "ShowPortraitsBorderStyle"
      ];
    }
  }
  VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x26521b);
};

VisuMZ.BattleCore.ParseSkillNotetags = VisuMZ.ParseSkillNotetags;

VisuMZ.ParseSkillNotetags = function (_0x338cb5) {
  VisuMZ.BattleCore.ParseSkillNotetags &&
    VisuMZ.BattleCore.ParseSkillNotetags.call(this, _0x338cb5),
    VisuMZ.BattleCore.Parse_Notetags_Action(_0x338cb5),
    VisuMZ.BattleCore.Parse_Notetags_Targets(_0x338cb5);
};

VisuMZ.BattleCore.ParseItemNotetags = VisuMZ.ParseItemNotetags;

VisuMZ.ParseItemNotetags = function (_0x1384e6) {
  if (VisuMZ.BattleCore.ParseItemNotetags) {
    if ("DtXLN" === "DtXLN")
      VisuMZ.BattleCore.ParseItemNotetags.call(this, _0x1384e6);
    else {
      let _0x163451 = _0x56b666.createTroopNote(_0x57182e.id);
      this.parseForcedGameTroopSettingsBattleCore(_0x163451);
    }
  }
  VisuMZ.BattleCore.Parse_Notetags_Action(_0x1384e6),
    VisuMZ.BattleCore.Parse_Notetags_Targets(_0x1384e6);
};

VisuMZ.BattleCore.ParseWeaponNotetags = VisuMZ.ParseWeaponNotetags;

VisuMZ.ParseWeaponNotetags = function (_0x594b52) {
  VisuMZ.BattleCore.ParseWeaponNotetags &&
    VisuMZ.BattleCore.ParseWeaponNotetags.call(this, _0x594b52),
    VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x594b52);
};

VisuMZ.BattleCore.ParseArmorNotetags = VisuMZ.ParseArmorNotetags;

VisuMZ.ParseArmorNotetags = function (_0x234e2d) {
  VisuMZ.BattleCore.ParseArmorNotetags &&
    ("rhBOl" !== "HvJBD"
      ? VisuMZ.BattleCore.ParseArmorNotetags.call(this, _0x234e2d)
      : (_0x4a2f26.bitmap = _0x265c82._emptyBitmap)),
    VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x234e2d);
};

VisuMZ.BattleCore.ParseEnemyNotetags = VisuMZ.ParseEnemyNotetags;

VisuMZ.ParseEnemyNotetags = function (_0x2384b1) {
  VisuMZ.BattleCore.ParseEnemyNotetags &&
    VisuMZ.BattleCore.ParseEnemyNotetags.call(this, _0x2384b1),
    VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x2384b1);
};

VisuMZ.BattleCore.ParseStateNotetags = VisuMZ.ParseStateNotetags;

VisuMZ.ParseStateNotetags = function (_0x567a91) {
  VisuMZ.BattleCore.ParseStateNotetags &&
    VisuMZ.BattleCore.ParseStateNotetags.call(this, _0x567a91),
    VisuMZ.BattleCore.Parse_Notetags_TraitObjects(_0x567a91);
};

VisuMZ.BattleCore.Parse_Notetags_Action = function (_0x22fdfe) {
  const _0x58a236 = [
    "PreApplyJS",
    "PostApplyJS",
    "PreDamageJS",
    "PostDamageJS",
    "PreStartActionJS",
    "PostStartActionJS",
    "PreEndActionJS",
    "PostEndActionJS",
  ];
  for (const _0x16c00a of _0x58a236) {
    VisuMZ.BattleCore.createJS(_0x22fdfe, _0x16c00a);
  }
  const _0x563a0a = _0x22fdfe.note;
  _0x563a0a.match(/<ALWAYS CRITICAL/i) && (_0x22fdfe.damage.critical = true),
    _0x563a0a.match(/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i) &&
      (_0x22fdfe.repeats = Math.max(1, Number(RegExp["$1"]))),
    _0x563a0a.match(/<TARGET:[ ](.*)>/i) &&
      (_0x22fdfe.scope = String(RegExp["$1"])["toUpperCase"]().trim());
};

VisuMZ.BattleCore.Parse_Notetags_TraitObjects = function (_0xd36eea) {
  const _0x2bd616 = [
    "PreApplyAsUserJS",
    "PostApplyAsUserJS",
    "PreDamageAsUserJS",
    "PostDamageAsUserJS",
    "PreApplyAsTargetJS",
    "PostApplyAsTargetJS",
    "PreDamageAsTargetJS",
    "PostDamageAsTargetJS",
    "PreStartActionJS",
    "PostStartActionJS",
    "PreEndActionJS",
    "PostEndActionJS",
    "PreStartBattleJS",
    "PostStartBattleJS",
    "PreEndBattleJS",
    "PostEndBattleJS",
    "BattleVictoryJS",
    "BattleDefeatJS",
    "EscapeSuccessJS",
    "EscapeFailureJS",
    "PreStartTurnJS",
    "PostStartTurnJS",
    "PreEndTurnJS",
    "PostEndTurnJS",
    "PreRegenerateJS",
    "PostRegenerateJS",
  ];
  for (const _0x495f38 of _0x2bd616) {
    if ("McfCq" === "bEUCK")
      return this.hasSvBattler()
        ? _0x48a515.BattleCore.Settings.Actor["SmoothImage"]
        : _0x1acd75.BattleCore.Settings.Enemy["SmoothImage"];
    else VisuMZ.BattleCore.createJS(_0xd36eea, _0x495f38);
  }
};

VisuMZ.BattleCore.Parse_Notetags_Targets = function (_0x49bbaf) {
  const _0x25cbaf = _0x49bbaf.note;
  if (_0x25cbaf.match(/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)) {
    const _0x61095e = _0x26a88e._scene._actorWindow;
    _0x61095e.show();
    _0x61095e.setEnemyWindowMode(true);
    _0x61095e.refresh();
    _0x61095e.deselect();
    if (SceneManager.isSceneBattle()) {
      const _0x208331 = SceneManager._scene.battleLayoutStyle();
      const _0x233fad = ["xp", "portrait", "border"];
      if (_0x233fad.includes(_0x208331)) {
        const _0x4c54e = _0x51a0e1._scene._statusWindow;
        _0x4c54e.scale.y = 0;
      }
    }
  }
  if (
    _0x25cbaf.match(
      /<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i
    )
  ) {
    if ("YPvMm" !== "KjmqK") {
      const _0x7d4d5f = String(RegExp["$1"]);
      const _0x2aaa76 = VisuMZ.BattleCore.createKeyJS(
        _0x49bbaf,
        "CommandVisible"
      );
      VisuMZ.BattleCore.createCommandVisibleJS(_0x7d4d5f, _0x2aaa76);
    } else
      (this._action._reflectionTarget = _0x12742c),
        this._logWindow.displayReflection(_0x147e5e),
        this._logWindow.displayReflectionPlayBack(_0x2d06ab, this._action),
        this._action.apply(_0x34c2fd),
        this._logWindow.displayActionResults(_0xa11b6d, _0x992295);
  }
};

VisuMZ.BattleCore.JS = {};

VisuMZ.BattleCore.createJS = function (_0x4af4e1, _0xa483d0) {
  const _0x335ab2 = _0x4af4e1.note;
  if (_0x335ab2.match(VisuMZ.BattleCore.RegExp[_0xa483d0])) {
    const _0x2d9a8d = RegExp["$1"];
    const _0x225f0b =
      "\n            // Declare Arguments\n            const user = arguments[0];\n            const target = arguments[1];\n            const obj = arguments[2];\n            let value = arguments[3] || 0;\n            let originalValue = value;\n\n            // Declare Constants\n            const action = (this.constructor === Game_Action) ? this : user.currentAction();\n            const a = user;\n            const b = target;\n            const attacker = user;\n            const defender = target;\n            const healer = user;\n            const receiver = target;\n            const actor = obj;\n            const currentClass = obj;\n            const skill = (this.constructor === Game_Action) ? this.item() : obj;\n            const item = (this.constructor === Game_Action) ? this.item() : obj;\n            const weapon = obj;\n            const armor = obj;\n            const enemy = obj;\n            const state = obj;\n\n            // Create Compatibility Variables\n            let origin = user;\n            if (Imported.VisuMZ_1_SkillsStatesCore && $dataStates.includes(obj)) {\n                origin = target.getStateOrigin(obj.id);\n            }\n\n            // Process Code\n            try {\n                %1\n            } catch (e) {\n                if ($gameTemp.isPlaytest()) console.log(e);\n            }\n\n            // NaN Check\n            if (isNaN(value)){\n                if ($gameTemp.isPlaytest()) {\n                    console.log('NaN value created by %2'.format('',obj.name));\n                    console.log('Restoring value to %2'.format('',originalValue));\n                }\n                value = originalValue;\n            }\n\n            // Return Value\n            return value;\n        "[
        "format"
      ](_0x2d9a8d);
    const _0x204b4f = VisuMZ.BattleCore.createKeyJS(_0x4af4e1, _0xa483d0);
    VisuMZ.BattleCore.JS[_0x204b4f] = new Function(_0x225f0b);
  }
};

VisuMZ.BattleCore.createKeyJS = function (_0x2199e9, _0x258f92) {
  if (VisuMZ.createKeyJS) return VisuMZ.createKeyJS(_0x2199e9, _0x258f92);
  let _0x32f46b = "";
  if ($dataActors.includes(_0x2199e9))
    _0x32f46b = "Actor-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataClasses.includes(_0x2199e9))
    _0x32f46b = "Class-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataSkills.includes(_0x2199e9))
    _0x32f46b = "Skill-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataItems.includes(_0x2199e9))
    _0x32f46b = "Item-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataWeapons.includes(_0x2199e9))
    _0x32f46b = "Weapon-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataArmors.includes(_0x2199e9))
    _0x32f46b = "Armor-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataEnemies.includes(_0x2199e9))
    _0x32f46b = "Enemy-%1-%2".format(_0x2199e9.id, _0x258f92);
  if ($dataStates.includes(_0x2199e9))
    _0x32f46b = "State-%1-%2".format(_0x2199e9.id, _0x258f92);
  return _0x32f46b;
};

VisuMZ.BattleCore.createTargetsJS = function (_0x27a26e, _0x56c833) {
  const _0x495b98 =
    "\n        // Declare Arguments\n        const user = arguments[0];\n        const a = user;\n        const b = user;\n        let targets = arguments[1];\n\n        // Process Code\n        try {\n            %1\n        } catch (e) {\n            if ($gameTemp.isPlaytest()) console.log(e);\n        }\n\n        // Return Value\n        return targets || [];\n    "[
      "format"
    ](_0x27a26e);
  VisuMZ.BattleCore.JS[_0x56c833] = new Function(_0x495b98);
};

VisuMZ.BattleCore.createCommandVisibleJS = function (_0x132fe0, _0x340692) {
  const _0x4b6c1a =
    "\n        // Declare Arguments\n        const user = arguments[0];\n        const skill = arguments[1];\n        const a = user;\n        const b = user;\n        let visible = true;\n\n        // Process Code\n        try {\n            %1\n        } catch (e) {\n            if ($gameTemp.isPlaytest()) console.log(e);\n        }\n\n        // Return Value\n        return visible;\n    "[
      "format"
    ](_0x132fe0);
  VisuMZ.BattleCore.JS[_0x340692] = new Function(_0x4b6c1a);
};

TextManager.autoBattle =
  VisuMZ.BattleCore.Settings.PartyCmd["CmdTextAutoBattle"];

TextManager.autoBattleStart =
  VisuMZ.BattleCore.Settings.AutoBattle["StartName"];

TextManager.autoBattleStyle =
  VisuMZ.BattleCore.Settings.AutoBattle["StyleName"];

TextManager.visualHpGauge = VisuMZ.BattleCore.Settings.HpGauge["Name"];

ColorManager.getColor = function (_0x52dabe) {
  return (
    (_0x52dabe = String(_0x52dabe)),
    _0x52dabe.match(/#(.*)/i)
      ? "#%1".format(String(RegExp["$1"]))
      : this.textColor(Number(_0x52dabe))
  );
};

DataManager.getDamageStyle = function (_0x4f854d) {
  if (_0x4f854d.note.match(/<DAMAGE STYLE:[ ](.*)>/i)) {
    const _0x781f67 = String(RegExp["$1"])["toUpperCase"]().trim();
    if (_0x781f67 === "MANUAL") return "MANUAL";
    if (VisuMZ.DamageStyles[_0x781f67]) return _0x781f67;
  }
  const _0x215281 = VisuMZ.BattleCore.Settings.Damage["DefaultDamageStyle"]
    ["toUpperCase"]()
    .trim();
  if (VisuMZ.DamageStyles[_0x215281]) return _0x215281;
  return "MANUAL";
};

DataManager.getStypeIdWithName = function (_0x7e8871) {
  (_0x7e8871 = _0x7e8871.toUpperCase().trim()),
    (this._stypeIDs = this._stypeIDs || {});
  if (this._stypeIDs[_0x7e8871]) return this._stypeIDs[_0x7e8871];
  for (let _0x455afd = 1; _0x455afd < 100; _0x455afd++) {
    if (!$dataSystem.skillTypes[_0x455afd]) continue;
    let _0x118a4d = $dataSystem.skillTypes[_0x455afd]["toUpperCase"]().trim();
    (_0x118a4d = _0x118a4d.replace(/\x1I\[(\d+)\]/gi, "")),
      (_0x118a4d = _0x118a4d.replace(/\\I\[(\d+)\]/gi, "")),
      (this._stypeIDs[_0x118a4d] = _0x455afd);
  }
  return this._stypeIDs[_0x7e8871] || 0;
};

DataManager.getSkillIdWithName = function (_0x39390c) {
  (_0x39390c = _0x39390c.toUpperCase().trim()),
    (this._skillIDs = this._skillIDs || {});
  if (this._skillIDs[_0x39390c]) return this._skillIDs[_0x39390c];
  for (const _0x34fcf7 of $dataSkills) {
    if (!_0x34fcf7) continue;
    this._skillIDs[_0x34fcf7.name.toUpperCase().trim()] = _0x34fcf7.id;
  }
  return this._skillIDs[_0x39390c] || 0;
};

DataManager.getEnemyIdWithName = function (_0x554e6d) {
  (_0x554e6d = _0x554e6d.toUpperCase().trim()),
    (this._enemyIDs = this._enemyIDs || {});
  if (this._enemyIDs[_0x554e6d]) return this._enemyIDs[_0x554e6d];
  for (const _0x1d39e2 of $dataEnemies) {
    if ("VhGGL" !== "tUUYJ") {
      if (!_0x1d39e2) continue;
      this._enemyIDs[_0x1d39e2.name.toUpperCase().trim()] = _0x1d39e2.id;
    } else _0x2e1f03.prototype.terminate.call(this);
  }
  return this._enemyIDs[_0x554e6d] || 0;
};

DataManager.getWtypeIdWithName = function (_0x463afa) {
  (_0x463afa = _0x463afa.toUpperCase().trim()),
    (this._wtypeIDs = this._wtypeIDs || {});
  if (this._wtypeIDs[_0x463afa]) return this._wtypeIDs[_0x463afa];
  for (let _0x5ced8a = 1; _0x5ced8a < 100; _0x5ced8a++) {
    if (!$dataSystem.weaponTypes[_0x5ced8a]) continue;
    let _0x5ee329 = $dataSystem.weaponTypes[_0x5ced8a]["toUpperCase"]().trim();
    (_0x5ee329 = _0x5ee329.replace(/\x1I\[(\d+)\]/gi, "")),
      (_0x5ee329 = _0x5ee329.replace(/\\I\[(\d+)\]/gi, "")),
      (this._wtypeIDs[_0x5ee329] = _0x5ced8a);
  }
  return (this._wtypeIDs["BARE HANDS"] = 0), this._wtypeIDs[_0x463afa] || 0;
};

DataManager.battleDisplayText = function (_0x1ff487) {
  const _0x3beeda = "\\I[%1]%2";
  let _0x18a678 = _0x1ff487.iconIndex;
  let _0x4b5480 = _0x1ff487.name;
  const _0x3e41d9 = _0x1ff487.note;
  return (
    _0x3e41d9.match(/<DISPLAY ICON: (\d+)>/i) &&
      (_0x18a678 = Number(RegExp["$1"])),
    _0x3e41d9.match(/<DISPLAY TEXT: (.*)>/i) &&
      (_0x4b5480 = String(RegExp["$1"])),
    _0x3beeda.format(_0x18a678, _0x4b5480)
  );
};

DataManager.battleCommandName = function (_0xce3b23) {
  if (_0xce3b23.note.match(/<COMMAND TEXT: (.*)>/i)) {
    if ("oLLDU" !== "KwUUc") return String(RegExp["$1"]);
    else {
      const _0x52a52e = this.battler();
      if (_0x52a52e && _0xdebe0c) _0x52a52e.stepForward();
      return;
    }
  } else {
    if ("gVezj" !== "gVezj") (_0xa859b2 += _0x1b3f25), (_0x162281 += _0x553573);
    else return _0xce3b23.name;
  }
};

DataManager.battleCommandIcon = function (_0x4210e8) {
  if (_0x4210e8.note.match(/<COMMAND ICON: (\d+)>/i))
    return Number(RegExp["$1"]);
  else {
    if ("yiOfu" !== "yiOfu") {
      this._executeHpDamage = this._executeHpDamage || {};
      const _0x3b8f1c = _0x30797b.battlerKey();
      this._executeHpDamage[_0x3b8f1c] = _0x9dcc3e;
    } else return _0x4210e8.iconIndex;
  }
};

DataManager.swapEnemyIDs = function (_0x1ab05f) {
  const _0x184474 = $dataEnemies[_0x1ab05f];
  if (_0x184474) {
    if (
      _0x184474.note.match(/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)
    ) {
      if ("eSZUD" === "eMVAS") {
        const _0x2cdada = _0x577c97.BattleCore.Settings.AutoBattle;
        const _0x71bfa8 = this.getConfigValue("autoBattleUseSkills");
        return _0x71bfa8 ? _0x2cdada.StyleON : _0x2cdada.StyleOFF;
      } else {
        const _0x3dd888 = String(RegExp["$1"])
          ["split"](/[\r\n]+/)
          ["remove"]("");
        const _0x1b9e00 = this.processRandomizedData(_0x3dd888);
        (_0x1ab05f = this.getEnemyIdWithName(_0x1b9e00) || _0x1ab05f),
          (_0x1ab05f = DataManager.swapEnemyIDs(_0x1ab05f));
      }
    }
  }
  return _0x1ab05f;
};

DataManager.processRandomizedData = function (_0x4d4cd1) {
  let _0x3a34ae = 0;
  const _0x34ff76 = {};
  for (const _0x4d6f78 of _0x4d4cd1) {
    if (_0x4d6f78.match(/(.*):[ ](\d+)/i)) {
      if ("BLadP" !== "gspDf") {
        const _0xfdaef0 = String(RegExp["$1"]).trim();
        const _0xc46b52 = Number(RegExp["$2"]);
        (_0x34ff76[_0xfdaef0] = _0xc46b52), (_0x3a34ae += _0xc46b52);
      } else
        (_0x3879b2 += _0x1eeb60.Actor.OffsetX || 0),
          (_0x726785 += _0x2aa34c.Actor.OffsetY || 0);
    } else {
      if (_0x4d6f78.match(/(.*):[ ](\d+\.?\d+)/i)) {
        const _0x5522cf = String(RegExp["$1"]).trim();
        const _0xd56013 = Number(RegExp["$2"]);
        (_0x34ff76[_0x5522cf] = _0xd56013), (_0x3a34ae += _0xd56013);
      } else _0x4d6f78 !== "" && ((_0x34ff76[_0x4d6f78] = 1), _0x3a34ae++);
    }
  }
  if (_0x3a34ae <= 0) return "";
  let _0x3ebfa5 = Math.random() * _0x3a34ae;
  for (const _0xc5d2d3 in _0x34ff76) {
    _0x3ebfa5 -= _0x34ff76[_0xc5d2d3];
    if (_0x3ebfa5 <= 0) return _0xc5d2d3;
  }
  return "";
};

DataManager.checkAutoCustomActionSequenceNotetagEffect = function (_0x2ea13a) {
  if (!_0x2ea13a) return false;
  if (!VisuMZ.BattleCore.Settings.ActionSequence["AutoNotetag"]) return false;
  if (_0x2ea13a.note.match(/<AUTO ACTION SEQUENCE>/i)) return false;
  if (_0x2ea13a.note.match(/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi)) return true;
  for (const _0x2de0b8 of _0x2ea13a.effects) {
    if ("AOWqw" === "ZjIMy")
      _0x3ebb59.BattleSystemSTB.version < 1.15 &&
        (_0x117f12(_0x185069.format("STB")), _0x3ddfe1.exit());
    else {
      if (!_0x2de0b8) continue;
      if (_0x2de0b8.code === Game_Action.EFFECT_COMMON_EVENT) return true;
    }
  }
  return false;
};

DataManager.createTroopNote = function (_0x4bb563) {
  const _0x127887 = $dataTroops[_0x4bb563];
  if (!_0x127887) return "";
  let _0x5c8a34 = "";
  _0x5c8a34 += _0x127887.name;
  for (const _0x51222e of _0x127887.pages) {
    if ("bcAeB" !== "bcAeB")
      _0x2a32b7.performAttackSlot(_0x536b59(_0x107166["$1"]));
    else
      for (const _0x1d1087 of _0x51222e.list) {
        if ([108, 408]["includes"](_0x1d1087.code)) {
          if ("uzJgK" === "KHjur") return _0x4fecfe(_0x32677b["$1"]);
          else (_0x5c8a34 += "\n"), (_0x5c8a34 += _0x1d1087.parameters[0]);
        }
      }
  }
  return _0x5c8a34;
};

ConfigManager.autoBattleAtStart = ConfigManager.autoBattleAtStart ?? false;

ConfigManager.autoBattleUseSkills = ConfigManager.autoBattleUseSkills ?? false;

ConfigManager.visualHpGauge = ConfigManager.visualHpGauge ?? true;

VisuMZ.BattleCore.ConfigManager_makeData = ConfigManager.makeData;

ConfigManager.makeData = function () {
  const _0x4e7006 = VisuMZ.BattleCore.ConfigManager_makeData.call(this);
  return (
    (_0x4e7006.autoBattleAtStart = this.autoBattleAtStart),
    (_0x4e7006.autoBattleUseSkills = this.autoBattleUseSkills),
    (_0x4e7006.visualHpGauge = this.visualHpGauge),
    _0x4e7006
  );
};

VisuMZ.BattleCore.ConfigManager_applyData = ConfigManager.applyData;

ConfigManager.applyData = function (_0xc6b177) {
  VisuMZ.BattleCore.ConfigManager_applyData.call(this, _0xc6b177);
  "autoBattleAtStart" in _0xc6b177
    ? "qBrQM" !== "CorMi"
      ? (this.autoBattleAtStart = _0xc6b177.autoBattleAtStart)
      : !this.updateEventMain() &&
        !this._logWindow.isBusy() &&
        (this._phase = "action")
    : (this.autoBattleAtStart = false);
  if ("autoBattleUseSkills" in _0xc6b177)
    this.autoBattleUseSkills = _0xc6b177.autoBattleUseSkills;
  else {
    if ("ZzpaY" !== "xPdFN") this.autoBattleUseSkills = false;
    else {
      _0x282d86.BattleCore.Scene_Battle_commandEscape.call(this);
      if (!_0x49dc35.isTpb()) _0xb144b7._currentActor = null;
    }
  }
  "visualHpGauge" in _0xc6b177
    ? "gAFFw" !== "gAFFw"
      ? _0x48ac22.command119([_0x403b3a])
      : (this.visualHpGauge = _0xc6b177.visualHpGauge)
    : (this.visualHpGauge = true);
};

ImageManager.svActorHorzCells = ImageManager.svActorHorzCells || 9;

ImageManager.svActorVertCells = ImageManager.svActorVertCells || 6;

VisuMZ.BattleCore.BattleManager_setup = BattleManager.setup;

BattleManager.setup = function (_0x152f16, _0x1a9566, _0x20be5f) {
  VisuMZ.BattleCore.BattleManager_setup.call(
    this,
    _0x152f16,
    _0x1a9566,
    _0x20be5f
  ),
    (this._battlerKeyCache = {});
};

VisuMZ.BattleCore.BattleManager_initMembers = BattleManager.initMembers;

BattleManager.initMembers = function () {
  VisuMZ.BattleCore.BattleManager_initMembers.call(this),
    (this._forcedBattlers = []);
};

BattleManager.refreshStatusWindow = function () {
  if (!SceneManager.isSceneBattle()) return;
  const _0x3514ec = SceneManager._scene._statusWindow;
  if (_0x3514ec) _0x3514ec.requestRefresh();
};

BattleManager.battleSys = function () {
  if (BattleManager.isTpb()) return "TPB";
  return "DTB";
};

BattleManager.isBattleSys = function (_0x35bd99) {
  return (
    (_0x35bd99 = _0x35bd99.toUpperCase().trim()), this.battleSys() === _0x35bd99
  );
};

BattleManager.isDTB = function () {
  return this.isBattleSys("DTB");
};

BattleManager.isTurnBased = function () {
  return this.isDTB();
};

BattleManager.isTickBased = function () {
  return !this.isTurnBased();
};

BattleManager.isTeamBased = function () {
  return !this.isTurnBased() && !this.isTickBased();
};

BattleManager.getBattlerFromKey = function (_0x2e82b7) {
  this._battlerKeyCache = this._battlerKeyCache || {};
  if (this._battlerKeyCache[_0x2e82b7] !== undefined)
    return this._battlerKeyCache[_0x2e82b7];
  this._battlerKeyCache[_0x2e82b7] = null;
  const _0x1ac583 = this.allBattleMembers();
  const _0x35fc9d = _0x1ac583.find(
    (_0x33f08d) => _0x33f08d.battlerKey() === _0x2e82b7
  );
  if (_0x35fc9d) this._battlerKeyCache[_0x2e82b7] = _0x35fc9d;
  return this._battlerKeyCache[_0x2e82b7];
};

Game_BattlerBase.prototype.battlerKey = function () {
  return "%1-%2".format(this.isActor() ? "actor" : "enemy", this.name());
};

Game_Action.prototype.setTargetBattlerKey = function (_0x3c7345) {
  if (this._targetBattlerKey !== "") return;
  typeof _0x3c7345 === "string"
    ? (this._targetBattlerKey = _0x3c7345.toLowerCase().trim())
    : (this._targetBattlerKey = _0x3c7345.battlerKey());
};

Game_Action.prototype.getBattlerKeyTargets = function () {
  return [this.getSpecificBattlerKeyTarget()];
};

Game_Action.prototype.getSpecificBattlerKeyTarget = function () {
  const _0x451c8a = this._targetBattlerKey || "";
  const _0x3429e6 = BattleManager.getBattlerFromKey(_0x451c8a);
  if (!_0x3429e6) return this.getBattlerKeyTargetReplacement();
  if (!_0x3429e6.isAlive()) return this.getBattlerKeyTargetReplacement();
  return _0x3429e6;
};

Game_Action.prototype.getBattlerKeyTargetReplacement = function () {
  const _0x1cf14a = this._targetBattlerKey;
  return _0x1cf14a.match(/ACTOR/i)
    ? this.friendsUnit()["trueRandomTarget"]()
    : this.opponentsUnit()["trueRandomTarget"]();
};

BattleManager.selectedBattlers = function () {
  return this.allBattleMembers().filter((_0x2ba3d8) => _0x2ba3d8.isSelected());
};

BattleManager.processBattleCoreJS = function (_0x1aa8f9) {
  _0x1aa8f9 === "BattleVictoryJS" && (this._endingBattle = true),
    $gameParty.processBattleCoreJS(_0x1aa8f9),
    $gameTroop.processBattleCoreJS(_0x1aa8f9);
};

VisuMZ.BattleCore.BattleManager_startBattle = BattleManager.startBattle;

BattleManager.startBattle = function () {
  (this._endBattle = false),
    (this._autoBattle = ConfigManager.autoBattleAtStart),
    (this._endingBattle = false),
    this.processBattleCoreJS("PreStartBattleJS"),
    VisuMZ.BattleCore.BattleManager_startBattle.call(this),
    this.processBattleCoreJS("PostStartBattleJS");
};

BattleManager.processPostBattleCommonEvents = function (_0x2a1214) {
  const _0xd7a54c = VisuMZ.BattleCore.Settings.Mechanics;
  _0x2a1214 !== "EscapeFail" &&
    _0xd7a54c.BattleEndEvent &&
    VisuMZ.BattleCore.CheckMapBattleEventValid(_0xd7a54c.BattleEndEvent) &&
    ("Gtiaq" === "pbvon"
      ? this.push("addText", this.makeHpDamageText(_0x40c7ac))
      : $gameTemp.reserveCommonEvent(_0xd7a54c.BattleEndEvent));
  const _0x357766 = "%1Event".format(_0x2a1214);
  _0xd7a54c[_0x357766] &&
    VisuMZ.BattleCore.CheckMapBattleEventValid(_0xd7a54c[_0x357766]) &&
    $gameTemp.reserveCommonEvent(_0xd7a54c[_0x357766]);
};

VisuMZ.BattleCore.BattleManager_abort = BattleManager.abort;

BattleManager.abort = function () {
  VisuMZ.BattleCore.BattleManager_abort.call(this);
  if (SceneManager.isSceneBattle()) {
    if ("pUFof" !== "pUFof") {
      if (!this.enemy()) return;
      _0x21fc7b.isBattleFlipped()
        ? (this.x = _0x43100c.boxWidth - this.enemy()["battler"]()._baseX)
        : (this.x = this.enemy()["battler"]()._baseX);
      (this.x -= _0x3cc6c6.round(this.width / 2)),
        (this.y =
          this.enemy()["battler"]()._baseY -
          _0xcea1c8.round(this.lineHeight() * 1.5));
      const _0xa4aef4 = _0x43c38d.BattleCore.Settings.Enemy;
      (this.x += _0xa4aef4.NameOffsetX || 0),
        (this.y += _0xa4aef4.NameOffsetY || 0);
    } else BattleManager.updateEvent();
  }
};

VisuMZ.BattleCore.BattleManager_checkBattleEnd = BattleManager.checkBattleEnd;

BattleManager.checkBattleEnd = function () {
  if (this._phase === "turn") {
    if ($gameTemp.isCommonEventReserved()) return false;
  }
  return VisuMZ.BattleCore.BattleManager_checkBattleEnd.call(this);
};

VisuMZ.BattleCore.BattleManager_processVictory = BattleManager.processVictory;

BattleManager.processVictory = function () {
  (this._endingBattle = true),
    this.processBattleCoreJS("BattleVictoryJS"),
    VisuMZ.BattleCore.BattleManager_processVictory.call(this),
    this.processPostBattleCommonEvents("Victory");
};

VisuMZ.BattleCore.BattleManager_processAbort = BattleManager.processAbort;

BattleManager.processAbort = function () {
  (this._endingBattle = true),
    VisuMZ.BattleCore.BattleManager_processAbort.call(this);
};

VisuMZ.BattleCore.BattleManager_processDefeat = BattleManager.processDefeat;

BattleManager.processDefeat = function () {
  (this._endingBattle = true),
    this.processBattleCoreJS("BattleDefeatJS"),
    VisuMZ.BattleCore.BattleManager_processDefeat.call(this),
    this.processPostBattleCommonEvents("Defeat");
};

VisuMZ.BattleCore.BattleManager_endBattle = BattleManager.endBattle;

BattleManager.endBattle = function (_0x185964) {
  (this._endBattle = true),
    (this._autoBattle = false),
    this.processBattleCoreJS("PreEndBattleJS"),
    VisuMZ.BattleCore.BattleManager_endBattle.call(this, _0x185964),
    this.processBattleCoreJS("PostEndBattleJS");
};

VisuMZ.BattleCore.BattleManager_startTurn = BattleManager.startTurn;

BattleManager.startTurn = function () {
  if (this.isTurnBased()) this.processBattleCoreJS("PreStartTurnJS");
  VisuMZ.BattleCore.BattleManager_startTurn.call(this);
  if (this.isTurnBased()) this.processBattleCoreJS("PostStartTurnJS");
};

BattleManager.processTurn = function () {
  const _0x346bbc = this._subject;
  const _0x4d1417 = _0x346bbc.currentAction();
  if (_0x4d1417) {
    if ("UIuFn" !== "vCRnC")
      _0x4d1417.prepare(),
        _0x4d1417.isValid()
          ? "XyLur" !== "ixcTb"
            ? (this.startAction(), _0x346bbc.removeCurrentAction())
            : (_0x484def.Actor.SmoothImage = false)
          : (_0x346bbc.removeCurrentAction(), this.endAction());
    else {
      let _0x2ebe61 = -16;
      let _0x341b02 = this.height * 0.5;
      const _0x3a3c8b =
        /<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i;
      const _0x278ac1 = this._battler
        .traitObjects()
        ["map"]((_0x2bd193) =>
          _0x2bd193 && _0x2bd193.note.match(_0x3a3c8b)
            ? _0x248a15(_0xd67b09["$1"])
            : 0
        );
      const _0x2389c1 = this._battler
        .traitObjects()
        ["map"]((_0x2ec3c0) =>
          _0x2ec3c0 && _0x2ec3c0.note.match(_0x3a3c8b)
            ? _0x523cf8(_0x3d23c6["$2"])
            : 0
        );
      (_0x2ebe61 = _0x278ac1.reduce(
        (_0x4d8ae8, _0x1892a7) => _0x4d8ae8 + _0x1892a7,
        _0x2ebe61
      )),
        (_0x341b02 = _0x2389c1.reduce(
          (_0x42c88f, _0x3d2b5f) => _0x42c88f + _0x3d2b5f,
          _0x341b02
        )),
        (this._weaponSprite.x = _0x2ebe61),
        (this._weaponSprite.y = _0x341b02),
        this._weaponSprite.update();
    }
  } else
    "JQapp" !== "Lxhib"
      ? (this.endAction(), (this._subject = null))
      : _0xfafdb7.setWaitMode("cutinEnter");
};

VisuMZ.BattleCore.BattleManager_startAction = BattleManager.startAction;

BattleManager.startAction = function () {
  const _0x24c55a = this._subject.currentAction();
  const _0x109d4f = this._subject;
  _0x24c55a &&
    _0x24c55a.subject() === _0x109d4f &&
    _0x24c55a.actionBattleCoreJS("PreStartActionJS"),
    VisuMZ.BattleCore.BattleManager_startAction.call(this),
    _0x24c55a &&
      _0x24c55a.subject() === _0x109d4f &&
      _0x24c55a.actionBattleCoreJS("PostStartActionJS");
};

VisuMZ.BattleCore.BattleManager_endAction = BattleManager.endAction;

BattleManager.endAction = function () {
  const _0x46a186 = this._action;
  const _0x1f65f9 = this._subject;
  _0x46a186 &&
    _0x46a186 !== this._lastAction &&
    _0x46a186.subject() === _0x1f65f9 &&
    ("QnCxG" !== "zcbSG"
      ? _0x46a186.actionBattleCoreJS("PreEndActionJS")
      : (this._cursorArea.visible = this.isOpen()));
  if (this._subject) {
    if ("AdrUN" === "cVrUe") {
      if (_0x3e3671.isPreviousSceneBattleTransitionable()) return;
      if (!_0x100a82) return;
      if (!_0x5a2708.canMove()) return;
      _0x19ed36.BattleCore.Sprite_Actor_moveToStartPosition.call(this);
    } else VisuMZ.BattleCore.BattleManager_endAction.call(this);
  } else this._phase = "turn";
  _0x46a186 &&
    _0x46a186 !== this._lastAction &&
    _0x46a186.subject() === _0x1f65f9 &&
    _0x46a186.actionBattleCoreJS("PostEndActionJS"),
    this.refreshBattlerMotions(this.allBattleMembers()),
    (this._lastAction = this._action);
};

BattleManager.refreshBattlerMotions = function (_0x1ae0ab) {
  for (const _0xeef823 of _0x1ae0ab) {
    if (!_0xeef823) continue;
    if (!_0xeef823.battler()) continue;
    _0xeef823.battler()["refreshMotion"]();
  }
};

BattleManager.updateAction = function () {
  !this._logWindow.isBusy() && this.endAction();
};

Game_Battler.prototype.onAllActionsEnd = function () {
  this.clearResult();
  if (Imported.VisuMZ_1_SkillsStatesCore) {
    const _0x312b6e = VisuMZ.SkillsStatesCore.Settings.States;
    _0x312b6e &&
      _0x312b6e.ActionEndUpdate === false &&
      this.removeStatesAuto(1);
  } else this.removeStatesAuto(1);
  this.removeBuffsAuto();
};

BattleManager.makeEscapeRatio = function () {
  this._escapeRatio =
    VisuMZ.BattleCore.Settings.Mechanics["CalcEscapeRatioJS"]["call"](this);
};

VisuMZ.BattleCore.BattleManager_onEscapeSuccess = BattleManager.onEscapeSuccess;

BattleManager.onEscapeSuccess = function () {
  this.processBattleCoreJS("EscapeSuccessJS"),
    BattleManager._spriteset.processEscape(),
    VisuMZ.BattleCore.BattleManager_onEscapeSuccess.call(this),
    this.processPostBattleCommonEvents("EscapeSuccess");
};

VisuMZ.BattleCore.BattleManager_onEscapeFailure = BattleManager.onEscapeFailure;

BattleManager.onEscapeFailure = function () {
  this.processBattleCoreJS("EscapeFailureJS");
  const _0x218a2a = this._escapeRatio;
  VisuMZ.BattleCore.BattleManager_onEscapeFailure.call(this),
    (this._escapeRatio =
      _0x218a2a +
      VisuMZ.BattleCore.Settings.Mechanics["CalcEscapeRaiseJS"]["call"](this)),
    (this._inputting = false),
    this.processPostBattleCommonEvents("EscapeFail");
};

BattleManager.displayStartMessages = function () {
  let _0xf61015 = false;
  if (this.isDisplayEmergedEnemies())
    for (const _0x4ad80b of $gameTroop.enemyNames()) {
      this._logWindow.push("addText", TextManager.emerge.format(_0x4ad80b)),
        this._logWindow.push("wait"),
        (_0xf61015 = true);
    }
  if (this._preemptive) {
    this._logWindow.push(
      "addText",
      TextManager.preemptive.format($gameParty.name())
    ),
      this._logWindow.push("wait");
  } else if (this._surprise) {
    this._logWindow.push(
      "addText",
      TextManager.surprise.format($gameParty.name())
    ),
      this._logWindow.push("wait");
  }
  _0xf61015 && (this._logWindow.push("wait"), this._logWindow.push("clear"));
  if (this.isTpb() && this.isSkipPartyCommandWindow()) {
    if ("pfnwH" === "UhZYp") {
      _0x5fcba8.prototype.updateBitmap.call(this);
      const _0x3c509f = this._actor.svBattlerName();
      this._battlerName !== _0x3c509f &&
        ((this._battlerName = _0x3c509f),
        (this._mainSprite.bitmap = _0x5ab85c.loadSvActor(_0x3c509f))),
        this._mainSprite &&
          this._mainSprite.bitmap &&
          this._battler &&
          this._mainSprite.bitmap.smooth !==
            this._battler.battlerSmoothImage() &&
          (this._mainSprite.bitmap.smooth = this._battler.battlerSmoothImage());
    } else this._tpbNeedsPartyCommand = false;
  }
};

BattleManager.isDisplayEmergedEnemies = function () {
  if (BattleManager._autoBattle) return false;
  return VisuMZ.BattleCore.Settings.Enemy["EmergeText"];
};

VisuMZ.BattleCore.BattleManager_startInput = BattleManager.startInput;

BattleManager.startInput = function () {
  VisuMZ.BattleCore.BattleManager_startInput.call(this),
    this.isDTB() &&
      this.isSkipPartyCommandWindow() &&
      !this._surprise &&
      $gameParty.canInput() &&
      this.selectNextCommand();
};

BattleManager.isSkipPartyCommandWindow = function () {
  return VisuMZ.BattleCore.Settings.PartyCmd["SkipPartyCmd"];
};

BattleManager.checkTpbInputOpen = function () {
  this.isPartyTpbInputtable() && this.selectNextCommand();
};

VisuMZ.BattleCore.Scene_Battle_startActorCommandSelection =
  Scene_Battle.prototype.startActorCommandSelection;

Scene_Battle.prototype.startActorCommandSelection = function () {
  VisuMZ.BattleCore.Scene_Battle_startActorCommandSelection.call(this),
    BattleManager.isTpb() &&
      BattleManager._tpbNeedsPartyCommand &&
      ("GLGfr" !== "GLGfr"
        ? _0x48a588.BattleCore.Sprite_Enemy_initVisibility.call(this)
        : ((BattleManager._tpbNeedsPartyCommand = false),
          this.actorCommandCancelTPB()));
};

BattleManager.emulateAction = function (_0x5d561f, _0x1940a9, _0x534c63) {
  if (!_0x534c63) return;
  if (!_0x5d561f) return;
  if (!_0x1940a9) return;
  const _0x10a236 = this._action;
  this._action = new Game_Action(_0x5d561f);
  if (DataManager.isItem(_0x534c63)) this._action.setItem(_0x534c63.id);
  if (DataManager.isSkill(_0x534c63)) this._action.setSkill(_0x534c63.id);
  if (this._action.item()) BattleManager.invokeAction(_0x5d561f, _0x1940a9);
  this._action = _0x10a236;
};

BattleManager.invokeMagicReflection = function (_0x8e3652, _0xb44414) {
  (this._action._reflectionTarget = _0xb44414),
    this._logWindow.displayReflection(_0xb44414),
    this._logWindow.displayReflectionPlayBack(_0x8e3652, this._action),
    this._action.apply(_0x8e3652),
    this._logWindow.displayActionResults(_0x8e3652, _0x8e3652);
};

VisuMZ.BattleCore.BattleManager_makeActionOrders =
  BattleManager.makeActionOrders;

BattleManager.makeActionOrders = function () {
  VisuMZ.BattleCore.BattleManager_makeActionOrders.call(this),
    (this._actionBattlers = this._actionBattlers.filter(
      (_0x5bc26c) => _0x5bc26c && _0x5bc26c.isAppeared()
    ));
};

VisuMZ.BattleCore.BattleManager_updatePhase = BattleManager.updatePhase;

BattleManager.updatePhase = function (_0x4614f0) {
  if (this._phase === "custom") this.updateCustomActionSequence();
  else {
    if (this._phase === "forceAction") {
      if ("aZUwn" !== "wFSUE") this.updateForceAction();
      else {
        if (
          this._actions.some(
            (_0x461b67) => _0x461b67.item() && _0x461b67.isMagicSkill()
          )
        )
          return true;
      }
    } else VisuMZ.BattleCore.BattleManager_updatePhase.call(this, _0x4614f0);
  }
};

BattleManager.prepareCustomActionSequence = function () {
  (this._allTargets = this._targets.slice(0)),
    (this._targetIndex = 0),
    (this._target = this._allTargets[0] || null),
    (this._phase = "custom");
};

BattleManager.updateCustomActionSequence = function () {
  if (!this.updateEventMain() && !this._logWindow.isBusy()) {
    if ("brbCt" === "brbCt") this._phase = "action";
    else
      return (
        this.currentAction() &&
        this.currentAction()["item"]() &&
        this.currentAction()["isMagical"]()
      );
  }
};

BattleManager.forceAction = function (_0x550e98) {
  this._actionBattlers.remove(_0x550e98);
  if (_0x550e98 === this._subject) return;
  const _0x58ea71 = JsonEx.makeDeepCopy(_0x550e98.currentAction());
  this._forcedBattlers.push([_0x550e98, _0x58ea71]);
};

BattleManager.processForcedAction = function () {};

BattleManager.updateStart = function () {
  if (this.isTpb()) this._phase = "turn";
  else {
    if (this._forcedBattlers.length > 0)
      "RkNwu" !== "aPilR"
        ? (this._phase = "turn")
        : (this.visible = this.visibilityState());
    else {
      if ("hSYoM" !== "hSYoM") {
        const _0x49dc25 = this._commandNameWindow;
        const _0x266d52 = _0x5787cb.windowPadding();
        const _0x47ad54 =
          _0xfd4c3c.x + _0xd05ec1.floor(_0x1e5fcb.width / 2) + _0x266d52;
        (_0x49dc25.x = _0x49dc25.width / -2 + _0x47ad54),
          (_0x49dc25.y = _0x3f973d.floor(_0x4e91f2.height / 2));
      } else this.startInput();
    }
  }
};

BattleManager.getNextSubject = function () {
  const _0x10fdf0 = this._subject;
  _0x10fdf0 && this.isTpb() && _0x10fdf0.setActionState("undecided");
  for (;;) {
    const _0x28a252 = this.getNextSubjectFromPool();
    if (!_0x28a252) {
      if ("SQWyC" !== "SQWyC") this.opacity = 0;
      else return null;
    }
    if (_0x28a252.isBattleMember() && _0x28a252.isAlive()) {
      if ("lUbqs" === "lUbqs") return _0x28a252;
      else _0x45dc29 = _0x34f85b >= _0x321e55 ? _0x16be45 : _0x5e8a5e;
    }
  }
};

BattleManager.getNextSubjectFromPool = function () {
  if (this._forcedBattlers.length > 0) {
    if ("FJpwA" !== "iSDmh") {
      const _0xbb9742 = this._forcedBattlers.shift();
      const _0x6774c6 = _0xbb9742[0];
      return (
        (_0x6774c6._actions = _0x6774c6._actions || []),
        (_0x6774c6._actions[0] = _0xbb9742[1]),
        _0x6774c6
      );
    } else
      _0x521901.BattleCore.Game_BattlerBase_initMembers.call(this),
        this.initMembersBattleCore();
  } else {
    if ("gmFbr" !== "UbqMC") return this._actionBattlers.shift();
    else
      (_0x4439a2 += _0x39a86b.isActor() ? -_0x233fc8 : _0x54e9b2),
        (_0x44a5da += _0x82b1c5);
  }
};

VisuMZ.BattleCore.Game_Battler_forceAction = Game_Battler.prototype.forceAction;

Game_Battler.prototype.forceAction = function (_0x1c70b2, _0x347c61) {
  VisuMZ.BattleCore.Game_Battler_forceAction.call(this, _0x1c70b2, _0x347c61),
    (this._actions[this._actions.length - 1]["_forceAction"] = true);
};

Game_Interpreter.prototype.command339 = function (_0x17e57e) {
  return (
    this.iterateBattler(_0x17e57e[0], _0x17e57e[1], (_0x335104) => {
      true
        ? !_0x335104.isDeathStateAffected() &&
          (_0x335104.forceAction(_0x17e57e[2], _0x17e57e[3]),
          BattleManager.forceAction(_0x335104))
        : (this.push("performAction", _0x5b0107, _0x2ea611),
          this.push("waitCount", _0x480991._motionSpeed),
          this.push(
            "showAnimation",
            _0x1108f1,
            _0x50e696.clone(),
            _0x51bcbc.animationId
          ),
          this.push("waitForAnimation"));
    }),
    true
  );
};

VisuMZ.BattleCore.Game_Battler_makeSpeed = Game_Battler.prototype.makeSpeed;

Game_Battler.prototype.makeSpeed = function () {
  VisuMZ.BattleCore.Game_Battler_makeSpeed.call(this),
    this._actions.length <= 0 && (this._speed = Number.MIN_SAFE_INTEGER);
};

BattleManager.shouldHideBattleEndPopups = function () {
  if (VisuMZ.BattleCore.Settings.Damage["EndBattlePopups"] ?? true)
    return false;
  return SceneManager.isSceneBattle() && this._endingBattle;
};

VisuMZ.BattleCore.BattleManager_selectNextCommand =
  BattleManager.selectNextCommand;

BattleManager.selectNextCommand = function () {
  if (this.isTpb()) this.selectNextCommandTpb();
  else {
    if ("fIopN" !== "fIopN") return this._forActor;
    else VisuMZ.BattleCore.BattleManager_selectNextCommand.call(this);
  }
};

BattleManager.selectNextCommandTpb = function () {
  if (this._currentActor) {
    if ("oDaSb" !== "oDaSb") {
      const _0x4e044c = _0x102ed4.battler();
      this.push("performJump", [_0x58eaa9], _0x45bf35, _0xefcb6b),
        this.push(
          "performMoveToPoint",
          _0x583989,
          _0x4e044c._homeX,
          _0x4e044c._homeY,
          _0x17d439,
          false,
          "Linear"
        ),
        this.push("requestMotion", [_0x2a1a90], "evade"),
        this.push("waitForMovement"),
        this.push("requestMotion", [_0x1b6132], "walk");
    } else {
      if (this._currentActor.selectNextCommand()) {
        if ("hWGTO" === "hyWeP") return _0x55bc50.name;
        else return;
      }
      this.finishActorInput(),
        this.checkTpbInputClose(),
        !this._subject &&
          !this._currentActor &&
          SceneManager._scene.updateBattleProcess();
    }
  } else !this._subject && this.selectNextActor();
};

BattleManager.checkTpbInputClose = function () {
  if (!this.isPartyTpbInputtable() || this.needsActorInputCancel()) {
    if ("GhmlZ" === "GhmlZ")
      this._tpbSceneChangeCacheActor &&
        !$gameParty
          .battleMembers()
          ["includes"](this._tpbSceneChangeCacheActor) &&
        (this._tpbSceneChangeCacheActor = null),
        !this._tpbSceneChangeCacheActor
          ? (this.cancelActorInput(),
            (this._currentActor = null),
            (this._inputting = false))
          : this.revertTpbCachedActor();
    else {
      if (!_0x17c2fb.isSideView()) return false;
      return false;
    }
  }
};

BattleManager.revertTpbCachedActor = function () {
  !$gameParty.battleMembers()["includes"](this._tpbSceneChangeCacheActor) &&
    ("GlSFT" !== "xCnqu"
      ? (this._tpbSceneChangeCacheActor = null)
      : (this._forcedBattleLayout = "default")),
    this._tpbSceneChangeCacheActor
      ? ((this._currentActor = this._tpbSceneChangeCacheActor),
        (this._currentActor._tpbState = "charged"),
        (this._inputting = true),
        (this._tpbSceneChangeCacheActor = null))
      : (this.cancelActorInput(),
        (this._currentActor = null),
        (this._inputting = false));
};

VisuMZ.BattleCore.BattleManager_isTpbMainPhase = BattleManager.isTpbMainPhase;

BattleManager.isTpbMainPhase = function () {
  return this._phase === "custom"
    ? this.battleCoreTpbMainPhase()
    : VisuMZ.BattleCore.BattleManager_isTpbMainPhase.call(this);
};

BattleManager.battleCoreTpbMainPhase = function () {
  return this.isActiveTpb();
};

VisuMZ.BattleCore.BattleManager_cancelActorInput =
  BattleManager.cancelActorInput;

BattleManager.cancelActorInput = function () {
  if (this.isTpb() && this._phase === "battleEnd") {
    if ("smCZJ" === "CdKCu") {
      const _0x775891 = this.item();
      const _0x37376e = _0x775891.damage.formula;
      _0x775891.damage.formula = this._customDamageFormula;
      let _0x21f0b4 = _0x27d2b9.BattleCore.Game_Action_evalDamageFormula[
        "call"
      ](this, _0x233edb);
      return (_0x775891.damage.formula = _0x37376e), _0x21f0b4;
    } else this._currentActor = null;
  }
  VisuMZ.BattleCore.BattleManager_cancelActorInput.call(this);
};

VisuMZ.BattleCore.BattleManager_inputtingAction = BattleManager.inputtingAction;

BattleManager.inputtingAction = function () {
  const _0x3bb18b = this._currentActor;
  if (_0x3bb18b && !_0x3bb18b.inputtingAction()) {
    const _0x40f130 = _0x3bb18b._actionInputIndex;
    _0x3bb18b._actions[_0x40f130] = new Game_Action(_0x3bb18b);
  }
  return VisuMZ.BattleCore.BattleManager_inputtingAction.call(this);
};

VisuMZ.BattleCore.BattleManager_checkSubstitute = BattleManager.checkSubstitute;

BattleManager.checkSubstitute = function (_0x56f6a8) {
  if (this._action.isForFriend()) return false;
  return VisuMZ.BattleCore.BattleManager_checkSubstitute.call(this, _0x56f6a8);
};

SceneManager.isSceneBattle = function () {
  return this._scene && this._scene.constructor === Scene_Battle;
};

SceneManager.isBattleFlipped = function () {
  return Spriteset_Battle.prototype.isFlipped();
};

SceneManager.isPreviousSceneBattleTransitionable = function () {
  if (SceneManager.isPreviousScene(Scene_Options)) return true;
  return false;
};

SceneManager.isNextSceneBattleTransitionable = function () {
  if (SceneManager.isNextScene(Scene_Options)) return true;
  return false;
};

SceneManager.checkSceneBattleTransitionable = function (_0x1d1ab3) {
  if (!SceneManager.isSceneBattle()) return true;
  const _0x2166f0 = ["Scene_Options", "Scene_Party"];
  return _0x2166f0.includes(_0x1d1ab3.name);
};

VisuMZ.BattleCore.SceneManager_push = SceneManager.push;

SceneManager.push = function (_0x235b56) {
  if (!SceneManager.checkSceneBattleTransitionable(_0x235b56))
    return this.displayBattleCoreTransitionErrorMsg(_0x235b56);
  VisuMZ.BattleCore.SceneManager_push.call(this, _0x235b56);
};

SceneManager.displayBattleCoreTransitionErrorMsg = function (_0x36dbe9) {
  if (!$gameTemp.isPlaytest()) return;
  if (this._displayBattleCoreTransitionErrorMsg) return;
  this._displayBattleCoreTransitionErrorMsg = true;
  let _0x521409 = "";
  (_0x521409 += "VisuMZ_1_BattleCore does NOT support changing"),
    (_0x521409 += " to %1 midbattle.".format(_0x36dbe9.name)),
    alert(_0x521409);
};

VisuMZ.BattleCore.Game_Temp_initialize = Game_Temp.prototype.initialize;

Game_Temp.prototype.initialize = function () {
  VisuMZ.BattleCore.Game_Temp_initialize.call(this),
    (this._battleBalloonQueue = []);
};

VisuMZ.BattleCore.Game_Temp_requestAnimation =
  Game_Temp.prototype.requestAnimation;

Game_Temp.prototype.requestAnimation = function (
  _0x150310,
  _0x8d6503,
  _0x2a976c
) {
  (_0x150310 = _0x150310.filter(
    (_0x2cef2d, _0x4148b8, _0x1dedd0) =>
      _0x1dedd0.indexOf(_0x2cef2d) === _0x4148b8
  )),
    SceneManager.isSceneBattle() &&
      SceneManager.isBattleFlipped() &&
      (_0x2a976c = !_0x2a976c),
    VisuMZ.BattleCore.Game_Temp_requestAnimation.call(
      this,
      _0x150310,
      _0x8d6503,
      _0x2a976c
    ),
    SceneManager.isSceneBattle() &&
      BattleManager._spriteset.processAnimationRequests();
};

Game_Temp.prototype.setLastPluginCommandInterpreter = function (_0x2afb2b) {
  this._lastPluginCommandInterpreter = _0x2afb2b;
};

Game_Temp.prototype.getLastPluginCommandInterpreter = function () {
  return this._lastPluginCommandInterpreter;
};

Game_Temp.prototype.clearForcedGameTroopSettingsBattleCore = function () {
  this._forcedBattleLayout = undefined;
};

Game_Temp.prototype.applyForcedGameTroopSettingsBattleCore = function (
  _0x90d398
) {
  if ($gameMap && $dataMap && $dataMap.note) {
    if ("lSRIv" === "lSRIv")
      this.parseForcedGameTroopSettingsBattleCore($dataMap.note);
    else {
      const _0x1e6a65 = _0xd4b34c.actor();
      _0x2f4bed.BattleCore.Scene_Battle_selectNextCommand.call(this);
      if (_0x1e6a65) {
        if (_0x1e6a65 === _0x5ce7a5.actor()) return;
        if (_0x1e6a65 === _0x23f799._subject) return;
        if (_0x1e6a65.battler()) _0x1e6a65.battler()["stepBack"]();
      }
    }
  }
  const _0x4129c8 = $dataTroops[_0x90d398];
  if (_0x4129c8) {
    if ("OhwdN" !== "ZsxOV") {
      let _0x3b042d = DataManager.createTroopNote(_0x4129c8.id);
      this.parseForcedGameTroopSettingsBattleCore(_0x3b042d);
    } else _0x5b5ff0.reserveCommonEvent(_0x11b5dd.BattleEndEvent);
  }
};

Game_Temp.prototype.parseForcedGameTroopSettingsBattleCore = function (
  _0x4e10e4
) {
  if (!_0x4e10e4) return;
  if (_0x4e10e4.match(/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)) {
    if ("uTDJY" !== "RIsmn") {
      const _0x2a475b = String(RegExp["$1"]);
      if (_0x2a475b.match(/DEFAULT/i))
        "WWwTb" !== "WWwTb"
          ? (_0x575f5e.BattleCore.Sprite_Actor_updateBitmap.call(this),
            this._mainSprite &&
              this._mainSprite.bitmap &&
              this._battler &&
              this._mainSprite.bitmap.smooth !==
                this._battler.battlerSmoothImage() &&
              (this._mainSprite.bitmap.smooth =
                this._battler.battlerSmoothImage()))
          : (this._forcedBattleLayout = "default");
      else {
        if (_0x2a475b.match(/LIST/i))
          "CozKy" !== "CozKy"
            ? (this._currentAngle =
                (this._currentAngle * (_0x23072f - 1) + this._targetAngle) /
                _0xca9ac1)
            : (this._forcedBattleLayout = "list");
        else {
          if (_0x2a475b.match(/XP/i))
            "mBroO" === "mBroO"
              ? (this._forcedBattleLayout = "xp")
              : (_0x56d11c.BattleCore.Game_Battler_clearMotion.call(this),
                this.clearFreezeMotion());
          else {
            if (_0x2a475b.match(/PORTRAIT/i))
              this._forcedBattleLayout = "portrait";
            else {
              if (_0x2a475b.match(/BORDER/i))
                this._forcedBattleLayout = "border";
              else {
                if (_0x2a475b.match(/(?:SIDEVIEW UI|SIDEVIEW)/i)) {
                  if (Imported.VisuMZ_3_SideviewBattleUI)
                    this._forcedBattleLayout = "sideview_ui";
                  else {
                    if ("DUGHB" !== "BJVqt")
                      this._forcedBattleLayout = "default";
                    else {
                      const _0x23a1af = _0x4bfbe9[0].format(_0x44c57a[0]);
                      const _0x3ee564 = _0x122da3[1].format(_0x1bd3f[1]);
                      const _0xe6fac3 = new _0x1afc05(
                        _0x19e29e.format(_0x3ee564),
                        "i"
                      );
                      _0x2725da[_0x23a1af] = _0xe6fac3;
                    }
                  }
                } else
                  _0x2a475b.match(/(?:FRONTVIEW UI|FRONTVIEW)/i) &&
                    (Imported.VisuMZ_3_FrontviewBattleUI
                      ? (this._forcedBattleLayout = "frontview_ui")
                      : (this._forcedBattleLayout = "default"));
              }
            }
          }
        }
      }
    } else _0x336d6c = _0x414be3.BattleCore.Game_Action_makeTargets.call(this);
  }
};

VisuMZ.BattleCore.Game_Temp_requestBalloon = Game_Temp.prototype.requestBalloon;

Game_Temp.prototype.requestBalloon = function (_0x1ad3f6, _0x34c887) {
  SceneManager.isSceneBattle()
    ? this.requestBattleBalloon(_0x1ad3f6, _0x34c887)
    : VisuMZ.BattleCore.Game_Temp_requestBalloon.call(
        this,
        _0x1ad3f6,
        _0x34c887
      );
};

Game_Temp.prototype.requestBattleBalloon = function (_0x25a6b7, _0x2f2caa) {
  const _0x57fd5b = { target: _0x25a6b7, balloonId: _0x2f2caa };
  (this._battleBalloonQueue = this._battleBalloonQueue || []),
    this._battleBalloonQueue.push(_0x57fd5b);
};

Game_Temp.prototype.retrieveBattleBalloon = function () {
  return (
    (this._battleBalloonQueue = this._battleBalloonQueue || []),
    this._battleBalloonQueue.shift()
  );
};

Game_Temp.prototype.clearBattleBalloons = function () {
  this._battleBalloonQueue = [];
};

Spriteset_Battle.prototype.updateBattleBalloons = function () {
  this._battleBalloonSprites === undefined && (this._battleBalloonSprites = []);
  for (const _0x2aa721 of this._battleBalloonSprites) {
    !_0x2aa721.isPlaying() && this.removeBattleBalloon(_0x2aa721);
  }
  this.processBattleBalloonRequests();
};

Spriteset_Battle.prototype.processBattleBalloonRequests = function () {
  for (;;) {
    const _0x58a62a = $gameTemp.retrieveBattleBalloon();
    if (_0x58a62a) {
      if ("dTOab" !== "dTOab") {
        if (!_0x2080a4.isSceneBattle()) return;
        if (!_0x4d6ecd.VisuMZ_3_ActiveChainSkills) return;
        _0x26c444._performActionEnd = true;
      } else this.createBattleBalloon(_0x58a62a);
    } else break;
  }
};

Spriteset_Battle.prototype.createBattleBalloon = function (_0x362a81) {
  const _0x4a4935 = this.findTargetSprite(_0x362a81.target);
  if (_0x4a4935) {
    if ("tefWb" !== "vLoup") {
      let _0x24c2d8 = null;
      if (
        Imported.VisuMZ_4_IconBalloons &&
        Array.isArray(_0x362a81.balloonId)
      ) {
        if ("Tgihn" !== "PYsix") _0x24c2d8 = new Sprite_IconBalloon();
        else {
          if (!this.canMove()) return;
          if (!this._distortionSprite) return;
          if (
            this._targetGrowX === _0x1efed4 &&
            this._targetGrowY === _0x5e8bd9
          )
            return;
          (this._targetGrowX = _0x1e6835),
            (this._targetGrowY = _0x4b4fc6),
            (this._growDuration = _0x549e74),
            (this._growWholeDuration = _0x4ece75),
            (this._growEasing = _0x581e7b || "Linear"),
            _0x186051 <= 0 &&
              ((this._growX = this._targetGrowX),
              (this._growY = this._targetGrowY));
        }
      } else {
        if ("KugJm" !== "KugJm") {
          if (_0x3ee7b7.createKeyJS)
            return _0x433ff8.createKeyJS(_0xd95231, _0x4b9854);
          let _0x5a2f04 = "";
          if (_0x24d347.includes(_0x19733e))
            _0x5a2f04 = "Actor-%1-%2".format(_0x3ccd22.id, _0x4b1f53);
          if (_0x3f4762.includes(_0x53b6ec))
            _0x5a2f04 = "Class-%1-%2".format(_0x419061.id, _0x5306a8);
          if (_0x1ace16.includes(_0x24cdb6))
            _0x5a2f04 = "Skill-%1-%2".format(_0x4bbe4d.id, _0x52ed6b);
          if (_0x2b4f4b.includes(_0x31afca))
            _0x5a2f04 = "Item-%1-%2".format(_0x2cef41.id, _0x2547f9);
          if (_0x2eaa7d.includes(_0x5a8976))
            _0x5a2f04 = "Weapon-%1-%2".format(_0x5f385b.id, _0xc5fac0);
          if (_0x52f3fa.includes(_0x5575ff))
            _0x5a2f04 = "Armor-%1-%2".format(_0x1d858f.id, _0x57d882);
          if (_0x2a864b.includes(_0x403ad8))
            _0x5a2f04 = "Enemy-%1-%2".format(_0x2d2b67.id, _0x14df08);
          if (_0x2f6ff0.includes(_0x28d77d))
            _0x5a2f04 = "State-%1-%2".format(_0x250a2b.id, _0x33e4a8);
          return _0x5a2f04;
        } else _0x24c2d8 = new Sprite_Balloon();
      }
      (_0x24c2d8.targetObject = _0x362a81.target),
        (_0x24c2d8._target = _0x4a4935),
        (_0x24c2d8._target._character = _0x4a4935),
        _0x24c2d8.setup(_0x4a4935, _0x362a81.balloonId),
        BattleManager.addChildToUiContainer(_0x24c2d8),
        this._battleBalloonSprites.push(_0x24c2d8);
    } else _0x303a82 = _0x47b233.item().id;
  }
};

Spriteset_Battle.prototype.removeBattleBalloon = function (_0x5c37f2) {
  this._battleBalloonSprites.remove(_0x5c37f2),
    BattleManager.removeChildFromUiContainer(_0x5c37f2),
    _0x5c37f2.destroy();
};

Sprite_Battler.prototype.setBalloonPose = function (_0x2658a1, _0x2932a8) {};

Sprite_Battler.prototype.isSpriteVS8dir = function () {
  return false;
};

Spriteset_Battle.prototype.isAnyBattleBalloonPlaying = function () {
  return (
    (this._battleBalloonSprites = this._battleBalloonSprites || []),
    this._battleBalloonSprites.length > 0
  );
};

VisuMZ.BattleCore.Game_System_initialize = Game_System.prototype.initialize;

Game_System.prototype.initialize = function () {
  VisuMZ.BattleCore.Game_System_initialize.call(this), this.initBattleCore();
};

Game_System.prototype.initBattleCore = function () {
  this._defeatedEnemies = this._defeatedEnemies || [];
};

Game_System.prototype.getDefeatedEnemies = function () {
  if (this._defeatedEnemies === undefined) this.initBattleCore();
  return this._defeatedEnemies;
};

Game_System.prototype.registerDefeatedEnemy = function (_0x499b27) {
  if (this._defeatedEnemies === undefined) this.initBattleCore();
  if (!_0x499b27) return;
  if (this._defeatedEnemies.includes(_0x499b27)) return;
  this._defeatedEnemies.push(_0x499b27),
    this._defeatedEnemies.sort((_0x4a551a, _0x5317ea) => _0x4a551a - _0x5317ea);
};

VisuMZ.BattleCore.Game_BattlerBase_addNewState =
  Game_BattlerBase.prototype.addNewState;

Game_BattlerBase.prototype.addNewState = function (_0x55673e) {
  const _0x1b2d8d = this.isAlive();
  const _0x131e3e = this.stateMotionIndex();
  VisuMZ.BattleCore.Game_BattlerBase_addNewState.call(this, _0x55673e),
    this.isEnemy() &&
      _0x1b2d8d &&
      this.isDead() &&
      ((this._visualHpGauge_JustDied = !this.hasBeenDefeatedBefore()),
      $gameSystem.registerDefeatedEnemy(this.enemyId())),
    SceneManager.isSceneBattle() &&
      _0x131e3e !== this.stateMotionIndex() &&
      this.battler() &&
      this.battler()["refreshMotion"]();
};

Game_Enemy.prototype.hasBeenDefeatedBefore = function () {
  return $gameSystem.getDefeatedEnemies()["includes"](this._enemyId);
};

VisuMZ.BattleCore.Game_BattlerBase_eraseState =
  Game_BattlerBase.prototype.eraseState;

Game_BattlerBase.prototype.eraseState = function (_0x27aa9e) {
  VisuMZ.BattleCore.Game_BattlerBase_eraseState.call(this, _0x27aa9e),
    this.isEnemy() &&
      _0x27aa9e === this.deathStateId() &&
      this.isAlive() &&
      (this._visualHpGauge_JustDied = false),
    !this._tempActor &&
      !this._tempBattler &&
      SceneManager.isSceneBattle() &&
      ("Lvcmd" === "zkiSS"
        ? ((_0x42f672 += _0xf738d7.isActor() ? -_0x52e266 : _0x4d517c),
          (_0x25bdab += _0x97d7ec))
        : this.requestMotionRefresh());
};

VisuMZ.BattleCore.Game_Action_clear = Game_Action.prototype.clear;

Game_Action.prototype.clear = function () {
  VisuMZ.BattleCore.Game_Action_clear.call(this),
    (this._armorPenetration = {
      arPenRate: 0,
      arPenFlat: 0,
      arRedRate: 0,
      arRedFlat: 0,
    }),
    (this._multipliers = {
      criticalHitRate: 1,
      criticalHitFlat: 0,
      criticalDmgRate: 1,
      criticalDmgFlat: 0,
      damageRate: 1,
      damageFlat: 0,
      hitRate: 1,
      hitFlat: 0,
    }),
    (this._customDamageFormula = "default"),
    this.clearTargetBattlerKey();
};

Game_Action.prototype.clearTargetBattlerKey = function () {
  this._targetBattlerKey = "";
};

VisuMZ.BattleCore.Game_Action_setSubject = Game_Action.prototype.setSubject;

Game_Action.prototype.setSubject = function (_0x3c76a0) {
  VisuMZ.BattleCore.Game_Action_setSubject.call(this, _0x3c76a0),
    this.clearTargetBattlerKey();
};

VisuMZ.BattleCore.Game_Action_setSkill = Game_Action.prototype.setSkill;

Game_Action.prototype.setSkill = function (_0x3cc099) {
  VisuMZ.BattleCore.Game_Action_setSkill.call(this, _0x3cc099),
    this.clearTargetBattlerKey();
};

VisuMZ.BattleCore.Game_Action_setItem = Game_Action.prototype.setItem;

Game_Action.prototype.setItem = function (_0x23893f) {
  VisuMZ.BattleCore.Game_Action_setItem.call(this, _0x23893f),
    this.clearTargetBattlerKey();
};

Game_Action.prototype.makeDamageValue = function (_0x109c17, _0x45f004) {
  return VisuMZ.BattleCore.Settings.Damage["OverallFormulaJS"]["call"](
    this,
    _0x109c17,
    _0x45f004
  );
};

Game_Action.prototype.applyVariance = function (_0x36728e, _0x2e7829) {
  return VisuMZ.BattleCore.Settings.Damage["VarianceFormulaJS"]["call"](
    this,
    _0x36728e,
    _0x2e7829
  );
};

Game_Action.prototype.applyGuard = function (_0x533368, _0x4e2dd8) {
  return VisuMZ.BattleCore.Settings.Damage["GuardFormulaJS"]["call"](
    this,
    _0x533368,
    _0x4e2dd8
  );
};

VisuMZ.BattleCore.Game_Action_itemHit = Game_Action.prototype.itemHit;

Game_Action.prototype.itemHit = function (_0x1a9acd) {
  const _0x25d2f5 = this.item()["note"];
  if (_0x25d2f5.match(/<ALWAYS HIT>/i)) return 1;
  else {
    if (_0x25d2f5.match(/<ALWAYS HIT RATE: (\d+)([%％])>/i))
      return Number(RegExp["$1"]) / 100;
    else {
      let _0x19825b = VisuMZ.BattleCore.Game_Action_itemHit.call(
        this,
        _0x1a9acd
      );
      return (
        (_0x19825b =
          this._multipliers.hitRate * _0x19825b + this._multipliers.hitFlat),
        _0x19825b
      );
    }
  }
};

Game_Action.prototype.itemCri = function (_0x7f3de6) {
  if (!this.item()["damage"]["critical"]) return 0;
  let _0x13b87f = VisuMZ.BattleCore.Settings.Damage["CriticalHitRateJS"][
    "call"
  ](this, _0x7f3de6);
  return (
    (_0x13b87f =
      this._multipliers.criticalHitRate * _0x13b87f +
      this._multipliers.criticalHitFlat),
    _0x13b87f
  );
};

Game_Action.prototype.applyCritical = function (_0x58fa5a) {
  return (
    (_0x58fa5a = VisuMZ.BattleCore.Settings.Damage["CriticalHitMultiplier"][
      "call"
    ](this, _0x58fa5a)),
    (_0x58fa5a =
      this._multipliers.criticalDmgRate * _0x58fa5a +
      this._multipliers.criticalDmgFlat),
    _0x58fa5a
  );
};

VisuMZ.BattleCore.Game_Action_evalDamageFormula =
  Game_Action.prototype.evalDamageFormula;

Game_Action.prototype.evalDamageFormula = function (_0xf47900) {
  if (this._customDamageFormula !== "default")
    return this.customDamageFormula(_0xf47900);
  else {
    if (DataManager.getDamageStyle(this.item()) === "MANUAL") {
      if ("MqjCj" !== "gWjsN")
        return VisuMZ.BattleCore.Game_Action_evalDamageFormula.call(
          this,
          _0xf47900
        );
      else {
        if (!this._linkedSprite) return;
        (this._lineHeight =
          this._lineHeight || _0x303426.prototype.lineHeight()),
          (this.x = _0x27979d.round(this._linkedSprite._baseX)),
          (this.y = _0x2afc48.round(
            this._linkedSprite._baseY - this._lineHeight * 0.5
          ));
        const _0x245f7b = _0x4b0359.BattleCore.Settings.Enemy;
        (this.x += _0x2bf88e.round(_0x245f7b.NameOffsetX || 0)),
          (this.y += _0x140d3e.round(_0x245f7b.NameOffsetY || 0));
      }
    } else return this.evalDamageFormulaBattleCore(_0xf47900);
  }
};

Game_Action.prototype.setCustomDamageFormula = function (_0x3f5e6d) {
  this._customDamageFormula = _0x3f5e6d;
};

Game_Action.prototype.customDamageFormula = function (_0x2d26eb) {
  const _0x23b10f = this.item();
  const _0x492e59 = _0x23b10f.damage.formula;
  _0x23b10f.damage.formula = this._customDamageFormula;
  let _0xb29410 = VisuMZ.BattleCore.Game_Action_evalDamageFormula.call(
    this,
    _0x2d26eb
  );
  return (_0x23b10f.damage.formula = _0x492e59), _0xb29410;
};

Game_Action.prototype.damageStyle = function () {
  if (this.item()["note"]["match"](/<DAMAGE STYLE:[ ](.*)>/i)) {
    const _0x40030e = String(RegExp["$1"])["toUpperCase"]().trim();
    return _0x40030e;
  }
  return "MANUAL";
};

Game_Action.prototype.evalDamageFormulaBattleCore = function (_0x48b405) {
  const _0x41c21f = DataManager.getDamageStyle(this.item());
  const _0x1d6b89 = VisuMZ.DamageStyles[_0x41c21f];
  try {
    return _0x1d6b89.Formula.call(this, _0x48b405);
  } catch (_0x5de074) {
    if ($gameTemp.isPlaytest()) console.log(_0x5de074);
    return VisuMZ.BattleCore.Game_Action_evalDamageFormula.call(this);
  }
};

Game_Action.prototype.applyArmorModifiers = function (_0x1c6b95, _0x3f5678) {
  if (this.isCertainHit()) return _0x3f5678;
  const _0x40694a = this.subject();
  const _0x35504c = _0x1c6b95;
  let _0x191ce4 = [];
  let _0x44fa56 = [];
  _0x191ce4.push(
    this._armorPenetration.arPenFlat,
    this._armorPenetration.arRedFlat
  ),
    _0x44fa56.push(
      this._armorPenetration.arPenRate,
      this._armorPenetration.arRedRate
    );
  const _0xb5ebd3 = this.isPhysical()
    ? /<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i
    : /<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i;
  const _0x115e85 = this.isPhysical()
    ? /<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i
    : /<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i;
  const _0xe9f036 = this.isPhysical()
    ? /<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i
    : /<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i;
  const _0x3dac74 = this.isPhysical()
    ? /<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i
    : /<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;
  (_0x191ce4 = _0x191ce4.concat(
    _0x35504c
      .traitObjects()
      ["map"]((_0x2c47a6) =>
        _0x2c47a6 && _0x2c47a6.note.match(_0xb5ebd3) ? Number(RegExp["$1"]) : 0
      )
  )),
    (_0x44fa56 = _0x44fa56.concat(
      _0x35504c
        .traitObjects()
        ["map"]((_0x2b16b5) =>
          _0x2b16b5 && _0x2b16b5.note.match(_0x115e85)
            ? Number(RegExp["$1"]) / 100
            : 0
        )
    )),
    (_0x191ce4 = _0x191ce4.concat(
      _0x40694a
        .traitObjects()
        ["map"]((_0xc371a8) =>
          _0xc371a8 && _0xc371a8.note.match(_0xe9f036)
            ? Number(RegExp["$1"])
            : 0
        )
    )),
    (_0x44fa56 = _0x44fa56.concat(
      _0x40694a
        .traitObjects()
        ["map"]((_0x301dcd) =>
          _0x301dcd && _0x301dcd.note.match(_0x3dac74)
            ? Number(RegExp["$1"]) / 100
            : 0
        )
    ));
  if (this.item()["note"]["match"](_0xe9f036)) {
    if ("Tbwlx" === "NcCFl") {
      if (_0x2ceec1 === this.deathStateId() && this.isImmortal()) return true;
      return _0x5c696d.BattleCore.Game_BattlerBase_isStateResist.call(
        this,
        _0x18fb2c
      );
    } else _0x191ce4.push(Number(RegExp["$1"]));
  }
  this.item()["note"]["match"](_0x3dac74) &&
    _0x44fa56.push(Number(RegExp["$1"]));
  _0x3f5678 = _0x191ce4.reduce(
    (_0x36e266, _0x4fc73f) => _0x36e266 - _0x4fc73f,
    _0x3f5678
  );
  if (_0x3f5678 > 0) {
    if ("RfKIh" !== "RfKIh")
      return _0x5820e8.BattleCore.Scene_Battle_skillWindowRect.call(this);
    else
      _0x3f5678 = _0x44fa56.reduce(
        (_0xc83b21, _0xeee806) => _0xc83b21 * (1 - _0xeee806),
        _0x3f5678
      );
  }
  return _0x3f5678;
};

VisuMZ.BattleCore.Game_Action_executeDamage =
  Game_Action.prototype.executeDamage;

Game_Action.prototype.executeDamage = function (_0x4d66b6, _0x331a0c) {
  (_0x331a0c = _0x331a0c * this._multipliers.damageRate),
    (_0x331a0c += this._multipliers.damageFlat * (_0x331a0c >= 0 ? 1 : -1)),
    (_0x331a0c = this.applyBattleCoreJS(
      "PreDamage%1JS",
      _0x4d66b6,
      _0x331a0c,
      false
    )),
    (_0x331a0c = this.applyDamageCaps(_0x331a0c)),
    (_0x331a0c = Math.round(_0x331a0c)),
    (this._executedValue = _0x331a0c),
    (this._totalValue = this._totalValue || 0),
    (this._totalValue += _0x331a0c),
    VisuMZ.BattleCore.Game_Action_executeDamage.call(
      this,
      _0x4d66b6,
      _0x331a0c
    ),
    this.applyBattleCoreJS("PostDamage%1JS", _0x4d66b6, _0x331a0c, true);
};

Game_Action.prototype.applyDamageCaps = function (_0x5cc66d) {
  if (this.isBypassDamageCap()) return _0x5cc66d;
  return (
    (_0x5cc66d = this.applySoftDamageCap(_0x5cc66d)),
    (_0x5cc66d = this.applyHardDamageCap(_0x5cc66d)),
    _0x5cc66d
  );
};

Game_Action.prototype.isBypassDamageCap = function () {
  const _0x14e48f = /<BYPASS DAMAGE CAP>/i;
  if (this.item()["note"]["match"](_0x14e48f)) return true;
  if (
    this.subject()
      ["traitObjects"]()
      ["some"]((_0x34c3c1) => _0x34c3c1 && _0x34c3c1.note.match(_0x14e48f))
  )
    return true;
  return !VisuMZ.BattleCore.Settings.Damage["EnableDamageCap"];
};

Game_Action.prototype.applySoftDamageCap = function (_0x5db58c) {
  if (!VisuMZ.BattleCore.Settings.Damage["EnableSoftCap"]) return _0x5db58c;
  const _0x34fbea = /<BYPASS SOFT DAMAGE CAP>/i;
  if (this.item()["note"]["match"](_0x34fbea)) return _0x5db58c;
  if (
    this.subject()
      ["traitObjects"]()
      ["some"]((_0x2e302c) => _0x2e302c && _0x2e302c.note.match(_0x34fbea))
  )
    return "Egcry" === "Egcry" ? _0x5db58c : _0x150292.attackMotions[0];
  const _0x25a2db = _0x5db58c < 0 ? -1 : 1;
  _0x5db58c = Math.abs(_0x5db58c);
  let _0x48ad90 = this.subject()["softDamageCapRate"]();
  this.item()["note"]["match"](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i) &&
    (_0x48ad90 += Number(RegExp["$1"]) / 100);
  _0x48ad90 = _0x48ad90.clamp(0.01, 1);
  const _0x187d45 = this.getHardDamageCap();
  const _0x899f65 = _0x48ad90 * _0x187d45;
  if (_0x5db58c > _0x899f65 && _0x187d45 > _0x899f65) {
    _0x5db58c -= _0x899f65;
    const _0xa1395c = VisuMZ.BattleCore.Settings.Damage["DefaultSoftScaler"];
    const _0x104ce1 = Math.max(
      1 - _0x5db58c / ((_0x187d45 - _0x899f65) * _0xa1395c + _0x5db58c),
      0.01
    );
    (_0x5db58c *= _0x104ce1), (_0x5db58c += _0x899f65);
  }
  return _0x5db58c * _0x25a2db;
};

Game_Action.prototype.getHardDamageCap = function () {
  if (this.item()["note"]["match"](/<DAMAGE CAP:[ ](\d+)>/i)) {
    if ("BSdNv" !== "BSdNv") {
      const _0xc3b9ff = this.weapons();
      _0x17bed0 = _0xc3b9ff[_0x4bfb8d] ? _0xc3b9ff[_0x268f48]["wtypeId"] : 0;
    } else return Number(RegExp["$1"]);
  } else return this.subject()["hardDamageCap"]();
};

Game_Action.prototype.applyHardDamageCap = function (_0x3b42e4) {
  let _0x1013da = this.getHardDamageCap();
  return _0x3b42e4.clamp(-_0x1013da, _0x1013da);
};

Game_Action.prototype.shouldDisperseDamage = function () {
  if (!this.item()) return false;
  if (!$gameParty.inBattle()) return false;
  return (this.item()["note"] || "")["match"](/<DISPERSE DAMAGE>/i);
};

Game_Action.prototype.disperseDamage = function (_0x4c3797) {
  if (this.shouldDisperseDamage()) {
    let _0x5ef636 = BattleManager._targets;
    (_0x4c3797 /= _0x5ef636.length),
      this.isAttack() &&
        ("nqDBe" === "nqDBe"
          ? (_0x4c3797 *= this.subject()["attackTimesAdd"]() + 1)
          : (this._defeatedEnemies = this._defeatedEnemies || [])),
      (_0x4c3797 =
        _0x4c3797 > 0 ? Math.ceil(_0x4c3797) : Math.floor(_0x4c3797));
  }
  return _0x4c3797;
};

VisuMZ.BattleCore.Game_Action_makeDamageValueDisperse =
  Game_Action.prototype.makeDamageValue;

Game_Action.prototype.makeDamageValue = function (_0x3a2cfd, _0x5d27cd) {
  let _0x5ea997 = VisuMZ.BattleCore.Game_Action_makeDamageValueDisperse.call(
    this,
    _0x3a2cfd,
    _0x5d27cd
  );
  return this.disperseDamage(_0x5ea997);
};

Game_Action.prototype.itemEffectRecoverHp = function (_0x5641af, _0x44fbc3) {
  let _0x510912 =
    (_0x5641af.mhp * _0x44fbc3.value1 + _0x44fbc3.value2) * _0x5641af.rec;
  (_0x510912 = this.disperseDamage(_0x510912)),
    this.isItem() && (_0x510912 *= this.subject()["pha"]),
    (_0x510912 = Math.floor(_0x510912)),
    _0x510912 !== 0 &&
      (_0x5641af.gainHp(_0x510912), this.makeSuccess(_0x5641af));
};

Game_Action.prototype.itemEffectRecoverMp = function (target, effect) {
  let value = (target.mmp * effect.value1 + effect.value2) * target.rec;
  value = this.disperseDamage(value);
  if (this.isItem()) {
    value *= this.subject().pha;
  }
  value = Math.floor(value);
  if (value !== 0) {
    target.gainMp(value);
    this.makeSuccess(target);
  }
};

Game_Action.prototype.itemEffectGainTp = function (_0x1368bd, _0x5b452f) {
  let _0x5c3186 = Math.floor(_0x5b452f.value1);
  (_0x5c3186 = this.disperseDamage(_0x5c3186)),
    _0x5c3186 !== 0 &&
      (_0x1368bd.gainTp(_0x5c3186), this.makeSuccess(_0x1368bd));
};

VisuMZ.BattleCore.Game_Action_apply = Game_Action.prototype.apply;

Game_Action.prototype.apply = function (_0x12ead4) {
  this.applyBattleCoreJS("PreApply%1JS", _0x12ead4, 0, true),
    VisuMZ.BattleCore.Game_Action_apply.call(this, _0x12ead4),
    this.applyBattleCoreJS(
      "PostApply%1JS",
      _0x12ead4,
      this._executedValue || 0,
      true
    ),
    this.applyResultSwitches(_0x12ead4);
};

Game_Action.prototype.applyBattleCoreJS = function (
  _0x52fa0a,
  _0x308d4d,
  _0x38171c,
  _0x340317
) {
  if (this._tempBattler || this._tempActor) return;
  _0x38171c = _0x38171c || 0;
  const _0x1c574a = _0x38171c;
  const _0x1551bf = VisuMZ.BattleCore.Settings.Mechanics;
  const _0x25a7b5 = _0x52fa0a.format("");
  if (_0x1551bf[_0x25a7b5]) {
    if ("IvOYS" !== "kEyen") {
      _0x38171c = _0x1551bf[_0x25a7b5]["call"](this, _0x38171c, _0x308d4d);
      if (_0x340317) _0x38171c = _0x1c574a;
    } else this._spriteset.update();
  }
  let _0x175586 = VisuMZ.BattleCore.createKeyJS(
    this.item(),
    _0x52fa0a.format("")
  );
  if (VisuMZ.BattleCore.JS[_0x175586]) {
    if ("hMvDV" === "hMvDV") {
      _0x38171c = VisuMZ.BattleCore.JS[_0x175586]["call"](
        this,
        this.subject(),
        _0x308d4d,
        this.item(),
        _0x38171c
      );
      if (_0x340317) _0x38171c = _0x1c574a;
    } else
      (_0x17b8ad += _0x3ae511.isActor() ? -_0x37e8be : _0xc8f0f3),
        (_0x39395d += _0x3e20a1);
  }
  for (const _0x149620 of this.subject()["traitObjects"]()) {
    if (!_0x149620) continue;
    _0x175586 = VisuMZ.BattleCore.createKeyJS(
      _0x149620,
      _0x52fa0a.format("AsUser")
    );
    if (VisuMZ.BattleCore.JS[_0x175586]) {
      _0x38171c = VisuMZ.BattleCore.JS[_0x175586]["call"](
        this,
        this.subject(),
        _0x308d4d,
        _0x149620,
        _0x38171c
      );
      if (_0x340317) _0x38171c = _0x1c574a;
    }
  }
  for (const _0x52fef0 of _0x308d4d.traitObjects()) {
    if (!_0x52fef0) continue;
    _0x175586 = VisuMZ.BattleCore.createKeyJS(
      _0x52fef0,
      _0x52fa0a.format("AsTarget")
    );
    if (VisuMZ.BattleCore.JS[_0x175586]) {
      _0x38171c = VisuMZ.BattleCore.JS[_0x175586]["call"](
        this,
        this.subject(),
        _0x308d4d,
        _0x52fef0,
        _0x38171c
      );
      if (_0x340317) _0x38171c = _0x1c574a;
    }
  }
  return _0x38171c;
};

Game_Action.prototype.actionBattleCoreJS = function (_0x4698de) {
  const _0x2b887c = this._totalValue || 0;
  const _0x183f81 = VisuMZ.BattleCore.Settings.Mechanics;
  const _0x4af188 = _0x4698de.format("");
  _0x183f81[_0x4af188] && _0x183f81[_0x4af188]["call"](this, _0x2b887c);
  let _0x3cdaf5 = VisuMZ.BattleCore.createKeyJS(this.item(), _0x4698de);
  if (VisuMZ.BattleCore.JS[_0x3cdaf5]) {
    if ("Uqvnh" !== "FbTbF")
      VisuMZ.BattleCore.JS[_0x3cdaf5]["call"](
        this,
        this.subject(),
        this.subject(),
        this.item(),
        _0x2b887c
      );
    else
      for (const _0x3aa772 of _0x434de9) {
        for (const _0x19cab7 of _0x8a6a60) {
          const _0x48916e = _0x50708f[0].format(_0x19cab7[0], _0x3aa772[0]);
          const _0xc09bda = _0x364045[1]
            .format(_0x19cab7[1], _0x3aa772[1])
            .trim();
          const _0x3a7a48 = new _0x29d11d(_0x5ae468.format(_0xc09bda), "i");
          _0x31709a[_0x48916e] = _0x3a7a48;
        }
      }
  }
  for (const _0x533408 of this.subject()["traitObjects"]()) {
    if ("rgRJn" !== "iqfSI") {
      if (!_0x533408) continue;
      (_0x3cdaf5 = VisuMZ.BattleCore.createKeyJS(_0x533408, _0x4698de)),
        VisuMZ.BattleCore.JS[_0x3cdaf5] &&
          ("yfUYY" === "yfUYY"
            ? VisuMZ.BattleCore.JS[_0x3cdaf5]["call"](
                this,
                this.subject(),
                this.subject(),
                _0x533408,
                _0x2b887c
              )
            : (_0x45e73e.BattleCore.Spriteset_Battle_createLowerLayer.call(
                this
              ),
              this.createWeather(),
              this.createEnemyNames()));
    } else
      this.isCustomActionSequence(_0x54fb92)
        ? _0x340f69.prepareCustomActionSequence()
        : this.usePremadeActionSequence(_0x34655f, _0x11b9fb, _0x5ab021);
  }
};

Game_Action.prototype.speed = function () {
  return VisuMZ.BattleCore.Settings.Mechanics["CalcActionSpeedJS"]["call"](
    this
  );
};

Game_Action.prototype.allowRandomSpeed = function () {
  return VisuMZ.BattleCore.Settings.Mechanics["AllowRandomSpeed"];
};

Game_Action.prototype.isCustomBattleScope = function () {
  if (this._targetBattlerKey === "all actors") return false;
  if (this._targetBattlerKey === "all enemies") return false;
  if (!this.item()) return false;
  return this.item()["note"]["match"](/<JS TARGETS>/i);
};

Game_Action.prototype.isBattleCoreTargetScope = function () {
  if (this._targetBattlerKey === "all actors") return false;
  if (this._targetBattlerKey === "all enemies") return false;
  if (!this._forcing && this.subject()["isConfused"]()) return false;
  if (this.isCustomBattleScope()) return true;
  if (!this.item()) return false;
  return typeof this.item()["scope"] === "string";
};

VisuMZ.BattleCore.Game_Action_isForOpponent =
  Game_Action.prototype.isForOpponent;

Game_Action.prototype.isForOpponent = function () {
  if (this._targetBattlerKey === "all actors") return false;
  if (this._targetBattlerKey === "all enemies") return true;
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope())
    return this.isForOpponentBattleCore();
  else {
    if ("iuLjY" !== "iuLjY") this.revertTpbCachedActor();
    else return VisuMZ.BattleCore.Game_Action_isForOpponent.call(this);
  }
};

Game_Action.prototype.isForOpponentBattleCore = function () {
  const _0x3189eb = this.item()["scope"];
  if (_0x3189eb.match(/ANY/i)) return true;
  return _0x3189eb.match(/(?:ENEMY|ENEMIES|FOE|FOES)/i);
};

VisuMZ.BattleCore.Game_Action_isForFriend = Game_Action.prototype.isForFriend;

Game_Action.prototype.isForFriend = function () {
  if (this._targetBattlerKey === "all actors") return true;
  if (this._targetBattlerKey === "all enemies") return false;
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope())
    return "neVQM" !== "neVQM"
      ? _0x20856d.BattleCore.Game_Interpreter_command301.call(this, _0x222f85)
      : this.isForFriendBattleCore();
  else {
    if ("IxjbT" === "wyXdv") {
      if (_0x574d36) _0xc96d2d.processBattleCoreJS(_0x248ab1);
    } else return VisuMZ.BattleCore.Game_Action_isForFriend.call(this);
  }
};

Game_Action.prototype.isForFriendBattleCore = function () {
  const _0x2299b = this.item()["scope"];
  return _0x2299b.match(/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);
};

Game_Action.prototype.isForAnyone = function () {
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope()) {
    if ("AKXhK" !== "AKXhK")
      _0x5384f7 = this._baseLineStack[this._baseLineStack.length - 1];
    else {
      const _0xde38d4 = this.item()["scope"];
      return (
        _0xde38d4.match(/(?:ENEMY|FOE)/i) &&
        _0xde38d4.match(/OR/i) &&
        _0xde38d4.match(/(?:ALLY|FRIEND)/i)
      );
    }
  } else {
    if ("BOqiI" === "wPfVo") {
      if (!_0x4097f.isSideView()) return;
      const _0x4a2ec6 = this.battler();
      if (!_0x4a2ec6) return;
      _0x4a2ec6.startJump(_0x405a86, _0x54596e);
    } else return false;
  }
};

Game_Action.prototype.isForAnyoneFocusFriends = function () {
  if (this.isForAnyone()) {
    const _0x39ba04 = this.item()["scope"];
    if (_0x39ba04.match(/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i)) return true;
  }
  return false;
};

Game_Action.prototype.isForAnyoneFocusOpponents = function () {
  if (this.isForAnyone()) {
    if ("qISwC" === "qISwC") {
      const _0x4096f1 = this.item()["scope"];
      if (_0x4096f1.match(/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i)) return true;
    } else {
      if (!_0x46a35e.value(_0x199dba)) return false;
    }
  }
  return false;
};

VisuMZ.BattleCore.Game_Action_isForAliveFriend =
  Game_Action.prototype.isForAliveFriend;

Game_Action.prototype.isForAliveFriend = function () {
  if (this._targetBattlerKey === "all actors") return true;
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope())
    return this.isForAliveFriendBattleCore();
  else {
    if ("hTmxD" === "hTmxD")
      return VisuMZ.BattleCore.Game_Action_isForAliveFriend.call(this);
    else {
      if (_0x3d0289.value(_0x5bbe0b)) return true;
    }
  }
};

VisuMZ.BattleCore.Game_Action_isForDeadFriend =
  Game_Action.prototype.isForDeadFriend;

Game_Action.prototype.isForDeadFriend = function () {
  if (this._targetBattlerKey === "all actors") {
    if ("hMPKd" !== "KaLEb")
      return VisuMZ.BattleCore.Game_Action_isForDeadFriend.call(this);
    else {
      const _0xcfb37 = _0x2c9cf2.width;
      const _0x2f1928 = _0x134f7c.round((_0x4ed4cf.boxWidth - _0xcfb37) / 2);
      const _0x5ed820 = this.helpAreaHeight();
      const _0x599c77 = (_0x3189.height - _0x72bd4.boxHeight) / -2;
      return new _0x136f4d(_0x2f1928, _0x599c77, _0xcfb37, _0x5ed820);
    }
  }
  return VisuMZ.BattleCore.Game_Action_isForDeadFriend.call(this);
};

Game_Action.prototype.isForAliveFriendBattleCore = function () {
  if (this.isForAnyone()) return true;
  return false;
};

Game_Action.prototype.isForNotUser = function () {
  return (
    this.item() &&
    this.item()["note"]["match"](/<CANNOT TARGET (?:USER|SELF)>/i)
  );
};

VisuMZ.BattleCore.Game_Action_isForOne = Game_Action.prototype.isForOne;

Game_Action.prototype.isForOne = function () {
  if (this._targetBattlerKey === "all actors") return false;
  if (this._targetBattlerKey === "all enemies") return false;
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope()) {
    if ("gazSQ" === "gazSQ") return this.isForOneBattleCore();
    else {
      if (
        this._actions.some(
          (_0x1a0cb1) => _0x1a0cb1.item() && _0x1a0cb1.isMagical()
        )
      )
        return true;
    }
  } else {
    if ("oPAEH" === "BvxME") !this._logWindow.isBusy() && this.endAction();
    else return VisuMZ.BattleCore.Game_Action_isForOne.call(this);
  }
};

Game_Action.prototype.isForOneBattleCore = function () {
  if (this.isForAnyone()) return true;
  return false;
};

VisuMZ.BattleCore.Game_Action_isForRandom = Game_Action.prototype.isForRandom;

Game_Action.prototype.isForRandom = function () {
  if (this._targetBattlerKey === "all actors") return false;
  if (this._targetBattlerKey === "all enemies") return false;
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope())
    return "XNXKY" === "zuztd"
      ? this.getMenuImage()
      : this.isForRandomBattleCore();
  else {
    if ("RycyQ" === "BPZJi") {
      let _0xc73a94 = _0x29357a(_0x33bf3f["$1"]);
      while (_0xc73a94--) {
        const _0x4c517b =
          _0x3f4be2.randomInt(2) === 0
            ? this.opponentsUnit()
            : this.friendsUnit();
        _0x11d180.push(_0x4c517b.trueRandomTarget());
      }
      return this.repeatTargets(_0xc4ba44);
    } else return VisuMZ.BattleCore.Game_Action_isForRandom.call(this);
  }
};

Game_Action.prototype.isForRandomBattleCore = function () {
  const _0x29b442 = this.item()["scope"];
  return _0x29b442.match(/(?:RAND|RANDOM)/i);
};

VisuMZ.BattleCore.Game_Action_isForAll = Game_Action.prototype.isForAll;

Game_Action.prototype.isForAll = function () {
  if (this._targetBattlerKey === "all actors") return true;
  if (this._targetBattlerKey === "all enemies") return true;
  return VisuMZ.BattleCore.Game_Action_isForAll.call(this);
};

Game_Action.prototype.canSingleOrMultipleSelect = function () {
  if (!this.item()) return false;
  if (this.isForDeadFriend()) return false;
  return (this.item()["note"] || "")["match"](/<SINGLE OR MULTIPLE SELECT>/i);
};

VisuMZ.BattleCore.Game_Action_testApply = Game_Action.prototype.testApply;

Game_Action.prototype.testApply = function (_0x3917d5) {
  if (this.isForNotUser() && _0x3917d5 === this.subject()) return false;
  return VisuMZ.BattleCore.Game_Action_testApply.call(this, _0x3917d5);
};

VisuMZ.BattleCore.Game_Action_itemTargetCandidates =
  Game_Action.prototype.itemTargetCandidates;

Game_Action.prototype.itemTargetCandidates = function () {
  const _0x239038 =
    VisuMZ.BattleCore.Game_Action_itemTargetCandidates.call(this);
  if (this.isForNotUser()) _0x239038.remove(this.subject());
  return _0x239038;
};

VisuMZ.BattleCore.Game_Action_needsSelection =
  Game_Action.prototype.needsSelection;

Game_Action.prototype.needsSelection = function () {
  if (this.isBattleCoreTargetScope() && !this.isCustomBattleScope()) {
    if ("OsEln" === "nGazZ") {
      if (!_0xd90eb8.isSceneBattle()) return;
      const _0x191ca6 = _0x1c1f87.getLastPluginCommandInterpreter();
      const _0x3420f1 = _0x399916._action;
      const _0x3cc7a9 = _0x46645a._subject;
      const _0x394e95 = _0x16f49b._logWindow;
      if (!_0x191ca6 || !_0x3420f1 || !_0x3cc7a9) return;
      if (!_0x3420f1.item()) return;
      _0x394e95.displayAction(_0x3cc7a9, _0x3420f1.item()),
        _0x191ca6.setWaitMode("battlelog");
    } else return this.needsSelectionBattleCore();
  } else {
    if ("cOTgN" === "cOTgN")
      return VisuMZ.BattleCore.Game_Action_needsSelection.call(this);
    else {
      const _0x2c5eb8 = _0x393643.parse(
        "[" + _0x969c10["$1"]["match"](/\d+/g) + "]"
      );
      for (const _0x5bf70e of _0x2c5eb8) {
        if (!_0x41477d.value(_0x5bf70e)) return true;
      }
      return false;
    }
  }
};

Game_Action.prototype.needsSelectionBattleCore = function () {
  const _0x2ca76d = this.item()["scope"];
  if (_0x2ca76d.match(/RANDOM/i)) return false;
  if (_0x2ca76d.match(/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)) return false;
  if (_0x2ca76d.match(/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i)) return false;
  if (_0x2ca76d.match(/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i)) return true;
  if (_0x2ca76d.match(/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i)) return true;
  return VisuMZ.BattleCore.Game_Action_needsSelection.call(this);
};

VisuMZ.BattleCore.Game_Action_makeTargets = Game_Action.prototype.makeTargets;

Game_Action.prototype.makeTargets = function () {
  let _0x368143 = [];
  if (this.isBattleCoreTargetScope()) {
    if (this.isCustomBattleScope()) {
      if ("YclRK" === "TerTb")
        return [_0x40862f.GetActionSequenceSpecialTarget()];
      else _0x368143 = this.makeTargetsBattleCoreJS();
    } else _0x368143 = this.makeTargetsBattleCore();
  } else _0x368143 = VisuMZ.BattleCore.Game_Action_makeTargets.call(this);
  return (_0x368143 = this.applyTargetFilters(_0x368143)), _0x368143;
};

Game_Action.prototype.isSubjectValidForAnyoneSelect = function () {
  return this.subject()["isActor"]() && !this.subject()["isAutoBattle"]();
};

Game_Action.prototype.makeTargetsBattleCoreJS = function () {
  const _0x4e08a5 = VisuMZ.BattleCore.createKeyJS(this.item(), "Targets");
  if (VisuMZ.BattleCore.JS[_0x4e08a5]) {
    if ("RAQiM" === "RAQiM") {
      targets = VisuMZ.BattleCore.Game_Action_makeTargets.call(this);
      const _0x29769d = VisuMZ.BattleCore.createKeyJS(this.item(), "Targets");
      return (
        (targets = VisuMZ.BattleCore.JS[_0x29769d]["call"](
          this,
          this.subject(),
          targets
        )),
        this.repeatTargets(targets)
      );
    } else return null;
  }
  return this.makeTargetsBattleCore();
};

Game_Action.prototype.makeTargetsBattleCore = function () {
  let _0x25196f = [];
  const _0x25a2b7 = String(this.item()["scope"]);
  if (this.isForAnyoneFocusOpponents())
    return this.isSubjectValidForAnyoneSelect()
      ? ((_0x25196f = this.getBattlerKeyTargets()),
        this.repeatTargets(_0x25196f))
      : ((this._targetIndex = -1),
        _0x25196f.push(...this.targetsForOpponents()),
        this.repeatTargets(_0x25196f));
  if (this.isForAnyoneFocusFriends()) {
    if ("lRYBg" === "fCiHi")
      _0x314b9e.BattleCore.Window_BattleLog_displayEvasion.call(
        this,
        _0x4bf040
      );
    else {
      if (this.isSubjectValidForAnyoneSelect()) {
        if ("xoaNS" === "OBsez")
          (_0xfad1c0 += _0x485897.isActor() ? -_0x3a349d : _0x437395),
            (_0x2ab38c += _0x483f44.isActor() ? -_0x14a974 : _0x451ae9);
        else
          return (
            (_0x25196f = this.getBattlerKeyTargets()),
            this.repeatTargets(_0x25196f)
          );
      } else {
        if (Imported.VisuMZ_3_BattleAI) {
          if ("KeGIU" !== "KeGIU")
            return this.opponentsUnit()["trueRandomTarget"]();
          else {
            if (VisuMZ.BattleAI.version < 1.19) {
              if ("sVTDx" !== "sVTDx") {
                if (_0x4d0744.isNextScene(_0x408db5)) return true;
                return false;
              } else {
                let _0x2d3893 = "";
                (_0x2d3893 += "VisuMZ_3_BattleAI needs to be updated "),
                  (_0x2d3893 +=
                    "in order for Ally or Enemy targeting to work "),
                  (_0x2d3893 += "with latest version of VisuMZ_1_BattleCore!"),
                  alert(_0x2d3893),
                  SceneManager.exit();
              }
            }
          }
        }
        return (
          (this._targetIndex = -1),
          _0x25196f.push(...this.targetsForFriends()),
          this.repeatTargets(_0x25196f)
        );
      }
    }
  }
  if (_0x25a2b7.match(/(\d+) RANDOM ANY/i)) {
    let _0x2719b5 = Number(RegExp["$1"]);
    while (_0x2719b5--) {
      if ("abioL" === "PbzMG")
        (this._colorType = _0x3400b6.mpDamage >= 0 ? 2 : 3),
          this.createDigits(_0x37d164.mpDamage);
      else {
        const _0x91b075 =
          Math.randomInt(2) === 0 ? this.opponentsUnit() : this.friendsUnit();
        _0x25196f.push(_0x91b075.trueRandomTarget());
      }
    }
    return this.repeatTargets(_0x25196f);
  }
  if (_0x25a2b7.match(/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)) {
    let _0x21c2ef = Number(RegExp["$1"]);
    while (_0x21c2ef--) {
      if ("BWfTF" !== "BWfTF")
        return _0x5b3b4f.BattleCore.Settings.AutoBattle["AutoBattleRect"][
          "call"
        ](this);
      else _0x25196f.push(this.opponentsUnit()["trueRandomTarget"]());
    }
    return this.repeatTargets(_0x25196f);
  }
  if (_0x25a2b7.match(/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)) {
    if ("HbnOW" === "HbnOW") {
      let _0x2736ad = Number(RegExp["$1"]);
      while (_0x2736ad--) {
        _0x25196f.push(this.friendsUnit()["trueRandomTarget"]());
      }
      return this.repeatTargets(_0x25196f);
    } else _0x3257c7.BattleCore.Scene_Battle_stop.call(this);
  }
  if (
    _0x25a2b7.match(
      /ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i
    )
  ) {
    if ("uijPF" === "NlqGz") _0x325340.shadow = true;
    else
      return (
        _0x25196f.push(
          ...this.friendsUnit()
            .aliveMembers()
            .filter((_0x27b85d) => _0x27b85d !== this.subject())
        ),
        this.repeatTargets(_0x25196f)
      );
  }
  return VisuMZ.BattleCore.Game_Action_makeTargets.call(this);
};

Game_Action.prototype.randomTargets = function (_0x209a55) {
  const _0x4416cb = [];
  for (let _0x4c6685 = 0; _0x4c6685 < this.numTargets(); _0x4c6685++) {
    if ("dirpi" !== "FFKql") _0x4416cb.push(_0x209a55.trueRandomTarget());
    else {
      if (_0x65c0ad.isSceneBattle()) {
        const _0x38dedf = this.getAttackWeaponAnimationId();
        this.startWeaponAnimation(_0x38dedf);
      }
    }
  }
  return _0x4416cb;
};

Game_Action.prototype.applyTargetFilters = function (_0x57554e) {
  if (!this.item()) return _0x57554e;
  const _0x4a8fed = this.item()["note"];
  if (this.isForNotUser()) {
    if ("VkvER" !== "ElYHe") {
      if (this.isForAll()) {
        if ("zaqWi" !== "BMISA") _0x57554e.remove(this.subject());
        else {
          if (!this.isOptionsCommandAdded()) return;
          const _0x21009b = this.commandStyle();
          const _0x2161ea =
            _0x40da1d.BattleCore.Settings.PartyCmd["CmdIconOptions"];
          const _0x3b8f01 =
            _0x21009b === "text"
              ? _0x4ff2e9.options
              : "\\I[%1]%2".format(_0x2161ea, _0x272447.options);
          const _0x3c358b = this.isOptionsCommandEnabled();
          this.addCommand(_0x3b8f01, "options", _0x3c358b);
        }
      }
      if (_0x57554e.includes(this.subject())) {
        const _0x441264 = this.friendsUnit()
          .aliveMembers()
          ["remove"](this.subject());
        if (_0x441264.length > 0) {
          _0x441264.sort(
            (_0x3fb3d8, _0x505540) => _0x3fb3d8.hpRate() - _0x505540.hpRate()
          );
          while (_0x57554e.includes(this.subject())) {
            const _0x1efe78 = _0x57554e.indexOf(this.subject());
            _0x57554e[_0x1efe78] = _0x441264[Math.randomInt(_0x441264.length)];
          }
        } else _0x57554e.remove(this.subject());
      }
    } else {
      if (!_0x18dc21.isSceneBattle()) return;
      const _0x69d9a = _0x26928f._logWindow;
      _0x69d9a.refresh();
    }
  }
  return _0x57554e;
};

VisuMZ.BattleCore.Game_Action_itemEffectAddAttackState =
  Game_Action.prototype.itemEffectAddAttackState;

Game_Action.prototype.itemEffectAddAttackState = function (
  _0x383793,
  _0x27c5d6
) {
  VisuMZ.BattleCore.Game_Action_itemEffectAddAttackState.call(
    this,
    _0x383793,
    _0x27c5d6
  );
  if (!_0x383793.isImmortal()) return;
  for (const _0x1c829c of this.subject()["attackStates"]()) {
    if (_0x1c829c === _0x383793.deathStateId()) {
      if ("JuuLY" !== "PmSIQ") {
        let _0x22a2a3 = _0x27c5d6.value1;
        (_0x22a2a3 *= _0x383793.stateRate(_0x1c829c)),
          (_0x22a2a3 *= this.subject()["attackStatesRate"](_0x1c829c)),
          (_0x22a2a3 *= this.lukEffectRate(_0x383793));
        if (Math.random() < _0x22a2a3) {
          if ("umxhu" !== "jQBLf")
            (_0x383793._deathStateApplied = true), this.makeSuccess(_0x383793);
          else return;
        }
      } else return 1;
    }
  }
};

VisuMZ.BattleCore.Game_Action_itemEffectAddNormalState =
  Game_Action.prototype.itemEffectAddNormalState;

Game_Action.prototype.itemEffectAddNormalState = function (
  _0x570e36,
  _0x17816b
) {
  VisuMZ.BattleCore.Game_Action_itemEffectAddNormalState.call(
    this,
    _0x570e36,
    _0x17816b
  );
  if (!_0x570e36.isImmortal()) return;
  if (_0x17816b.dataId !== _0x570e36.deathStateId()) return;
  let _0x438603 = _0x17816b.value1;
  if (!this.isCertainHit()) {
    if ("kJZxW" !== "STPFx")
      (_0x438603 *= _0x570e36.stateRate(_0x17816b.dataId)),
        (_0x438603 *= this.lukEffectRate(_0x570e36));
    else
      return this.battlerSprites()["some"]((_0x28289b) =>
        _0x28289b.isSpinning()
      );
  }
  Math.random() < _0x438603 &&
    ((_0x570e36._deathStateApplied = true), this.makeSuccess(_0x570e36));
};

VisuMZ.BattleCore.Game_Action_applyGlobal = Game_Action.prototype.applyGlobal;

Game_Action.prototype.applyGlobal = function () {
  VisuMZ.BattleCore.Game_Action_applyGlobal.call(this),
    this.applyGlobalCommonEventNotetags(),
    this.resetResultSwitches();
};

Game_Action.prototype.applyGlobalCommonEventNotetags = function () {
  if (!SceneManager.isSceneBattle()) return;
  const _0x9fb8bc = /<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi;
  const _0x3ea1b9 = this.item()["note"]["match"](_0x9fb8bc);
  if (_0x3ea1b9) {
    if ("XwNbe" !== "iwSij")
      for (const _0x2404ef of _0x3ea1b9) {
        if (!_0x2404ef) continue;
        _0x2404ef.match(_0x9fb8bc);
        const _0x5dd881 = String(RegExp["$1"])
          ["split"](",")
          ["map"]((_0x9553b6) => String(_0x9553b6).trim());
        const _0x5d93df = _0x5dd881.map((_0x572753) =>
          DataManager.getCommonEventIdWithName(_0x572753)
        );
        for (const _0x1faba0 of _0x5d93df) {
          const _0x1554de = $dataCommonEvents[_0x1faba0];
          _0x1554de &&
            ("tYPgX" === "tYPgX"
              ? $gameTemp.reserveCommonEvent(_0x1faba0)
              : ((_0x142ee8 = (_0x40b926 + _0xa35d5e) / 2), (_0x4e6b35 = -1)));
        }
      }
    else
      _0x4a7770.BattleCore.Game_Party_addActor.call(this, _0x20977b),
        _0x618890.refreshStatusWindow();
  }
};

DataManager.getCommonEventIdWithName = function (_0x5e1002) {
  (_0x5e1002 = _0x5e1002.toUpperCase().trim()),
    (this._commonEventIDs = this._commonEventIDs || {});
  if (this._commonEventIDs[_0x5e1002]) return this._commonEventIDs[_0x5e1002];
  for (const _0x450492 of $dataCommonEvents) {
    if (!_0x450492) continue;
    let _0x534d59 = _0x450492.name;
    (_0x534d59 = _0x534d59.replace(/\x1I\[(\d+)\]/gi, "")),
      (_0x534d59 = _0x534d59.replace(/\\I\[(\d+)\]/gi, "")),
      (this._commonEventIDs[_0x534d59.toUpperCase().trim()] = _0x450492.id);
  }
  return this._commonEventIDs[_0x5e1002] || 0;
};

Game_Action.prototype.resetResultSwitches = function () {
  if (!SceneManager.isSceneBattle()) return;
  const _0x58602f = VisuMZ.BattleCore.Settings.Mechanics;
  _0x58602f.SwitchCritical &&
    $gameSwitches.setValue(_0x58602f.SwitchCritical, false);
  _0x58602f.SwitchMissEvade &&
    ("WsfhR" === "WsfhR"
      ? $gameSwitches.setValue(_0x58602f.SwitchMissEvade, false)
      : (_0x3f6499.forceMotion(_0x265934),
        ["swing", "thrust", "missile"]["includes"](_0x390a49) &&
          this.performWeaponAnimation()));
  if (_0x58602f.VariableDmg) {
    if ("qxFQQ" === "qxFQQ") $gameVariables.setValue(_0x58602f.VariableDmg, 0);
    else {
      if (!_0x25963f.checkSceneBattleTransitionable(_0x2ac0b2))
        return this.displayBattleCoreTransitionErrorMsg(_0x4433a9);
      _0x5eb1da.BattleCore.SceneManager_push.call(this, _0x9c31f7);
    }
  }
  _0x58602f.VariableHeal && $gameVariables.setValue(_0x58602f.VariableHeal, 0);
};

Game_Action.prototype.applyResultSwitches = function (_0x315976) {
  if (!SceneManager.isSceneBattle()) return;
  if (!_0x315976) return;
  const _0x69fe64 = _0x315976.result();
  const _0x6dc9b8 = VisuMZ.BattleCore.Settings.Mechanics;
  _0x6dc9b8.SwitchCritical &&
    _0x69fe64.critical &&
    $gameSwitches.setValue(_0x6dc9b8.SwitchCritical, true);
  if (_0x6dc9b8.SwitchMissEvade && (_0x69fe64.missed || _0x69fe64.evaded)) {
    if ("ozrII" !== "hPrhF")
      $gameSwitches.setValue(_0x6dc9b8.SwitchMissEvade, true);
    else {
      if (!this._battler) return;
      (this._shadowScaleX = this._battler.battlerShadowScaleX()),
        (this._shadowScaleY = this._battler.battlerShadowScaleY());
    }
  }
  if (_0x6dc9b8.VariableDmg) {
    if ("jixwJ" !== "jixwJ") {
      const _0x86b3db = this.isOnCurrentMap() ? this._eventId : 0;
      const _0x385d9c = _0x57fa39.list;
      this.setupChild(_0x385d9c, _0x86b3db),
        (this._list = _0x269ea4.makeDeepCopy(this._list));
      const _0xfff9f3 = {
        code: 3011,
        indent: this._indent,
        parameters: _0x654f32.makeDeepCopy(_0x3280af),
      };
      return this._list.splice(this._index + 1, 0, _0xfff9f3), true;
    } else {
      let _0x5e4683 = $gameVariables.value(_0x6dc9b8.VariableDmg);
      _0x69fe64.hpDamage > 0 && (_0x5e4683 += Math.abs(_0x69fe64.hpDamage)),
        $gameVariables.setValue(_0x6dc9b8.VariableDmg, _0x5e4683);
    }
  }
  if (_0x6dc9b8.VariableHeal) {
    if ("KCogN" !== "ybBmd") {
      let _0x45ccda = $gameVariables.value(_0x6dc9b8.VariableHeal);
      _0x69fe64.hpDamage < 0 &&
        ("jRnQi" === "jRnQi"
          ? (_0x45ccda += Math.abs(_0x69fe64.hpDamage))
          : ((_0x361d7e += _0x17b4ee),
            (_0x1fe54e += _0x11cfa4.isActor() ? -_0x3ddc7e : _0x281487))),
        $gameVariables.setValue(_0x6dc9b8.VariableHeal, _0x45ccda);
    } else {
      const _0x4148dc = this.weapons();
      if (_0x4148dc.length > 0) {
        const _0x15d846 = _0x4148dc[_0x33fe08];
        if (_0x15d846) _0x18d929 = this.equips()["indexOf"](_0x15d846);
      }
    }
  }
};

VisuMZ.BattleCore.LifeStealRegExp = {
  lifeSteaItem: /<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,
  lifeStealTrait: /<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,
  cancelLifeSteal: /<CANCEL LIFE STEAL>/i,
  cancelHpLifeSteal: /<CANCEL HP LIFE STEAL>/i,
  cancelMpLifeSteal: /<CANCEL MP LIFE STEAL>/i,
  guardLifeSteal: /<GUARD LIFE STEAL>/i,
  guardHpLifeSteal: /<GUARD HP LIFE STEAL>/i,
  guardMpLifeSteal: /<GUARD MP LIFE STEAL>/i,
  disarmLifeSteal: /<DISARM LIFE STEAL>/i,
  disarmHpLifeSteal: /<DISARM HP LIFE STEAL>/i,
  disarmMpLifeSteal: /<DISARM MP LIFE STEAL>/i,
  negativeLifeSteal: /<REVERSE LIFE STEAL>/i,
  negativeHpLifeSteal: /<REVERSE HP LIFE STEAL>/i,
  negativeMpLifeSteal: /<REVERSE MP LIFE STEAL>/i,
};

VisuMZ.BattleCore.Game_Action_executeHpDamage =
  Game_Action.prototype.executeHpDamage;

Game_Action.prototype.executeHpDamage = function (_0x3520ac, _0x18cf5a) {
  VisuMZ.BattleCore.Game_Action_executeHpDamage.call(
    this,
    _0x3520ac,
    _0x18cf5a
  );
  if (!this.isDrain() && _0x3520ac && _0x3520ac.result()["hpDamage"] > 0) {
    if ("ywjIK" === "iahpe") {
      _0x10c4e4("Action Sequence Impact needs an update!"), _0x1d48d8.exit();
      return;
    } else
      this.performLifeSteal("HP", _0x3520ac, _0x3520ac.result()["hpDamage"]);
  }
  if (_0x3520ac) {
    if ("RUutb" === "HzmwX") {
      const _0x47bc8e = _0x511ad4.BattleCore.Settings.BattleLayout;
      if (_0x47bc8e.StatusWindowSelectableBackHide) return;
      _0x1292c8.prototype.drawItemBackground.call(this, _0x5e883c);
    } else {
      this._executeHpDamage = this._executeHpDamage || {};
      const _0x58e618 = _0x3520ac.battlerKey();
      this._executeHpDamage[_0x58e618] = _0x18cf5a;
    }
  }
};

Game_Action.prototype.getLastHpDamage = function (_0x1bc026) {
  this._executeHpDamage = this._executeHpDamage || {};
  const _0x5ed52d = _0x1bc026.battlerKey();
  return this._executeHpDamage[_0x5ed52d] || 0;
};

VisuMZ.BattleCore.Game_Action_executeMpDamage =
  Game_Action.prototype.executeMpDamage;

Game_Action.prototype.executeMpDamage = function (_0x25a5b3, _0x40a21a) {
  VisuMZ.BattleCore.Game_Action_executeMpDamage.call(
    this,
    _0x25a5b3,
    _0x40a21a
  );
  if (!this.isDrain() && _0x25a5b3 && _0x25a5b3.result()["mpDamage"] > 0) {
    if ("VhyoC" === "NrzDH") return this.skillItemWindowRectBorderStyle();
    else this.performLifeSteal("MP", _0x25a5b3, _0x25a5b3.result()["mpDamage"]);
  }
};

Game_Action.prototype.performLifeSteal = function (
  _0x798b08,
  _0x5f5c37,
  _0xb003ee
) {
  _0x798b08 = _0x798b08.toUpperCase().trim();
  const _0x59a7d6 = this.lifeStealRate(_0x798b08, _0x5f5c37);
  if (_0x59a7d6 <= 0) return;
  const _0x1f8113 = Math.round(_0xb003ee * _0x59a7d6);
  if (_0x1f8113 <= 0) return;
  let _0x2efc32 = this.subject();
  if (this._reflectionTarget) _0x2efc32 = this._reflectionTarget;
  const _0x427806 = _0x5f5c37.isNegativeLifeSteal(_0x798b08) ? -1 : 1;
  if (_0x798b08 === "HP") _0x2efc32.gainHp(_0x427806 * _0x1f8113);
  if (_0x798b08 === "MP") _0x2efc32.gainMp(_0x427806 * _0x1f8113);
};

Game_Action.prototype.lifeStealRate = function (_0xc22953, _0x35f985) {
  if (this.isCancelLifeSteal(_0xc22953)) return 0;
  if (this.subject()["isDisarmLifeSteal"](_0xc22953)) return 0;
  if (_0x35f985.isGuardLifeSteal(_0xc22953)) return 0;
  let _0x5bb05a = 0;
  return (
    (_0x5bb05a += this.itemLifeStealRate(_0xc22953)),
    (_0x5bb05a += this.subject()["lifeStealRate"](
      _0xc22953,
      this.item()["hitType"]
    )),
    _0x5bb05a.clamp(0, 1)
  );
};

Game_Action.prototype.isCancelLifeSteal = function (_0x37dfe1) {
  _0x37dfe1 = _0x37dfe1.toUpperCase().trim();
  const _0x69319a = VisuMZ.BattleCore.LifeStealRegExp;
  const _0x5421c9 = this.item()["note"] || "";
  if (_0x5421c9.match(_0x69319a.cancelLifeSteal)) return true;
  if (_0x37dfe1 === "HP" && _0x5421c9.match(_0x69319a.cancelHpLifeSteal))
    return true;
  if (_0x37dfe1 === "MP" && _0x5421c9.match(_0x69319a.cancelMpLifeSteal))
    return true;
  return false;
};

Game_Action.prototype.itemLifeStealRate = function (_0x578b90) {
  const _0x4bff81 = VisuMZ.BattleCore.LifeStealRegExp;
  const _0x5204f1 = this.item()["note"] || "";
  _0x578b90 = _0x578b90.toUpperCase().trim();
  const _0x3782e7 = _0x5204f1.match(_0x4bff81.lifeSteaItem);
  if (_0x3782e7)
    for (const _0x3fe4df of _0x3782e7) {
      if ("pkqpM" !== "pkqpM") return this.isActionSelectionValid();
      else {
        _0x3fe4df.match(_0x4bff81.lifeSteaItem);
        const _0x2c9b89 = String(RegExp["$1"])["toUpperCase"]().trim();
        const _0x54d614 = Number(RegExp["$2"]) * 0.01;
        if (_0x2c9b89 !== _0x578b90) continue;
        return _0x54d614;
      }
    }
  return 0;
};

Game_BattlerBase.prototype.lifeStealRate = function (_0x337ce3, _0x4e1428) {
  const _0x4dc6f2 = VisuMZ.BattleCore.LifeStealRegExp;
  let _0x390e77 = 0;
  _0x337ce3 = _0x337ce3.toUpperCase().trim();
  for (const _0x2fb0f6 of this.traitObjects()) {
    if (!_0x2fb0f6) continue;
    const _0x9e35b7 = _0x2fb0f6.note || "";
    const _0x348fe8 = _0x9e35b7.match(_0x4dc6f2.lifeStealTrait);
    if (_0x348fe8) {
      if ("hYBKB" !== "aPiKC")
        for (const _0x9c1bbf of _0x348fe8) {
          _0x9c1bbf.match(_0x4dc6f2.lifeStealTrait);
          const _0x29b8fb = String(RegExp["$1"])["toUpperCase"]().trim();
          const _0x294e3e = String(RegExp["$2"]);
          const _0x57ef6c = Number(RegExp["$3"]) * 0.01;
          if (_0x29b8fb !== _0x337ce3) continue;
          if (
            _0x4e1428 === Game_Action.HITTYPE_CERTAIN &&
            _0x294e3e.match(/CERTAIN/i)
          ) {
            if ("CSQpZ" === "CSQpZ") _0x390e77 += _0x57ef6c;
            else {
              if (_0x3a443f.value(_0x1853ae)) return false;
            }
          } else {
            if (
              _0x4e1428 === Game_Action.HITTYPE_PHYSICAL &&
              _0x294e3e.match(/PHYS/i)
            )
              "wcJOa" === "wcJOa"
                ? (_0x390e77 += _0x57ef6c)
                : (this._battleBalloonSprites = []);
            else
              _0x4e1428 === Game_Action.HITTYPE_MAGICAL &&
                _0x294e3e.match(/MAGIC/i) &&
                (_0x390e77 += _0x57ef6c);
          }
        }
      else _0x5b54ee.addState(_0x552355);
    }
  }
  return _0x390e77;
};

Game_BattlerBase.prototype.isDisarmLifeSteal = function (_0x5bc183) {
  _0x5bc183 = _0x5bc183.toUpperCase().trim();
  const _0x3e16a0 = VisuMZ.BattleCore.LifeStealRegExp;
  for (const _0x1bf3a4 of this.traitObjects()) {
    if (!_0x1bf3a4) continue;
    const _0x251208 = _0x1bf3a4.note || "";
    if (_0x251208.match(_0x3e16a0.disarmLifeSteal)) return true;
    if (_0x5bc183 === "HP" && _0x251208.match(_0x3e16a0.disarmHpLifeSteal))
      return true;
    if (_0x5bc183 === "MP" && _0x251208.match(_0x3e16a0.disarmMpLifeSteal))
      return true;
  }
  return false;
};

Game_BattlerBase.prototype.isNegativeLifeSteal = function (_0x47c145) {
  _0x47c145 = _0x47c145.toUpperCase().trim();
  const _0x12f4a2 = VisuMZ.BattleCore.LifeStealRegExp;
  for (const _0x44b6fc of this.traitObjects()) {
    if (!_0x44b6fc) continue;
    const _0x195253 = _0x44b6fc.note || "";
    if (_0x195253.match(_0x12f4a2.negativeLifeSteal))
      return "WFgXV" === "WFgXV"
        ? true
        : this._distortionSprite || this._mainSprite || this;
    if (_0x47c145 === "HP" && _0x195253.match(_0x12f4a2.negativeHpLifeSteal))
      return true;
    if (_0x47c145 === "MP" && _0x195253.match(_0x12f4a2.negativeMpLifeSteal))
      return true;
  }
  return false;
};

Game_BattlerBase.prototype.isGuardLifeSteal = function (_0x213230) {
  _0x213230 = _0x213230.toUpperCase().trim();
  const _0x3f85bd = VisuMZ.BattleCore.LifeStealRegExp;
  for (const _0x384df3 of this.traitObjects()) {
    if ("fNCuQ" === "fNCuQ") {
      if (!_0x384df3) continue;
      const _0x154d07 = _0x384df3.note || "";
      if (_0x154d07.match(_0x3f85bd.guardLifeSteal)) return true;
      if (_0x213230 === "HP" && _0x154d07.match(_0x3f85bd.guardHpLifeSteal))
        return true;
      if (_0x213230 === "MP" && _0x154d07.match(_0x3f85bd.guardMpLifeSteal))
        return true;
    } else {
      const _0x5b7d68 = _0xffb5ec.inputtingAction();
      if (_0x5b7d68) _0x5b7d68.setTargetBattlerKey("all actors");
      this.processOk();
    }
  }
  return false;
};

VisuMZ.BattleCore.Game_BattlerBase_initMembers =
  Game_BattlerBase.prototype.initMembers;

Game_BattlerBase.prototype.initMembers = function () {
  VisuMZ.BattleCore.Game_BattlerBase_initMembers.call(this),
    this.initMembersBattleCore();
};

Game_BattlerBase.prototype.initMembersBattleCore = function () {
  this._immortal = false;
};

VisuMZ.BattleCore.Game_BattlerBase_refresh = Game_BattlerBase.prototype.refresh;

Game_BattlerBase.prototype.refresh = function () {
  (this._cache = {}), VisuMZ.BattleCore.Game_BattlerBase_refresh.call(this);
};

Game_BattlerBase.prototype.checkCacheKey = function (_0x377cc5) {
  return (
    (this._cache = this._cache || {}), this._cache[_0x377cc5] !== undefined
  );
};

Game_BattlerBase.prototype.hardDamageCap = function () {
  if (this._cache.hardDamageCap !== undefined) return this._cache.hardDamageCap;
  const _0x56627d = /<DAMAGE CAP:[ ](\d+)>/i;
  const _0x1aec46 = this.traitObjects()["map"]((_0x574f9e) =>
    _0x574f9e && _0x574f9e.note.match(_0x56627d) ? Number(RegExp["$1"]) : 0
  );
  let _0x1d02b3 = _0x1aec46.length > 0 ? Math.max(..._0x1aec46) : 0;
  if (_0x1d02b3 <= 0)
    _0x1d02b3 = VisuMZ.BattleCore.Settings.Damage["DefaultHardCap"];
  return (this._cache.hardDamageCap = _0x1d02b3), this._cache.hardDamageCap;
};

Game_BattlerBase.prototype.softDamageCapRate = function () {
  if (this._cache.softDamageCap !== undefined) return this._cache.softDamageCap;
  let _0x51b15a = VisuMZ.BattleCore.Settings.Damage["DefaultSoftCap"];
  const _0x2f3da9 = /<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i;
  const _0xdb7bb = this.traitObjects()["map"]((_0x57725c) =>
    _0x57725c && _0x57725c.note.match(_0x2f3da9)
      ? Number(RegExp["$1"]) / 100
      : 0
  );
  return (
    (_0x51b15a = _0xdb7bb.reduce(
      (_0x41a99f, _0x3d6037) => _0x41a99f + _0x3d6037,
      _0x51b15a
    )),
    (this._cache.softDamageCap = _0x51b15a),
    this._cache.softDamageCap.clamp(0.01, 1)
  );
};

VisuMZ.BattleCore.Game_BattlerBase_die = Game_BattlerBase.prototype.die;

Game_BattlerBase.prototype.die = function () {
  VisuMZ.BattleCore.Game_BattlerBase_die.call(this),
    SceneManager.isSceneBattle() &&
      (this.requestMotion("dead"), (this._performDamageMotion = undefined));
};

Game_BattlerBase.prototype.battler = function () {
  // SRPG_core_MZと競合するため無効化
  // if (!SceneManager.isSceneBattle()) return null;
  if (!SceneManager._scene._spriteset) return null;
  return SceneManager._scene._spriteset.findTargetSprite(this);
};

Game_BattlerBase.prototype.svBattlerAnchorX = function () {
  return VisuMZ.BattleCore.Settings.Actor["AnchorX"];
};

Game_BattlerBase.prototype.svBattlerAnchorY = function () {
  return VisuMZ.BattleCore.Settings.Actor["AnchorY"];
};

Game_BattlerBase.prototype.svBattlerShadowVisible = function () {
  if (this.isActor && this.isActor()) {
    if ("xnyPM" === "nMPcg") _0x177edd.setWaitMode("cutinExit");
    else return VisuMZ.BattleCore.Settings.Actor["Shadow"];
  } else return VisuMZ.BattleCore.Settings.Enemy["Shadow"];
};

Game_BattlerBase.prototype.battlerSmoothImage = function () {
  return true;
};

Game_BattlerBase.prototype.battleUIOffsetX = function () {
  return 0;
};

Game_BattlerBase.prototype.battleUIOffsetY = function () {
  return 0;
};

Game_BattlerBase.prototype.createBattleUIOffsetX = function (_0x564b85) {
  if (!_0x564b85) return 0;
  let _0x4399fe = 0;
  const _0x4b43cf = _0x564b85.note;
  return (
    _0x4b43cf.match(/<BATTLE UI OFFSET X:[ ]([\+\-]\d+)>/i) &&
      (_0x4399fe += Number(RegExp["$1"])),
    _0x4b43cf.match(/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i) &&
      (_0x4399fe += Number(RegExp["$1"])),
    _0x4399fe
  );
};

Game_BattlerBase.prototype.createBattleUIOffsetY = function (_0x5b0637) {
  if (!_0x5b0637) return 0;
  let _0x49729b = 0;
  const _0x18dfdf = _0x5b0637.note;
  return (
    _0x18dfdf.match(/<BATTLE UI OFFSET Y:[ ]([\+\-]\d+)>/i) &&
      (_0x49729b += Number(RegExp["$1"])),
    _0x18dfdf.match(/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i) &&
      ("qhtaa" === "gDlVW"
        ? this.setHandler("pagedown", this.selectAllActors.bind(this))
        : (_0x49729b += Number(RegExp["$2"]))),
    _0x49729b
  );
};

VisuMZ.BattleCore.Game_BattlerBase_isStateResist =
  Game_BattlerBase.prototype.isStateResist;

Game_BattlerBase.prototype.isStateResist = function (_0x1fcd94) {
  if (_0x1fcd94 === this.deathStateId() && this.isImmortal()) return true;
  return VisuMZ.BattleCore.Game_BattlerBase_isStateResist.call(this, _0x1fcd94);
};

Game_BattlerBase.prototype.isImmortal = function () {
  return this._immortal;
};

Game_BattlerBase.prototype.setImmortal = function (_0x575f8b) {
  _0x575f8b ? this.addImmortal() : this.removeImmortal();
};

Game_BattlerBase.prototype.addImmortal = function () {
  if (this.isDead()) return;
  (this._immortal = true), (this._deathStateApplied = false);
};

Game_BattlerBase.prototype.removeImmortal = function () {
  const _0x5baafe = this.isAlive();
  (this._immortal = false),
    _0x5baafe && this._deathStateApplied && this.die(),
    (this._deathStateApplied = false),
    this.refresh(),
    this.isDead() &&
      _0x5baafe &&
      (this.performCollapse(), this.requestMotionRefresh());
};

VisuMZ.BattleCore.Game_Action_numRepeats = Game_Action.prototype.numRepeats;

Game_Action.prototype.numRepeats = function () {
  return this.item() ? VisuMZ.BattleCore.Game_Action_numRepeats.call(this) : 0;
};

VisuMZ.BattleCore.Game_Action_setAttack = Game_Action.prototype.setAttack;

Game_Action.prototype.setAttack = function () {
  this.subject() && this.subject()["canAttack"]()
    ? "fYzaA" === "fYzaA"
      ? VisuMZ.BattleCore.Game_Action_setAttack.call(this)
      : ((this._targetAngle = 0), (this._currentAngle = 0))
    : this.clear();
};

VisuMZ.BattleCore.Game_BattlerBase_canAttack =
  Game_BattlerBase.prototype.canAttack;

Game_BattlerBase.prototype.canAttack = function () {
  if (!this.canAttackBattleCore()) return false;
  return VisuMZ.BattleCore.Game_BattlerBase_canAttack.call(this);
};

Game_BattlerBase.prototype.canAttackBattleCore = function () {
  for (const _0x37ff17 of this.traitObjects()) {
    if ("kGMBg" === "kqvFe")
      return _0x3ee843.VisuMZ_0_CoreEngine
        ? _0xce48be.getInputButtonString("ok")
        : _0x1c53ba.BattleCore.Settings.AutoBattle["AutoBattleOK"];
    else {
      if (!_0x37ff17) continue;
      if (_0x37ff17.note.match(/<(?:ATTACK SEAL|SEAL ATTACK)>/i)) return false;
    }
  }
  return true;
};

VisuMZ.BattleCore.Game_Action_setGuard = Game_Action.prototype.setGuard;

Game_Action.prototype.setGuard = function () {
  this.subject()["canGuard"]() &&
    VisuMZ.BattleCore.Game_Action_setGuard.call(this);
};

VisuMZ.BattleCore.Game_BattlerBase_canGuard =
  Game_BattlerBase.prototype.canGuard;

Game_BattlerBase.prototype.canGuard = function () {
  if (!this.canGuardBattleCore()) return false;
  return VisuMZ.BattleCore.Game_BattlerBase_canGuard.call(this);
};

Game_BattlerBase.prototype.canGuardBattleCore = function () {
  for (const _0x151a86 of this.traitObjects()) {
    if ("DSwRA" === "lWZjW")
      _0x2121bd.BattleGridSystem.ActSeq_Grid_AnimationIDAtNode(_0x12e3f5);
    else {
      if (!_0x151a86) continue;
      if (_0x151a86.note.match(/<(?:GUARD SEAL|SEAL GUARD)>/i)) return false;
    }
  }
  return true;
};

Game_BattlerBase.prototype.canUseItemCommand = function () {
  for (const _0x257638 of this.traitObjects()) {
    if (!_0x257638) continue;
    if (_0x257638.note.match(/<(?:ITEM SEAL|SEAL ITEM|SEAL ITEMS)>/i))
      return false;
  }
  return true;
};

VisuMZ.BattleCore.Game_BattlerBase_meetsUsableItemConditions =
  Game_BattlerBase.prototype.meetsUsableItemConditions;

Game_BattlerBase.prototype.meetsUsableItemConditions = function (_0x542016) {
  if (_0x542016 && _0x542016.note.match(/<CANNOT TARGET (?:USER|SELF)>/i)) {
    const _0x551ab1 = this.friendsUnit().aliveMembers();
    if (_0x551ab1.length === 1 && _0x551ab1[0] === this) return false;
  }
  return VisuMZ.BattleCore.Game_BattlerBase_meetsUsableItemConditions.call(
    this,
    _0x542016
  );
};

Game_Battler.prototype.allowRandomSpeed = function () {
  return VisuMZ.BattleCore.Settings.Mechanics["AllowRandomSpeed"];
};

VisuMZ.BattleCore.Game_Battler_regenerateAll =
  Game_Battler.prototype.regenerateAll;

Game_Battler.prototype.regenerateAll = function () {
  if (SceneManager.isSceneBattle()) {
    if ("KuDvh" === "tCclp")
      this.placeGauge(
        _0x2bc606,
        "tp",
        _0x251f53 + 136 * 2 + (_0x4b1342.TpGaugeOffsetX || 0),
        _0x41cf03 + (_0x13e132.TpGaugeOffsetY || 0)
      );
    else {
      if (BattleManager.isTpb()) {
        if (this.turnCount() <= 0) return;
      } else {
        if ($gameTroop.turnCount() <= 0) {
          if ("JLold" === "JLold") return;
          else
            (this._enemies = this.validTargets()),
              this.sortEnemies(),
              _0x900118.prototype.refresh.call(this);
        }
      }
    }
  }
  if (
    SceneManager.isSceneBattle() &&
    BattleManager.isTpb() &&
    this._lastRegenFrameCount === Graphics.frameCount
  ) {
    if ("pJIhb" !== "pJIhb")
      _0x2c1f25.BattleCore.Settings.HpGauge["ShowEnemyGauge"] &&
        this.createHpGaugeSprite(),
        _0x53505c.BattleCore.Sprite_Enemy_createStateIconSprite.call(this);
    else return;
  }
  this._lastRegenFrameCount = Graphics.frameCount;
  if (SceneManager.isSceneBattle()) {
    if ("JeJxt" === "JeJxt") this.processBattleCoreJS("PreRegenerateJS");
    else {
      return;
      this._effectsContainer &&
        ((this._effectsContainer.x = this.x),
        (this._effectsContainer.y = this.y)),
        this._damageContainer &&
          ((this._damageContainer.x = this.x),
          (this._damageContainer.y = this.y));
    }
  }
  VisuMZ.BattleCore.Game_Battler_regenerateAll.call(this);
  if (SceneManager.isSceneBattle()) {
    if ("BiPVG" === "ZCKas") {
      const _0x1efe62 =
        _0x1990b8.x + _0x5d7214.floor((_0x92c69a.width - _0x556879) / 2);
      this.drawTextEx(_0x132db8, _0x1efe62, _0x5b0bd6.y, _0x45801c);
    } else
      this.regenerateAllBattleCore(),
        this.processBattleCoreJS("PostRegenerateJS");
  }
};

Game_Battler.prototype.regenerateAllBattleCore = function () {
  if (SceneManager.isSceneBattle()) {
    if ("eqNmy" === "eqNmy")
      for (const _0x376d01 of this.traitObjects()) {
        if (!_0x376d01) continue;
        this.onRegeneratePlayStateAnimation(_0x376d01);
      }
    else {
      if (this._targetBattlerKey === "all actors")
        return _0x197bd0.BattleCore.Game_Action_isForDeadFriend.call(this);
      return _0x5c7a15.BattleCore.Game_Action_isForDeadFriend.call(this);
    }
  }
};

Game_Battler.prototype.onRegeneratePlayStateAnimation = function (_0x50fc88) {
  if (!Imported.VisuMZ_0_CoreEngine) return;
  if (!SceneManager.isSceneBattle()) return;
  if (this.isDead()) return;
  if (this.isHidden()) return;
  if (
    _0x50fc88.note.match(
      /<(?:REGENERATE|REGEN|DEGEN|DOT|SLIP)[ ]ANIMATION:[ ](\d+)>/i
    )
  ) {
    const _0x509774 = Number(RegExp["$1"]);
    $gameTemp.requestFauxAnimation([this], _0x509774, false, false);
  }
};

VisuMZ.BattleCore.Game_Battler_startTpbTurn =
  Game_Battler.prototype.startTpbTurn;

Game_Battler.prototype.startTpbTurn = function () {
  this.processBattleCoreJS("PreStartTurnJS"),
    VisuMZ.BattleCore.Game_Battler_startTpbTurn.call(this),
    this.processBattleCoreJS("PostStartTurnJS");
};

VisuMZ.BattleCore.Game_Battler_onTurnEnd = Game_Battler.prototype.onTurnEnd;

Game_Battler.prototype.onTurnEnd = function () {
  this.processBattleCoreJS("PreEndTurnJS"),
    VisuMZ.BattleCore.Game_Battler_onTurnEnd.call(this),
    VisuMZ.BattleCore.Settings.Mechanics["SyncBuffExpire"] &&
      this.removeBuffsAuto(),
    this.processBattleCoreJS("PostEndTurnJS");
};

Game_Battler.prototype.processBattleCoreJS = function (_0x1e6870) {
  if (this._tempBattler || this._tempActor) return;
  const _0x1f520d = VisuMZ.BattleCore.Settings.Mechanics;
  if (_0x1f520d[_0x1e6870]) _0x1f520d[_0x1e6870]["call"](this);
  for (const _0x118b1a of this.traitObjects()) {
    if (!_0x118b1a) continue;
    key = VisuMZ.BattleCore.createKeyJS(_0x118b1a, _0x1e6870);
    if (VisuMZ.BattleCore.JS[key]) {
      const _0x21bc11 = this.battleLayoutStyle();
      if (["xp"].includes(_0x21bc11) && !_0x325678.isSideView()) {
        this.setCursorRect(0, 0, 0, 0);
        return;
      }
      _0x4086d4.prototype.refreshCursor.call(this);
    }
  }
};

Game_Battler.prototype.chantStyle = function () {
  return VisuMZ.BattleCore.Settings.Actor["ChantStyle"] || false;
};

Game_Battler.prototype.isChanting = function () {
  if (this.isWaiting()) {
    if (this.chantStyle()) {
      if ("rPFWL" === "rPFWL") {
        if (
          this._actions.some(
            (_0x2d954c) => _0x2d954c.item() && _0x2d954c.isMagical()
          )
        ) {
          return true;
        }
      } else return this.basicGaugesY(_0x2e786b) - this.gaugeLineHeight();
    } else {
      if ("HwcEB" === "BleIK") this.startMotion("walk");
      else {
        if (
          this._actions.some(
            (_0x174942) => _0x174942.item() && _0x174942.isMagicSkill()
          )
        ) {
          if ("Alpra" !== "PzvbO") return true;
          else {
            const _0x49a930 = "\\I[%1]%2";
            let _0x58b8a0 = _0x18d601.iconIndex;
            let _0x270c82 = _0x3b04d4.name;
            const _0xc20c01 = _0x4508ae.note;
            return (
              _0xc20c01.match(/<DISPLAY ICON: (\d+)>/i) &&
                (_0x58b8a0 = _0x829b4a(_0x47da4d["$1"])),
              _0xc20c01.match(/<DISPLAY TEXT: (.*)>/i) &&
                (_0x270c82 = _0x54c327(_0x25fcef["$1"])),
              _0x49a930.format(_0x58b8a0, _0x270c82)
            );
          }
        }
      }
    }
  }
  if (BattleManager.isTpb() && this._tpbState === "casting") {
    if ("RcUjV" === "jEnCD")
      this._battleField.addChild(this._animationContainer);
    else {
      if (this.chantStyle())
        return (
          this.currentAction() &&
          this.currentAction()["item"]() &&
          this.currentAction()["isMagical"]()
        );
      else {
        if ("AbiHz" === "AbiHz")
          return (
            this.currentAction() &&
            this.currentAction()["item"]() &&
            this.currentAction()["isMagicSkill"]()
          );
        else _0x476382.performAttack();
      }
    }
  }
  return false;
};

Game_Battler.prototype.isCharging = function () {
  if (BattleManager.isTpb() && this._tpbState === "casting") {
    if (this.chantStyle())
      return (
        this.currentAction() &&
        this.currentAction()["item"]() &&
        !this.currentAction()["isMagical"]()
      );
    else {
      if ("QhwOA" !== "QhwOA") {
        _0x555f04 &&
          _0x4e0472 &&
          _0x37f4b8.note &&
          this.parseForcedGameTroopSettingsBattleCore(_0x411e57.note);
        const _0x2bb9c9 = _0x4105be[_0x1825d0];
        if (_0x2bb9c9) {
          let _0x47a2d9 = _0x4562a8.createTroopNote(_0x2bb9c9.id);
          this.parseForcedGameTroopSettingsBattleCore(_0x47a2d9);
        }
      } else
        return (
          this.currentAction() &&
          this.currentAction()["item"]() &&
          !this.currentAction()["isMagicSkill"]()
        );
    }
  }
  return false;
};

Game_Battler.prototype.notFocusValid = function () {
  if (this.isHidden()) return false;
  if (this.isAlive() && this.isAppeared()) return true;
  if (this.isEnemy() && this.hasSvBattler()) {
    if (this.isDead() && this.allowCollapse()) return false;
  } else {
    if (this.isDead()) return false;
  }
  return true;
};

VisuMZ.BattleCore.Game_Battler_clearMotion = Game_Battler.prototype.clearMotion;

Game_Battler.prototype.clearMotion = function () {
  VisuMZ.BattleCore.Game_Battler_clearMotion.call(this),
    this.clearFreezeMotion();
};

Game_Battler.prototype.canBattlerMove = function () {
  return true;
};

Game_Battler.prototype.isBattlerGrounded = function () {
  return false;
};

VisuMZ.BattleCore.Game_Battler_onBattleStart =
  Game_Battler.prototype.onBattleStart;

Game_Battler.prototype.onBattleStart = function (_0x6fa4c8) {
  VisuMZ.BattleCore.Game_Battler_onBattleStart.call(this, _0x6fa4c8);
  this.onBattleStartBattleCore(_0x6fa4c8);
};

Game_Battler.prototype.onBattleStartBattleCore = function (_0x15dc3f) {
  this.setBattlerFlip(false),
    (this._forcedHomeX = undefined),
    (this._forcedHomeY = undefined);
};

VisuMZ.BattleCore.Game_Battler_onBattleEnd = Game_Battler.prototype.onBattleEnd;

Game_Battler.prototype.onBattleEnd = function () {
  VisuMZ.BattleCore.Game_Battler_onBattleEnd.call(this),
    this.onBattleEndBattleCore();
};

Game_Battler.prototype.onBattleEndBattleCore = function () {
  (this._forcedHomeX = undefined), (this._forcedHomeY = undefined);
};

VisuMZ.BattleCore.Game_Battler_performActionStart =
  Game_Battler.prototype.performActionStart;

Game_Battler.prototype.performActionStart = function (_0x1546b6) {
  VisuMZ.BattleCore.Game_Battler_performActionStart.call(this, _0x1546b6);
  if (!_0x1546b6.isGuard()) {
    const _0x298e3e = this.battler();
    if (_0x298e3e) {
      if ("JGWvA" === "HyeIF") {
        const _0x4ccce1 = _0x38bb17[this._actor.guardSkillId()];
        if (!_0x4ccce1) return;
        if (!this.canAddSkillCommand(_0x4ccce1)) return;
        const _0x7b553e = this.commandStyle();
        const _0x4576e0 = _0x22e8d3.battleCommandName(_0x4ccce1);
        const _0x2db811 = _0x21b5f2.battleCommandIcon(_0x4ccce1);
        const _0x5aebb0 =
          _0x7b553e === "text"
            ? _0x4576e0
            : "\\I[%1]%2".format(_0x2db811, _0x4576e0);
        this.addCommand(_0x5aebb0, "guard", this._actor.canGuard());
      } else _0x298e3e.stepForward();
    }
  }
  this.setBattlerFlip(false);
};

Game_Battler.prototype.performActionEndMembers = function () {
  const _0x209287 = this._flinched;
  this._flinched = false;
  if (BattleManager.isActiveTpb() && this.isInputting()) {
    const _0x535396 = this.battler();
    if (_0x535396 && _0x209287) _0x535396.stepForward();
    return;
  }
  const _0x9fbea7 = this.battler();
  if (_0x9fbea7) _0x9fbea7.stepBack();
  this.setBattlerFlip(false), this.requestMotionRefresh();
};

Game_Battler.prototype.performActionMotions = function (_0x5e074d) {
  if (_0x5e074d.isAttack()) this.performAttack();
  else {
    if (_0x5e074d.isGuard()) {
      if ("yFlCT" !== "yFlCT") {
        const _0x237920 = _0x1ef824.parameters[0];
        if (_0x237920.match(/<ONCE PARALLEL WHEN START BATTLE>/i)) return true;
      } else this.requestMotion("guard");
    } else {
      if (_0x5e074d.isMagical()) this.requestMotion("spell");
      else {
        if (_0x5e074d.isSkill())
          [1, 2, 5, 6]["includes"](_0x5e074d.item()["damage"]["type"])
            ? this.performAttack()
            : this.requestMotion("skill");
        else _0x5e074d.isItem() && this.requestMotion("item");
      }
    }
  }
};

Game_Battler.prototype.getAttackMotion = function () {
  return $dataSystem.attackMotions[0];
};

Game_Battler.prototype.getAttackWeaponAnimationId = function () {
  const _0x5312ae = this.getAttackMotion();
  return _0x5312ae ? _0x5312ae.weaponImageId : 0;
};

Game_Battler.prototype.performSubstitute = function (_0x4ab475) {
  if (!$gameSystem.isSideView()) return;
  const _0x4a5e9a = this.battler();
  const _0x258cc7 = _0x4ab475.battler();
  if (!_0x4a5e9a || !_0x258cc7) return;
  const _0x3332c8 = _0x258cc7._baseX;
  const _0x236d07 = _0x258cc7._baseY;
  this.moveBattlerToPoint(_0x3332c8, _0x236d07, 0, false, "Linear", -1),
    _0x4a5e9a.updatePosition();
  const _0x31be61 = VisuMZ.BattleCore.Settings.ActionSequence;
  let _0xf532c1 = (_0x258cc7.width + _0x4a5e9a.width) / 2;
  _0xf532c1 *= this.isActor() ? 1 : -1;
  let _0x26d935 = _0x31be61.StepDistanceY * (this.isActor() ? 1 : -1);
  _0x4ab475.moveBattlerDistance(_0xf532c1, _0x26d935, 0, false, "Linear"),
    _0x258cc7.updatePosition();
};

Game_Battler.prototype.requestMotion = function (_0x2e1e81) {
  if (SceneManager.isSceneBattle()) {
    if ("vWWPF" !== "vWWPF") this.setWaitMode("float");
    else {
      const _0xf3cc27 = this.battler();
      _0xf3cc27 &&
        (_0xf3cc27.forceMotion(_0x2e1e81),
        ["swing", "thrust", "missile"]["includes"](_0x2e1e81) &&
          this.performWeaponAnimation());
    }
  }
  this.clearFreezeMotion();
};

Game_Battler.prototype.performWeaponAnimation = function () {};

Game_Battler.prototype.startWeaponAnimation = function (_0x2d16d6) {
  if (SceneManager.isSceneBattle()) {
    const _0x5b103f = this.battler();
    if (_0x5b103f) _0x5b103f.forceWeaponAnimation(_0x2d16d6);
  }
};

Game_Battler.prototype.startAttackWeaponAnimation = function () {
  if (SceneManager.isSceneBattle()) {
    const _0x1afb99 = this.getAttackWeaponAnimationId();
    this.startWeaponAnimation(_0x1afb99);
  }
};

Game_Battler.prototype.performCastAnimation = function (_0xc6fcfe, _0x5d9dfe) {
  if (!_0xc6fcfe) return;
  if (!_0xc6fcfe.item()) return;
  if (_0xc6fcfe.isAttack()) return;
  if (_0xc6fcfe.isGuard()) return;
  if (_0xc6fcfe.isItem()) return;
  if ($gameTemp._playTestFastMode) return;
  let _0xc718e = 0;
  const _0x59d514 = VisuMZ.BattleCore.Settings.ActionSequence;
  const _0x2e2d5a = _0xc6fcfe.item()["note"];
  if (_0x2e2d5a.match(/<CAST ANIMATION: (\d+)>/i))
    _0xc718e = Number(RegExp["$1"]);
  else {
    if (_0x2e2d5a.match(/<NO CAST ANIMATION>/i)) {
      if ("xCFox" !== "pUHis") return;
      